/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.datagen.recipes;

import dev.ftb.mods.ftbic.datagen.FTBICRecipesGen;
import dev.ftb.mods.ftbic.item.FTBICItems;
import dev.ftb.mods.ftbic.world.ResourceElements;
import dev.ftb.mods.ftbic.world.ResourceType;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.level.ItemLike;

public class FTBICFurnaceRecipes
extends FTBICRecipesGen {
    public FTBICFurnaceRecipes(DataGenerator generator) {
        super(generator);
    }

    @Override
    public void add(Consumer<FinishedRecipe> consumer) {
        FTBICFurnaceRecipes.blastAndSmelt(List.of(TIN_ORE, TIN_CHUNK, TIN_DUST), ResourceElements.TIN, ResourceType.INGOT, consumer);
        FTBICFurnaceRecipes.blastAndSmelt(List.of(LEAD_ORE, LEAD_CHUNK, LEAD_DUST), ResourceElements.LEAD, ResourceType.INGOT, consumer);
        FTBICFurnaceRecipes.blastAndSmelt(List.of(IRIDIUM_ORE, IRIDIUM_CHUNK, IRIDIUM_DUST), ResourceElements.IRIDIUM, ResourceType.INGOT, consumer);
        FTBICFurnaceRecipes.blastAndSmelt(List.of(URANIUM_ORE, URANIUM_CHUNK, URANIUM_DUST), ResourceElements.URANIUM, ResourceType.INGOT, consumer);
        FTBICFurnaceRecipes.blastAndSmelt(List.of(ALUMINUM_ORE, ALUMINUM_CHUNK, ALUMINUM_DUST), ResourceElements.ALUMINUM, ResourceType.INGOT, consumer);
        FTBICFurnaceRecipes.blastAndSmelt(List.of(ENDERIUM_DUST), ResourceElements.ENDERIUM, ResourceType.INGOT, consumer);
        FTBICFurnaceRecipes.blastAndSmelt(List.of(BRONZE_DUST), ResourceElements.BRONZE, ResourceType.INGOT, consumer);
        FTBICFurnaceRecipes.blastAndSmelt(List.of(IRON_DUST), (ItemLike)Items.f_42416_, consumer);
        FTBICFurnaceRecipes.blastAndSmelt(List.of(COPPER_DUST), (ItemLike)Items.f_151052_, consumer);
        FTBICFurnaceRecipes.blastAndSmelt(List.of(GOLD_DUST), (ItemLike)Items.f_42417_, consumer);
    }

    private static void blastAndSmelt(List<TagKey<Item>> input, ResourceElements element, ResourceType type, Consumer<FinishedRecipe> consumer) {
        for (TagKey<Item> item : input) {
            SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_204132_(item), (ItemLike)((ItemLike)FTBICItems.getResourceFromType(element, type).orElseThrow().get()), (float)0.7f, (int)200, (SimpleCookingSerializer)RecipeSerializer.f_44091_).m_126132_("has_item", (CriterionTriggerInstance)FTBICFurnaceRecipes.m_206406_(item)).m_126140_(consumer, FTBICFurnaceRecipes.smeltingLoc(item.f_203868_().m_135815_() + "_to_" + type.name().toLowerCase(Locale.ENGLISH)));
            SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_204132_(item), (ItemLike)((ItemLike)FTBICItems.getResourceFromType(element, type).orElseThrow().get()), (float)0.7f, (int)200, (SimpleCookingSerializer)RecipeSerializer.f_44092_).m_126132_("has_item", (CriterionTriggerInstance)FTBICFurnaceRecipes.m_206406_(item)).m_126140_(consumer, FTBICFurnaceRecipes.blastingLoc(item.f_203868_().m_135815_() + "_to_" + type.name().toLowerCase(Locale.ENGLISH)));
        }
    }

    private static void blastAndSmelt(List<TagKey<Item>> input, ItemLike output, Consumer<FinishedRecipe> consumer) {
        for (TagKey<Item> item : input) {
            SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_204132_(item), (ItemLike)output, (float)0.7f, (int)200, (SimpleCookingSerializer)RecipeSerializer.f_44091_).m_126132_("has_item", (CriterionTriggerInstance)FTBICFurnaceRecipes.m_206406_(item)).m_126140_(consumer, FTBICFurnaceRecipes.smeltingLoc(item.f_203868_().m_135815_() + "_to_" + output));
            SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_204132_(item), (ItemLike)output, (float)0.7f, (int)200, (SimpleCookingSerializer)RecipeSerializer.f_44092_).m_126132_("has_item", (CriterionTriggerInstance)FTBICFurnaceRecipes.m_206406_(item)).m_126140_(consumer, FTBICFurnaceRecipes.blastingLoc(item.f_203868_().m_135815_() + "_to_" + output));
        }
    }
}

