/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic;

import dev.ftb.mods.ftbic.util.CraftingMaterial;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.DoubleValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.LongValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import org.jetbrains.annotations.Nullable;

public class FTBICConfig {
    public static SNBTConfig CONFIG = (SNBTConfig)SNBTConfig.create((String)"ftbic").comment(new String[]{"FTB Industrial Contraptions config file"});
    public static Component ENERGY_FORMAT = Component.m_237113_((String)"\u26a1").m_130940_(ChatFormatting.BOLD);
    public static Component HEAT_FORMAT = Component.m_237113_((String)"\ud83d\udd25");
    public static final Energy ENERGY = new Energy();
    public static final Machines MACHINES = new Machines();
    public static final Nuclear NUCLEAR = new Nuclear();
    public static final Equipment EQUIPMENT = new Equipment();
    public static final Recipes RECIPES = new Recipes();
    public static final List<String> MOD_MATERIAL_PRIORITY = new ArrayList<String>(Arrays.asList("minecraft", "emendatusenigmatica", "thermal", "mekanism", "immersiveengineering"));
    public static final Map<String, CraftingMaterial> MATERIALS = new LinkedHashMap<String, CraftingMaterial>();

    public static void addMaterial(String m) {
        MATERIALS.put(m, new CraftingMaterial(m));
    }

    public static void removeMaterial(String m) {
        MATERIALS.remove(m);
    }

    private static int getOrder(@Nullable ResourceLocation id) {
        int i = id == null ? -1 : MOD_MATERIAL_PRIORITY.indexOf(id.m_135827_());
        return i == -1 ? MOD_MATERIAL_PRIORITY.size() : i;
    }

    public static Item getItemFromTag(TagKey<Item> tag) {
        ITag items = ForgeRegistries.ITEMS.tags().getTag(tag);
        if (items.isEmpty()) {
            return Items.f_41852_;
        }
        if (items.size() == 1) {
            return (Item)items.iterator().next();
        }
        int order = Integer.MAX_VALUE;
        Item current = null;
        for (Item item : items) {
            int o = FTBICConfig.getOrder(Registry.f_122827_.m_7981_((Object)item));
            if (o == 0) {
                return item;
            }
            if (current != null && o >= order) continue;
            current = item;
            order = o;
        }
        return current;
    }

    public static void init() {
    }

    static {
        FTBICConfig.addMaterial("iron");
        FTBICConfig.addMaterial("gold");
        FTBICConfig.addMaterial("netherite");
        FTBICConfig.addMaterial("copper");
        FTBICConfig.addMaterial("aluminum");
        FTBICConfig.addMaterial("silver");
        FTBICConfig.addMaterial("lead");
        FTBICConfig.addMaterial("nickel");
        FTBICConfig.addMaterial("uranium");
        FTBICConfig.addMaterial("osmium");
        FTBICConfig.addMaterial("tin");
        FTBICConfig.addMaterial("zinc");
        FTBICConfig.addMaterial("cobalt");
        FTBICConfig.addMaterial("bronze");
        FTBICConfig.addMaterial("brass");
        FTBICConfig.addMaterial("constantan");
        FTBICConfig.addMaterial("electrum");
        FTBICConfig.addMaterial("steel");
        FTBICConfig.addMaterial("invar");
        FTBICConfig.addMaterial("signalum");
        FTBICConfig.addMaterial("lumium");
        FTBICConfig.addMaterial("enderium");
        FTBICConfig.addMaterial("iridium");
        FTBICConfig.addMaterial("cast_iron");
        FTBICConfig.addMaterial("tungsten");
        FTBICConfig.addMaterial("lithium");
        FTBICConfig.addMaterial("titanium");
        FTBICConfig.addMaterial("lapis");
        FTBICConfig.addMaterial("diamond");
        FTBICConfig.addMaterial("emerald");
        FTBICConfig.addMaterial("quartz");
        FTBICConfig.addMaterial("prismarine");
        FTBICConfig.addMaterial("certus_quartz");
        FTBICConfig.addMaterial("charged_certus_quartz");
        FTBICConfig.addMaterial("fluix");
        FTBICConfig.addMaterial("fluorite");
        FTBICConfig.addMaterial("bitumen");
        FTBICConfig.addMaterial("cinnabar");
        FTBICConfig.addMaterial("apatite");
        FTBICConfig.addMaterial("sulfur");
        FTBICConfig.addMaterial("potassium_nitrate");
        FTBICConfig.addMaterial("mana");
        FTBICConfig.addMaterial("dimensional");
        FTBICConfig.addMaterial("silicon");
        FTBICConfig.addMaterial("ruby");
        FTBICConfig.addMaterial("sapphire");
        FTBICConfig.addMaterial("peridot");
        FTBICConfig.addMaterial("redstone");
    }

    public static final class Energy {
        private static final SNBTConfig ENERGY = CONFIG.getGroup("Energy");
        public final DoubleValue LV_TRANSFER_RATE = (DoubleValue)ENERGY.getDouble("Lv Transfer Rate", 32.0, 1.0, Double.POSITIVE_INFINITY).comment(new String[]{"Lv Transfer Rate (how much energy is transferred per tick)"});
        public final DoubleValue MV_TRANSFER_RATE = (DoubleValue)ENERGY.getDouble("Mv Transfer Rate", 128.0, 1.0, Double.POSITIVE_INFINITY).comment(new String[]{"Mv Transfer Rate (how much energy is transferred per tick)"});
        public final DoubleValue HV_TRANSFER_RATE = (DoubleValue)ENERGY.getDouble("Hv Transfer Rate", 512.0, 1.0, Double.POSITIVE_INFINITY).comment(new String[]{"Hv Transfer Rate (how much energy is transferred per tick)"});
        public final DoubleValue EV_TRANSFER_RATE = (DoubleValue)ENERGY.getDouble("Ev Transfer Rate", 2048.0, 1.0, Double.POSITIVE_INFINITY).comment(new String[]{"Ev Transfer Rate (how much energy is transferred per tick)"});
        public final DoubleValue IV_TRANSFER_RATE = (DoubleValue)ENERGY.getDouble("Iv Transfer Rate", 8192.0, 1.0, Double.POSITIVE_INFINITY).comment(new String[]{"Iv Transfer Rate (how much energy is transferred per tick)"});
        public final DoubleValue ZAP_TO_FE_CONVERSION_RATE = (DoubleValue)ENERGY.getDouble("Zap To Fe Conversion Rate", 4.0, 0.0, Double.POSITIVE_INFINITY).comment(new String[]{"The amount of Zaps to FE"});
        public final DoubleValue SINGLE_USE_BATTERY_CAPACITY = (DoubleValue)ENERGY.getDouble("Single Use Battery Capacity", 2400.0, 1.0, Double.POSITIVE_INFINITY).comment(new String[]{"The amount of energy a single use battery can contain"});
        public final DoubleValue LV_BATTERY_CAPACITY = (DoubleValue)ENERGY.getDouble("Lv Battery Capacity", 4000.0, 1.0, Double.POSITIVE_INFINITY).comment(new String[]{"Energy a Lv Battery can contain"});
        public final DoubleValue MV_BATTERY_CAPACITY = (DoubleValue)ENERGY.getDouble("Mv Battery Capacity", 40000.0, 1.0, Double.POSITIVE_INFINITY).comment(new String[]{"Energy a Mv Battery can contain"});
        public final DoubleValue HV_BATTERY_CAPACITY = (DoubleValue)ENERGY.getDouble("Hv Battery Capacity", 400000.0, 1.0, Double.POSITIVE_INFINITY).comment(new String[]{"Energy a Hv Battery can contain"});
        public final DoubleValue EV_BATTERY_CAPACITY = (DoubleValue)ENERGY.getDouble("Ev Battery Capacity", 1.0E7, 1.0, Double.POSITIVE_INFINITY).comment(new String[]{"Energy a Ev Battery can contain"});
        public final DoubleValue LV_BATTERY_BOX_CAPACITY = (DoubleValue)ENERGY.getDouble("Lv Battery Box Capacity", 40000.0, 1.0, Double.POSITIVE_INFINITY).comment(new String[]{"Energy a Lv Battery Box can contain"});
        public final DoubleValue MV_BATTERY_BOX_CAPACITY = (DoubleValue)ENERGY.getDouble("Mv Battery Box Capacity", 400000.0, 1.0, Double.POSITIVE_INFINITY).comment(new String[]{"Energy a Mv Battery Box can contain"});
        public final DoubleValue HV_BATTERY_BOX_CAPACITY = (DoubleValue)ENERGY.getDouble("Hv Battery Box Capacity", 4000000.0, 1.0, Double.POSITIVE_INFINITY).comment(new String[]{"Energy a Hv Battery Box can contain"});
        public final DoubleValue EV_BATTERY_BOX_CAPACITY = (DoubleValue)ENERGY.getDouble("Ev Battery Box Capacity", 4.0E7, 1.0, Double.POSITIVE_INFINITY).comment(new String[]{"Energy a Ev Battery Box can contain"});
        public final IntValue MAX_CABLE_LENGTH = (IntValue)ENERGY.getInt("Max Cable Length", 300, 1, 100000).comment(new String[]{"Max length of a cable chain", "The higher the number, the more tick lag will likely present."});
    }

    public static final class Machines {
        private static final SNBTConfig MACHINES = CONFIG.getGroup("Machines");
        public final IntValue IRON_FURNACE_ITEMS_PER_COAL = (IntValue)MACHINES.getInt("Items processed per fuel", 12, 1, 1000).comment(new String[]{"How many items are processed per fuel in the Iron Furnace"});
        public final DoubleValue BASIC_GENERATOR_CAPACITY = (DoubleValue)MACHINES.getDouble("Basic generator capacity", 4000.0, 1.0, 100000.0).comment(new String[]{"Amount of energy is stored in the Basic generator"});
        public final DoubleValue BASIC_GENERATOR_OUTPUT = (DoubleValue)MACHINES.getDouble("Basic generator output", 10.0, 1.0, 100000.0).comment(new String[]{"Energy created from the Basic generator"});
        public final IntValue GEOTHERMAL_GENERATOR_TANK_SIZE = (IntValue)MACHINES.getInt("Geothermal generator tank size", 8000, 1000, 10000).comment(new String[]{"The internal size of the Geothermal generator"});
        public final DoubleValue GEOTHERMAL_GENERATOR_CAPACITY = (DoubleValue)MACHINES.getDouble("Geothermal generator capacity", 2400.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Geothermal Generator"});
        public final DoubleValue GEOTHERMAL_GENERATOR_OUTPUT = (DoubleValue)MACHINES.getDouble("Geothermal generator output", 20.0, 1.0, 100000.0).comment(new String[]{"Energy created from the Geothermal generator"});
        public final DoubleValue WIND_MILL_CAPACITY = (DoubleValue)MACHINES.getDouble("Wind mill capacity", 100.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Wind Mill"});
        public final DoubleValue WIND_MILL_MIN_OUTPUT = (DoubleValue)MACHINES.getDouble("Wind mill min output", 0.3, 0.001, 100000.0).comment(new String[]{"The min amount of energy the wind mill can output"});
        public final DoubleValue WIND_MILL_MAX_OUTPUT = (DoubleValue)MACHINES.getDouble("Wind mill max output", 6.5, 0.001, 1000000.0).comment(new String[]{"The max amount of energy the wind mill can output"});
        public final IntValue WIND_MILL_MIN_Y = (IntValue)MACHINES.getInt("Wind mill min y", 64, 0, 250).comment(new String[]{"Minimum height that the windmill is effective from"});
        public final IntValue WIND_MILL_MAX_Y = (IntValue)MACHINES.getInt("Wind mill max y", 320, 0, 320).comment(new String[]{"Maximum height that the windmill is effective from "});
        public final DoubleValue WIND_MILL_RAIN_MODIFIER = (DoubleValue)MACHINES.getDouble("Wind mill rain modifier", 1.2, 0.001, 5000.0).comment(new String[]{"How much rain effects the energy production"});
        public final DoubleValue WIND_MILL_THUNDER_MODIFIER = (DoubleValue)MACHINES.getDouble("Wind mill thunder modifier", 1.5, 0.001, 5000.0).comment(new String[]{"How much thunder effects the energy production"});
        public final DoubleValue LV_SOLAR_PANEL_OUTPUT = (DoubleValue)MACHINES.getDouble("Lv solar panel output", 1.0, 1.0, 100000.0).comment(new String[]{"Energy created from the Lv solar panel"});
        public final DoubleValue MV_SOLAR_PANEL_OUTPUT = (DoubleValue)MACHINES.getDouble("Mv solar panel output", 8.0, 1.0, 100000.0).comment(new String[]{"Energy created from the Mv solar panel"});
        public final DoubleValue HV_SOLAR_PANEL_OUTPUT = (DoubleValue)MACHINES.getDouble("Hv solar panel output", 64.0, 1.0, 100000.0).comment(new String[]{"Energy created from the Hv solar panel"});
        public final DoubleValue EV_SOLAR_PANEL_OUTPUT = (DoubleValue)MACHINES.getDouble("Ev solar panel output", 512.0, 1.0, 100000.0).comment(new String[]{"Energy created from the Ev solar panel"});
        public final DoubleValue LV_SOLAR_PANEL_CAPACITY = (DoubleValue)MACHINES.getDouble("Lv solar panel capacity", 60.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Lv solar panel"});
        public final DoubleValue MV_SOLAR_PANEL_CAPACITY = (DoubleValue)MACHINES.getDouble("Mv solar panel capacity", 480.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Mv solar panel"});
        public final DoubleValue HV_SOLAR_PANEL_CAPACITY = (DoubleValue)MACHINES.getDouble("Hv solar panel capacity", 3840.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored inm the Hv solar panel"});
        public final DoubleValue EV_SOLAR_PANEL_CAPACITY = (DoubleValue)MACHINES.getDouble("Ev solar panel capacity", 30720.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Ev solar panel"});
        public final DoubleValue NUCLEAR_REACTOR_CAPACITY = (DoubleValue)MACHINES.getDouble("Nuclear reactor capacity", 50000.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Nuclear Reactor"});
        public final DoubleValue MACHINE_RECIPE_BASE_TICKS = (DoubleValue)MACHINES.getDouble("Machine recipe base ticks", 200.0, 1.0, 100000.0).comment(new String[]{"Base lengths in ticks a machine takes to process a recipe"});
        public final DoubleValue POWERED_FURNACE_CAPACITY = (DoubleValue)MACHINES.getDouble("Powered furnace capacity", 1200.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Powered Furnace"});
        public final DoubleValue POWERED_FURNACE_USE = (DoubleValue)MACHINES.getDouble("Powered furnace use", 3.0, 0.0, 100000.0).comment(new String[]{"Energy usage per operation of the powered furnace"});
        public final DoubleValue MACERATOR_CAPACITY = (DoubleValue)MACHINES.getDouble("Macerator capacity", 1200.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Macerator"});
        public final DoubleValue MACERATOR_USE = (DoubleValue)MACHINES.getDouble("Macerator use", 2.0, 0.0, 100000.0).comment(new String[]{"Energy usage of the Macerator"});
        public final DoubleValue CENTRIFUGE_CAPACITY = (DoubleValue)MACHINES.getDouble("Centrifuge capacity", 1200.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Centrifuge"});
        public final DoubleValue CENTRIFUGE_USE = (DoubleValue)MACHINES.getDouble("Centrifuge use", 2.0, 0.0, 100000.0).comment(new String[]{"Energy usage of the Centrifuge"});
        public final DoubleValue COMPRESSOR_CAPACITY = (DoubleValue)MACHINES.getDouble("Compressor capacity", 1200.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Compressor"});
        public final DoubleValue COMPRESSOR_USE = (DoubleValue)MACHINES.getDouble("Compressor use", 2.0, 0.0, 100000.0).comment(new String[]{"Energy usage of the Compressor"});
        public final DoubleValue REPROCESSOR_CAPACITY = (DoubleValue)MACHINES.getDouble("Reprocessor capacity", 4000.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Reprocessor"});
        public final DoubleValue REPROCESSOR_USE = (DoubleValue)MACHINES.getDouble("Reprocessor use", 8.0, 0.0, 100000.0).comment(new String[]{"Energy usage of the Reprocessor"});
        public final DoubleValue CANNING_MACHINE_CAPACITY = (DoubleValue)MACHINES.getDouble("Canning machine capacity", 1200.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Canning Machine"});
        public final DoubleValue CANNING_MACHINE_USE = (DoubleValue)MACHINES.getDouble("Canning machine use", 1.0, 0.0, 100000.0).comment(new String[]{"Energy usage of the Canning machine"});
        public final DoubleValue ROLLER_CAPACITY = (DoubleValue)MACHINES.getDouble("Roller capacity", 1200.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Roller"});
        public final DoubleValue ROLLER_USE = (DoubleValue)MACHINES.getDouble("Roller use", 3.0, 0.0, 100000.0).comment(new String[]{"Energy usage of the Roller"});
        public final DoubleValue EXTRUDER_CAPACITY = (DoubleValue)MACHINES.getDouble("Extruder capacity", 1200.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Extruder"});
        public final DoubleValue EXTRUDER_USE = (DoubleValue)MACHINES.getDouble("Extruder use", 3.0, 0.0, 100000.0).comment(new String[]{"Energy usage of the Extruder"});
        public final DoubleValue ANTIMATTER_CONSTRUCTOR_CAPACITY = (DoubleValue)MACHINES.getDouble("Antimatter constructor capacity", 1000000.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Antimatter Constructor"});
        public final DoubleValue ANTIMATTER_CONSTRUCTOR_BOOST = (DoubleValue)MACHINES.getDouble("Antimatter constructor boost", 6.0, 1.0, 100000.0).comment(new String[]{"Construction boost multiplier"});
        public final DoubleValue ADVANCED_POWERED_FURNACE_CAPACITY = (DoubleValue)MACHINES.getDouble("Advanced powered furnace capacity", 10000.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Advanced Powered Furnace"});
        public final DoubleValue ADVANCED_POWERED_FURNACE_USE = (DoubleValue)MACHINES.getDouble("Advanced powered furnace use", 16.0, 0.0, 100000.0).comment(new String[]{"Energy usage of the Advanced powered furnace"});
        public final DoubleValue ADVANCED_MACERATOR_CAPACITY = (DoubleValue)MACHINES.getDouble("Advanced macerator capacity", 10000.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Advanced Macerator"});
        public final DoubleValue ADVANCED_MACERATOR_USE = (DoubleValue)MACHINES.getDouble("Advanced macerator use", 16.0, 0.0, 100000.0).comment(new String[]{"Energy usage of the Advanced macerator"});
        public final DoubleValue ADVANCED_CENTRIFUGE_CAPACITY = (DoubleValue)MACHINES.getDouble("Advanced centrifuge capacity", 10000.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Advanced Centrifuge"});
        public final DoubleValue ADVANCED_CENTRIFUGE_USE = (DoubleValue)MACHINES.getDouble("Advanced centrifuge use", 16.0, 0.0, 100000.0).comment(new String[]{"Energy usage of the Advanced centrifuge"});
        public final DoubleValue ADVANCED_COMPRESSOR_CAPACITY = (DoubleValue)MACHINES.getDouble("Advanced compressor capacity", 10000.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Advanced Compressor"});
        public final DoubleValue ADVANCED_COMPRESSOR_USE = (DoubleValue)MACHINES.getDouble("Advanced compressor use", 16.0, 0.0, 100000.0).comment(new String[]{"Energy usage of the Advanced compressor"});
        public final DoubleValue TELEPORTER_CAPACITY = (DoubleValue)MACHINES.getDouble("Teleporter capacity", 1000000.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Teleporter"});
        public final DoubleValue TELEPORTER_MIN_USE = (DoubleValue)MACHINES.getDouble("Teleporter min use", 100.0, 0.0, 100000.0).comment(new String[]{"Energy usage of the Teleporter min"});
        public final DoubleValue TELEPORTER_MIN_DISTANCE = (DoubleValue)MACHINES.getDouble("Teleporter min distance", 16.0, 1.0, 100000.0).comment(new String[]{"Min distance a teleporter can work over"});
        public final DoubleValue TELEPORTER_MAX_USE = (DoubleValue)MACHINES.getDouble("Teleporter max use", 10000.0, 0.0, 100000.0).comment(new String[]{"Energy usage of the Teleporter max"});
        public final DoubleValue TELEPORTER_MAX_DISTANCE = (DoubleValue)MACHINES.getDouble("Teleporter max distance", 1200.0, 1.0, 100000.0).comment(new String[]{"Max distance a teleporter can work over"});
        public final DoubleValue CHARGE_PAD_CAPACITY = (DoubleValue)MACHINES.getDouble("Charge pad capacity", 1000000.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Charge Pad"});
        public final DoubleValue POWERED_CRAFTING_TABLE_CAPACITY = (DoubleValue)MACHINES.getDouble("Powered crafting table capacity", 1200.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Powered Crafting Table"});
        public final DoubleValue POWERED_CRAFTING_TABLE_USE = (DoubleValue)MACHINES.getDouble("Powered crafting table use", 1.0, 0.0, 100000.0).comment(new String[]{"Energy usage of the Powered crafting table"});
        public final DoubleValue QUARRY_CAPACITY = (DoubleValue)MACHINES.getDouble("Quarry capacity", 10000.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Quarry"});
        public final DoubleValue QUARRY_USE = (DoubleValue)MACHINES.getDouble("Quarry use", 3.0, 0.0, 100000.0).comment(new String[]{"Energy usage of the Quarry"});
        public final LongValue QUARRY_MINE_TICKS = (LongValue)MACHINES.getLong("Quarry mine ticks", 40L, 0L, 100000L).comment(new String[]{"Duration taken to mine a block using the quarry"});
        public final LongValue QUARRY_MOVE_TICKS = (LongValue)MACHINES.getLong("Quarry move ticks", 10L, 0L, 100000L).comment(new String[]{"Duration taken to move the quarry to a new location"});
        public final BooleanValue QUARRY_REPLACE_FLUID_EXFLUID = (BooleanValue)MACHINES.getBoolean("Quarry replace fluid with exfluid", true).comment(new String[]{"Whether blocks under fluid sources are replaced with exfluid on dig"});
        public final DoubleValue PUMP_CAPACITY = (DoubleValue)MACHINES.getDouble("Pump capacity", 10000.0, 1.0, 100000.0).comment(new String[]{"Amount of energy stored in the Pump"});
        public final DoubleValue PUMP_USE = (DoubleValue)MACHINES.getDouble("Pump use", 3.0, 0.0, 100000.0).comment(new String[]{"Energy usage of the Pump"});
        public final LongValue PUMP_MINE_TICKS = (LongValue)MACHINES.getLong("Pump mine ticks", 40L, 0L, 100000L).comment(new String[]{"Duration taken to mine a fluid using the pump"});
        public final LongValue PUMP_MOVE_TICKS = (LongValue)MACHINES.getLong("Pump move ticks", 10L, 0L, 100000L).comment(new String[]{"Duration taken to move the pump to a new location"});
        public final BooleanValue PUMP_REPLACE_FLUID_EXFLUID = (BooleanValue)MACHINES.getBoolean("Pump replace fluid with exfluid", true).comment(new String[]{"Whether fluid sources are replaced with exfluid on pump"});
        public final IntValue PUMP_TANK_CAPACITY = (IntValue)MACHINES.getInt("Pump tank capacity", 128000, 1, 100000).comment(new String[]{"Amount of energy stored in the Pump Tank"});
        public final DoubleValue ITEM_TRANSFER_EFFICIENCY = (DoubleValue)MACHINES.getDouble("Item transfer efficiency", 20.0, 0.0, Double.POSITIVE_INFINITY).comment(new String[]{"Determines how effective an item can transport energy to something else"});
        public final IntValue STATE_UPDATE_TICKS = (IntValue)MACHINES.getInt("State update ticks", 6, 1, 1000).comment(new String[]{"To reduce lag, we only update a state of a block every X ticks. This controls how many ticks we wait to update the blocks state."});
        public final IntValue UPGRADE_LIMIT_PER_SLOT = (IntValue)MACHINES.getInt("Upgrade limit per slot", 4, 1, 64).comment(new String[]{"Amount of upgrades allowed in each slot of a machine"});
        public final DoubleValue OVERCLOCKER_SPEED = (DoubleValue)MACHINES.getDouble("Overclocker speed", 1.45, 0.0, 100000.0).comment(new String[]{"Speed increase from a single overclocking upgrade"});
        public final DoubleValue OVERCLOCKER_ENERGY_USE = (DoubleValue)MACHINES.getDouble("Overclocker energy use", 1.6, 0.0, 100000.0).comment(new String[]{"Energy usage of the Overclocker"});
        public final DoubleValue STORAGE_UPGRADE = (DoubleValue)MACHINES.getDouble("Storage upgrade", 10000.0, 0.0, 100000.0).comment(new String[]{"Energy cost per storage"});
        public final DoubleValue SCRAP_CHANCE = (DoubleValue)MACHINES.getDouble("Scrap chance", 0.125, 0.0, 1.0).comment(new String[]{"Chance of producing scrap"});
    }

    public static final class Nuclear {
        SNBTConfig NUCLEAR = CONFIG.getGroup("Nuclear");
        public final DoubleValue NUKE_RADIUS = (DoubleValue)this.NUCLEAR.getDouble("Nuke Radius", 36.0, 1.0, 1000.0).comment(new String[]{"How many blocks in a circular radius the nuke will effect"});
        public final DoubleValue NUCLEAR_REACTOR_EXPLOSION_BASE_RADIUS = (DoubleValue)this.NUCLEAR.getDouble("Base Nuclear blast radius", 10.0, 1.0, 1000.0).comment(new String[]{"The starting radius for a nuclear reactor explosion"});
        public final DoubleValue NUCLEAR_REACTOR_EXPLOSION_MULTIPLIER = (DoubleValue)this.NUCLEAR.getDouble("Nuclear blast radius multiplier", 0.5, 0.001, 100.0).comment(new String[]{"How much to multiple the above base radius of the explosion"});
        public final DoubleValue NUCLEAR_REACTOR_EXPLOSION_LIMIT = (DoubleValue)this.NUCLEAR.getDouble("Nuclear blast limit", 80.0, 1.0, 10000.0).comment(new String[]{"The limit of how large an explosion can be"});
        public final IntValue FLUID_CELL_CAPACITY = (IntValue)this.NUCLEAR.getInt("Fluid cell capacity", 1000, 1, 100000).comment(new String[]{"How much fluid a fluid cell can contain"});
        public final BooleanValue ADD_ALL_FLUID_CELLS = (BooleanValue)this.NUCLEAR.getBoolean("Add all fluid cells", false).comment(new String[]{"Add all fluid cells to creative tab"});
        public final BooleanValue NUCLEAR_EXPLOSION_DAEMON_THREAD = (BooleanValue)this.NUCLEAR.getBoolean("Explosion uses deamon thread", false).comment(new String[]{"Spawn a deamon thread to handle the explosion calculation (experimental)"});
    }

    public static final class Equipment {
        private static SNBTConfig EQUIPMENT = CONFIG.getGroup("Equipment");
        public final DoubleValue CARBON_ARMOR_CAPACITY = (DoubleValue)EQUIPMENT.getDouble("Carbon armor capacity", 1000000.0, 0.0, Double.POSITIVE_INFINITY).comment(new String[]{"Max energy the Carbon armor can contain"});
        public final DoubleValue QUANTUM_ARMOR_CAPACITY = (DoubleValue)EQUIPMENT.getDouble("Quantum armor capacity", 1.5E7, 0.0, Double.POSITIVE_INFINITY).comment(new String[]{"Max energy the Quantum armor can contain"});
        public final DoubleValue MECHANICAL_ELYTRA_CAPACITY = (DoubleValue)EQUIPMENT.getDouble("Mechanical elytra capacity", 50000.0, 0.0, Double.POSITIVE_INFINITY).comment(new String[]{"Max energy that the elytra can contain"});
        public final DoubleValue MECHANICAL_ELYTRA_RECHARGE = (DoubleValue)EQUIPMENT.getDouble("Mechanical elytra recharge", 1.0, 0.0, 100000.0).comment(new String[]{"How much power is recharged passively"});
        public final DoubleValue ARMOR_DAMAGE_ENERGY = (DoubleValue)EQUIPMENT.getDouble("Armor damage energy", 5000.0, 0.0, Double.POSITIVE_INFINITY).comment(new String[]{"Armor damage energy"});
        public final DoubleValue ARMOR_FLIGHT_ENERGY = (DoubleValue)EQUIPMENT.getDouble("Armor flight energy", 5.0, 0.0, Double.POSITIVE_INFINITY).comment(new String[]{"Armor flight engery"});
        public final DoubleValue ARMOR_FLIGHT_BOOST = (DoubleValue)EQUIPMENT.getDouble("Armor flight boost", 50.0, 0.0, 100000.0).comment(new String[]{"Boost gained from wearing the armor during flight"});
        public final DoubleValue ARMOR_FLIGHT_STOP = (DoubleValue)EQUIPMENT.getDouble("Armor flight stop", 15.0, 0.0, 100000.0).comment(new String[]{"Force used to stop flight"});
    }

    public static final class Recipes {
        SNBTConfig RECIPES = CONFIG.getGroup("Recipes");
        public final BooleanValue ADD_DUST_FROM_ORE_RECIPES = (BooleanValue)this.RECIPES.getBoolean("Create dust from ore recipes", true).comment(new String[]{"Automatically generate dust from ore recipes"});
        public final BooleanValue ADD_DUST_FROM_MATERIAL_RECIPES = (BooleanValue)this.RECIPES.getBoolean("Create dust from material recipes", true).comment(new String[]{"Automatically generate dust from material recipes"});
        public final BooleanValue ADD_GEM_FROM_ORE_RECIPES = (BooleanValue)this.RECIPES.getBoolean("Create gem from ore recipes", true).comment(new String[]{"Automatically generate gem from ore recipes"});
        public final BooleanValue ADD_ROD_RECIPES = (BooleanValue)this.RECIPES.getBoolean("Create rod recipes", true).comment(new String[]{"Automatically generate rod recipes"});
        public final BooleanValue ADD_PLATE_RECIPES = (BooleanValue)this.RECIPES.getBoolean("Create plate recipes", true).comment(new String[]{"Automatically generate plate recipes"});
        public final BooleanValue ADD_GEAR_RECIPES = (BooleanValue)this.RECIPES.getBoolean("Create gear recipes", true).comment(new String[]{"Automatically generate gear recipes"});
        public final BooleanValue ADD_CANNED_FOOD_RECIPES = (BooleanValue)this.RECIPES.getBoolean("Create canned food recipes", true).comment(new String[]{"Automatically canned food recipes"});
    }
}

