/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.twitch;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamAudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioItem;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.felnull.imp.include.org.apache.http.client.config.RequestConfig;
import dev.felnull.imp.include.org.apache.http.client.methods.HttpGet;
import dev.felnull.imp.include.org.apache.http.client.methods.HttpPost;
import dev.felnull.imp.include.org.apache.http.client.methods.HttpUriRequest;
import dev.felnull.imp.include.org.apache.http.entity.StringEntity;
import dev.felnull.imp.include.org.apache.http.impl.client.HttpClientBuilder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TwitchStreamAudioSourceManager
implements AudioSourceManager,
HttpConfigurable {
    private static final String STREAM_NAME_REGEX = "^https://(?:www\\.|go\\.|m\\.)?twitch.tv/([^/]+)$";
    private static final Pattern streamNameRegex = Pattern.compile("^https://(?:www\\.|go\\.|m\\.)?twitch.tv/([^/]+)$");
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
    private final String twitchClientId;

    public TwitchStreamAudioSourceManager() {
        this("jzkbprff40iqj646a697cyrvl0zt2m6");
    }

    public TwitchStreamAudioSourceManager(String clientId) {
        this.twitchClientId = clientId;
    }

    public String getClientId() {
        return this.twitchClientId;
    }

    @Override
    public String getSourceName() {
        return "twitch";
    }

    @Override
    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        String streamName = TwitchStreamAudioSourceManager.getChannelIdentifierFromUrl(reference.identifier);
        if (streamName == null) {
            return null;
        }
        JsonBrowser accessToken = this.fetchAccessToken(streamName);
        if (accessToken == null || accessToken.get("data").get("streamPlaybackAccessToken").get("value").isNull()) {
            return AudioReference.NO_TRACK;
        }
        JsonBrowser channelInfo = this.fetchStreamChannelInfo(streamName).get("data").get("user");
        if (channelInfo == null || channelInfo.get("stream").get("type").isNull()) {
            return AudioReference.NO_TRACK;
        }
        String displayName = streamName;
        String title = channelInfo.get("lastBroadcast").get("title").text();
        return new TwitchStreamAudioTrack(new AudioTrackInfo(title, displayName, Long.MAX_VALUE, reference.identifier, true, reference.identifier), this);
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) throws IOException {
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        return new TwitchStreamAudioTrack(trackInfo, this);
    }

    public static String getChannelIdentifierFromUrl(String url) {
        Matcher matcher = streamNameRegex.matcher(url);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1);
    }

    public HttpUriRequest createGetRequest(String url) {
        return TwitchStreamAudioSourceManager.addClientHeaders(new HttpGet(url), this.twitchClientId);
    }

    public HttpUriRequest createGetRequest(URI url) {
        return TwitchStreamAudioSourceManager.addClientHeaders(new HttpGet(url), this.twitchClientId);
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    @Override
    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }

    private static HttpUriRequest addClientHeaders(HttpUriRequest request, String clientId) {
        request.setHeader("Client-ID", clientId);
        return request;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonBrowser fetchAccessToken(String name) {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            HttpPost post = new HttpPost("https://gql.twitch.tv/gql");
            TwitchStreamAudioSourceManager.addClientHeaders(post, "jzkbprff40iqj646a697cyrvl0zt2m6");
            post.setEntity(new StringEntity(String.format("{\"operationName\":\"PlaybackAccessToken_Template\",\"query\":\"query PlaybackAccessToken_Template($login: String!,$isLive:Boolean!,$vodID:ID!,$isVod:Boolean!,$playerType:String!){streamPlaybackAccessToken(channelName:$login,params:{platform:\\\"web\\\",playerBackend:\\\"mediaplayer\\\",playerType:$playerType})@include(if:$isLive){value signature __typename}videoPlaybackAccessToken(id:$vodID,params:{platform:\\\"web\\\",playerBackend:\\\"mediaplayer\\\",playerType:$playerType})@include(if:$isVod){value signature __typename}}\",\"variables\":{\"isLive\":true,\"login\":\"%s\",\"isVod\":false,\"vodID\":\"\",\"playerType\":\"site\"}}", name)));
            JsonBrowser jsonBrowser = HttpClientTools.fetchResponseAsJson(httpInterface, post);
            return jsonBrowser;
        }
        catch (IOException e) {
            throw new FriendlyException("Loading Twitch channel access token failed.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonBrowser fetchStreamChannelInfo(String channelId) {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            HttpPost post = new HttpPost("https://gql.twitch.tv/gql");
            TwitchStreamAudioSourceManager.addClientHeaders(post, "jzkbprff40iqj646a697cyrvl0zt2m6");
            post.setEntity(new StringEntity(String.format("{\"operationName\":\"StreamMetadata\",\"variables\":{\"channelLogin\":\"%s\"},\"extensions\":{\"persistedQuery\":{\"version\":1,\"sha256Hash\":\"1c719a40e481453e5c48d9bb585d971b8b372f8ebb105b17076722264dfa5b3e\"}}}", channelId)));
            JsonBrowser jsonBrowser = HttpClientTools.fetchResponseAsJson(httpInterface, post);
            return jsonBrowser;
        }
        catch (IOException e) {
            throw new FriendlyException("Loading Twitch channel information failed.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    @Override
    public void shutdown() {
        ExceptionTools.closeWithWarnings(this.httpInterfaceManager);
    }
}

