/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.networking.NetworkManager;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.ImageNameBaseMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.ImportYoutubePlayListBaseMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.PlayListBaseMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.SavedPlayListBaseMMMonitor;
import dev.felnull.imp.client.lava.LavaPlayerManager;
import dev.felnull.imp.client.music.media.IMPMusicMedias;
import dev.felnull.imp.client.music.media.MusicMediaResult;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.networking.IMPPackets;
import dev.felnull.otyacraftengine.networking.existence.BlockEntityExistence;
import dev.felnull.otyacraftengine.util.FlagThread;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;

public class CreatePlayListMMMonitor
extends SavedPlayListBaseMMMonitor {
    protected static final Component IMPORT_TEXT = Component.m_237115_((String)"imp.button.import");
    protected static final Component IMPORTING_TEXT = Component.m_237115_((String)"imp.text.importing");
    protected static final Component IMPORT_FAILURE_TEXT = Component.m_237115_((String)"imp.text.importFailure");
    private ImportMusicLoader importMusicLoader;
    private boolean failureImportPlayList;

    public CreatePlayListMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void render(PoseStack poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        Component ipTx = null;
        if (this.isImporting()) {
            ipTx = IMPORTING_TEXT;
        } else if (this.failureImportPlayList) {
            ipTx = IMPORT_FAILURE_TEXT;
        } else if (this.getImportMusicsCount() > 0) {
            ipTx = Component.m_237110_((String)"imp.text.importMusicCount", (Object[])new Object[]{this.getImportMusicsCount()});
        }
        if (ipTx != null) {
            this.drawSmartText(poseStack, ipTx, this.getStartX() + this.width - 95 + 7, this.getStartY() + 184);
        }
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.addRenderWidget(new SmartButton(this.getStartX() + this.width - 95 - 87, this.getStartY() + 180, 87, 15, IMPORT_TEXT, n -> this.insMonitor(MusicManagerBlockEntity.MonitorType.IMPORT_PLAY_LIST_SELECT)));
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        this.renderSmartButtonSprite(poseStack, multiBufferSource, this.width - 95 - 87, 180.0f, 0.004f, 87.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, IMPORT_TEXT, true);
        if (this.getImportMusicsCount(blockEntity) > 0) {
            this.renderSmartTextSprite(poseStack, multiBufferSource, (Component)Component.m_237110_((String)"imp.text.importMusicCount", (Object[])new Object[]{this.getImportMusicsCount(blockEntity)}), this.width - 95 + 7, 184.0f, 0.003f, onPxW, onPxH, monitorHeight, i);
        }
    }

    @Override
    public boolean done(ImageInfo imageInfo, String name) {
        if (this.isImporting()) {
            return false;
        }
        PlayListBaseMMMonitor.PublishingType pubType = this.getPublishingType();
        PlayListBaseMMMonitor.InitialAuthorityType initAuthType = this.getInitialAuthorityType();
        List<UUID> invitePlayers = this.getInvitePlayers();
        String ipl = this.getImportPlayList();
        if (this.getImportMusicsCount() > 0 && !ipl.isEmpty()) {
            this.startImportMusicLoader(ipl);
            return false;
        }
        this.sendAddPacket(imageInfo, name, pubType, initAuthType, invitePlayers, new ArrayList<Music>());
        return true;
    }

    private void sendAddPacket(ImageInfo imageInfo, String name, PlayListBaseMMMonitor.PublishingType pubType, PlayListBaseMMMonitor.InitialAuthorityType initAuthType, List<UUID> invitePlayers, List<Music> importMusics) {
        NetworkManager.sendToServer((ResourceLocation)IMPPackets.MUSIC_PLAYLIST_ADD, (FriendlyByteBuf)new IMPPackets.MusicPlayListMessage(name, imageInfo, pubType == PlayListBaseMMMonitor.PublishingType.PUBLIC, initAuthType == PlayListBaseMMMonitor.InitialAuthorityType.MEMBER, invitePlayers, BlockEntityExistence.getByBlockEntity((BlockEntity)this.getScreen().getBlockEntity()), importMusics).toFBB());
    }

    @Override
    protected ImageNameBaseMMMonitor.DoneType getDoneType() {
        return ImageNameBaseMMMonitor.DoneType.CREATE;
    }

    @Override
    protected MusicManagerBlockEntity.MonitorType getParentType() {
        return MusicManagerBlockEntity.MonitorType.ADD_PLAY_LIST;
    }

    private int getImportMusicsCount() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)blockEntity;
            return this.getImportMusicsCount(musicManagerBlockEntity);
        }
        return 0;
    }

    private void startImportMusicLoader(String id) {
        this.stopImportMusicLoader();
        this.failureImportPlayList = false;
        this.importMusicLoader = new ImportMusicLoader(id);
        this.importMusicLoader.start();
    }

    private void stopImportMusicLoader() {
        if (this.importMusicLoader != null) {
            this.importMusicLoader.stopped();
            this.importMusicLoader = null;
        }
    }

    private String getImportPlayList() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)blockEntity;
            return this.getImportPlayList(musicManagerBlockEntity);
        }
        return "";
    }

    private String getImportPlayList(MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getImportIdentifier((Player)CreatePlayListMMMonitor.mc.f_91074_);
    }

    private int getImportMusicsCount(MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getImportPlayListMusicCount((Player)CreatePlayListMMMonitor.mc.f_91074_);
    }

    private boolean isImporting() {
        return this.importMusicLoader != null && this.importMusicLoader.isAlive();
    }

    private class ImportMusicLoader
    extends FlagThread {
        private final String id;

        private ImportMusicLoader(String id) {
            this.id = id;
        }

        public void run() {
            try {
                if (this.isStopped()) {
                    return;
                }
                ArrayList<Music> musics = new ArrayList<Music>();
                Pair<AudioPlaylist, List<AudioTrack>> pl = LavaPlayerManager.getInstance().loadTracks(this.id);
                if (this.isStopped()) {
                    return;
                }
                if (pl.getLeft() == null) {
                    throw new IllegalStateException("Not PlayList");
                }
                for (AudioTrack track : (List)pl.getRight()) {
                    if (!track.getInfo().isStream) {
                        MusicMediaResult ret = IMPMusicMedias.YOUTUBE.createResult(track);
                        ImportYoutubePlayListBaseMMMonitor.YoutubePlayListEntry en = new ImportYoutubePlayListBaseMMMonitor.YoutubePlayListEntry(ret.name(), ret.author(), ret.source(), ret.imageInfo());
                        Music music = new Music(UUID.randomUUID(), en.name(), en.artist(), en.source(), en.imageInfo(), IIMPSmartRender.mc.f_91074_.m_36316_().getId(), System.currentTimeMillis());
                        musics.add(music);
                    }
                    if (!this.isStopped()) continue;
                    return;
                }
                if (this.isStopped()) {
                    return;
                }
                IIMPSmartRender.mc.m_18707_(() -> {
                    ImageInfo imageInfo = CreatePlayListMMMonitor.this.getImage();
                    String name = CreatePlayListMMMonitor.this.getName();
                    PlayListBaseMMMonitor.PublishingType pubType = CreatePlayListMMMonitor.this.getPublishingType();
                    PlayListBaseMMMonitor.InitialAuthorityType initAuthType = CreatePlayListMMMonitor.this.getInitialAuthorityType();
                    List<UUID> invitePlayers = CreatePlayListMMMonitor.this.getInvitePlayers();
                    CreatePlayListMMMonitor.this.sendAddPacket(imageInfo, name, pubType, initAuthType, invitePlayers, musics);
                    CreatePlayListMMMonitor.this.insMonitor(MusicManagerBlockEntity.MonitorType.PLAY_LIST);
                });
            }
            catch (Exception ex) {
                CreatePlayListMMMonitor.this.failureImportPlayList = true;
            }
        }
    }
}

