/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.boombox;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.block.BoomboxData;
import dev.felnull.imp.blockentity.BoomboxBlockEntity;
import dev.felnull.imp.client.gui.screen.BoomboxScreen;
import dev.felnull.imp.client.gui.screen.monitor.Monitor;
import dev.felnull.imp.client.gui.screen.monitor.boombox.OffBMonitor;
import dev.felnull.imp.client.gui.screen.monitor.boombox.PlaybackBMonitor;
import dev.felnull.imp.client.gui.screen.monitor.boombox.RadioBMonitor;
import dev.felnull.imp.client.gui.screen.monitor.boombox.RadioSelectBMonitor;
import dev.felnull.imp.client.gui.screen.monitor.boombox.RemotePlayBackBMonitor;
import dev.felnull.imp.client.gui.screen.monitor.boombox.RemotePlayBackSelectBMonitor;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class BoomboxMonitor
extends Monitor<BoomboxBlockEntity> {
    private static final Map<BoomboxData.MonitorType, MonitorFactory> monitorFactory = new HashMap<BoomboxData.MonitorType, MonitorFactory>();
    protected static final ResourceLocation BG_TEXTURE = new ResourceLocation("iammusicplayer", "textures/gui/container/boombox/monitor/background.png");
    private final BoomboxData.MonitorType monitorType;
    private final BoomboxScreen screen;

    public BoomboxMonitor(BoomboxData.MonitorType monitorType, BoomboxScreen screen) {
        super((Component)Component.m_237115_((String)("imp.monitor.boombox." + monitorType.getName())), 7, 36, 200, 37);
        this.monitorType = monitorType;
        this.screen = screen;
    }

    public static void firstInit() {
        BoomboxMonitor.registerMonitors(BoomboxData.MonitorType.OFF, OffBMonitor::new);
        BoomboxMonitor.registerMonitors(BoomboxData.MonitorType.PLAYBACK, PlaybackBMonitor::new);
        BoomboxMonitor.registerMonitors(BoomboxData.MonitorType.RADIO, RadioBMonitor::new);
        BoomboxMonitor.registerMonitors(BoomboxData.MonitorType.REMOTE_PLAYBACK, RemotePlayBackBMonitor::new);
        BoomboxMonitor.registerMonitors(BoomboxData.MonitorType.RADIO_SELECT, RadioSelectBMonitor::new);
        BoomboxMonitor.registerMonitors(BoomboxData.MonitorType.REMOTE_PLAYBACK_SELECT, RemotePlayBackSelectBMonitor::new);
    }

    protected ImageInfo getRadioImage() {
        return this.getScreen().getBoomBoxData().getRadioImage();
    }

    public static BoomboxMonitor createdBoomBoxMonitor(BoomboxData.MonitorType type, BoomboxScreen screen) {
        return monitorFactory.get((Object)type).create(type, screen);
    }

    private static void registerMonitors(BoomboxData.MonitorType type, MonitorFactory factory) {
        monitorFactory.put(type, factory);
    }

    public void setMonitor(BoomboxData.MonitorType monitorType) {
        this.getScreen().insMonitor(monitorType);
    }

    public String getRadioUrl() {
        return this.getScreen().getBoomBoxData().getRadioUrl();
    }

    public String getRadioUrl(BoomboxData data) {
        return data.getRadioUrl();
    }

    public BoomboxScreen getScreen() {
        return this.screen;
    }

    public BoomboxData.MonitorType getType() {
        return this.monitorType;
    }

    @Override
    public void render(PoseStack poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        OERenderUtils.drawTexture((ResourceLocation)BG_TEXTURE, (PoseStack)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
    }

    public void renderAppearance(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight, BoomboxData data) {
        OERenderUtils.renderTextureSprite((ResourceLocation)BG_TEXTURE, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.001f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
    }

    @Override
    public float getDefaultRenderTextScale() {
        return 2.5f;
    }

    public ItemStack getCassetteTape() {
        return this.getScreen().getCassetteTape();
    }

    public MusicSource getRadioSource(BoomboxData data) {
        return data.getRadioSource();
    }

    public MusicSource getRadioSource() {
        return this.getScreen().getBoomBoxData().getRadioSource();
    }

    private static interface MonitorFactory {
        public BoomboxMonitor create(BoomboxData.MonitorType var1, BoomboxScreen var2);
    }
}

