/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.api.origin;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityCondition;
import io.github.edwinmindcraft.apoli.api.registry.ApoliBuiltinRegistries;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.calio.api.registry.ICalioDynamicRegistryManager;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.registry.OriginsDynamicRegistries;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

public record ConditionedOrigin(@NotNull Holder<ConfiguredEntityCondition<?, ?>> condition, List<HolderSet<Origin>> origins) {
    public static final Codec<ConditionedOrigin> LARGE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfiguredEntityCondition.optional((String)"condition").forGetter(ConditionedOrigin::condition), (App)Origin.CODEC_SET.set().fieldOf("origins").forGetter(ConditionedOrigin::origins)).apply((Applicative)instance, ConditionedOrigin::new));
    public static final Codec<ConditionedOrigin> STRING_CODEC = Codec.STRING.flatXmap(s -> {
        boolean tag = s.startsWith("#");
        ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)(tag ? s.substring(1) : s));
        DataResult origins = resourceLocation == null ? DataResult.success((Object)ImmutableList.of()) : (tag ? DataResult.success((Object)ImmutableList.of((Object)OriginsAPI.getOriginsRegistry().m_203561_(TagKey.m_203882_(OriginsDynamicRegistries.ORIGINS_REGISTRY, (ResourceLocation)resourceLocation)))) : OriginsAPI.getOriginsRegistry().m_214185_(ResourceKey.m_135785_(OriginsDynamicRegistries.ORIGINS_REGISTRY, (ResourceLocation)resourceLocation)).map(xva$0 -> HolderSet.m_205809_((Holder[])new Holder[]{xva$0})).map(ImmutableList::of));
        return origins.map(set -> new ConditionedOrigin((Holder<ConfiguredEntityCondition<?, ?>>)((Holder)((IForgeRegistry)ApoliBuiltinRegistries.CONFIGURED_ENTITY_CONDITIONS.get()).getHolder(ApoliDynamicRegistries.CONDITION_DEFAULT).orElseThrow()), (List<HolderSet<Origin>>)set));
    }, co -> {
        if (co.origins().size() != 1) {
            return DataResult.error((String)("Invalid size: " + co.origins().size()));
        }
        return ((DataResult)co.origins().get(0).m_203440_().map(x -> DataResult.success((Object)x.f_203868_()), x -> {
            if (x.size() != 1) {
                return DataResult.error((String)"Cannot serialize non-tag list");
            }
            return ((Holder)x.get(0)).m_203543_().map(ResourceKey::m_135782_).map(DataResult::success).orElseGet(() -> DataResult.error((String)"Unregistered origin"));
        })).map(ResourceLocation::toString);
    });
    public static final Codec<ConditionedOrigin> CODEC = Codec.either(STRING_CODEC, LARGE_CODEC).xmap(e -> (ConditionedOrigin)e.map(Function.identity(), Function.identity()), Either::right);
    private static final Codec<ConditionedOrigin> JSON_CODEC = Codec.either(STRING_CODEC, LARGE_CODEC).xmap(e -> (ConditionedOrigin)e.map(Function.identity(), Function.identity()), co -> co.origins().size() == 1 && co.condition().m_203373_(ApoliDynamicRegistries.CONDITION_DEFAULT) ? Either.left((Object)co) : Either.right((Object)co));

    public Stream<Holder<Origin>> stream(Player player) {
        return ConfiguredEntityCondition.check(this.condition(), (Entity)player) ? this.stream() : Stream.empty();
    }

    public Stream<Holder<Origin>> stream() {
        return this.origins().stream().flatMap(HolderSet::m_203614_).filter(Holder::m_203633_);
    }

    public boolean isEmpty() {
        return this.origins().isEmpty();
    }

    public ConditionedOrigin cleanup(ICalioDynamicRegistryManager registries) {
        WritableRegistry registry = registries.get(OriginsDynamicRegistries.ORIGINS_REGISTRY);
        ImmutableList.Builder directBuilder = ImmutableList.builder();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (HolderSet<Origin> origin : this.origins()) {
            Either unwrap = origin.m_203440_();
            unwrap.ifLeft(originTagKey -> {
                Optional tag = registry.m_203431_(originTagKey);
                if (tag.isPresent() && ((HolderSet.Named)tag.get()).m_203614_().anyMatch(Holder::m_203633_)) {
                    builder.add((Object)origin);
                }
            });
            unwrap.ifRight(list -> list.stream().filter(Holder::m_203633_).forEach(arg_0 -> ((ImmutableList.Builder)directBuilder).add(arg_0)));
        }
        ImmutableList direct = directBuilder.build();
        if (direct.size() > 0) {
            builder.add((Object)HolderSet.m_205800_((List)direct));
        }
        return new ConditionedOrigin(this.condition(), (List<HolderSet<Origin>>)builder.build());
    }

    public static enum Serializer implements JsonSerializer<ConditionedOrigin>,
    JsonDeserializer<ConditionedOrigin>
    {
        INSTANCE;


        public ConditionedOrigin deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            DataResult result = JSON_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
            return (ConditionedOrigin)((Pair)result.getOrThrow(false, s -> {
                throw new JsonParseException("Expected origin in layer to be either a string or an object.");
            })).getFirst();
        }

        public JsonElement serialize(ConditionedOrigin src, Type typeOfSrc, JsonSerializationContext context) {
            if (src.isEmpty()) {
                return new JsonPrimitive("<empty conditioned origin>");
            }
            return (JsonElement)JSON_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)src).getOrThrow(false, s -> {});
        }
    }
}

