/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.apace100.origins.Origins;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CraftingRecipeTooltipComponent
implements ClientTooltipComponent {
    private final NonNullList<ItemStack> inputs;
    private final ItemStack output;
    private static final ResourceLocation TEXTURE = Origins.identifier("textures/gui/tooltip/recipe_tooltip.png");

    public CraftingRecipeTooltipComponent(NonNullList<ItemStack> inputs, ItemStack output) {
        this.inputs = inputs;
        this.output = output;
    }

    public int m_142103_() {
        return 68;
    }

    public int m_142069_(@NotNull Font pFont) {
        return 130;
    }

    public void m_183452_(@NotNull Font pFont, int pMouseX, int pMouseY, @NotNull PoseStack pPoseStack, @NotNull ItemRenderer pItemRenderer, int pBlitOffset) {
        this.drawBackGround(pPoseStack, pMouseX, pMouseY, pBlitOffset);
        for (int column = 0; column < 3; ++column) {
            for (int row = 0; row < 3; ++row) {
                int index = column + row * 3;
                int slotX = pMouseX + 8 + column * 18;
                int slotY = pMouseY + 8 + row * 18;
                ItemStack stack = (ItemStack)this.inputs.get(index);
                pItemRenderer.m_174253_(stack, slotX, slotY, index);
                pItemRenderer.m_115169_(pFont, stack, slotX, slotY);
            }
        }
        pItemRenderer.m_174253_(this.output, pMouseX + 101, pMouseY + 25, 10);
    }

    public void drawBackGround(PoseStack matrices, int x, int y, int z) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        Gui.m_93143_((PoseStack)matrices, (int)x, (int)y, (int)z, (float)0.0f, (float)0.0f, (int)130, (int)86, (int)256, (int)256);
    }
}

