/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.badge;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.gson.JsonElement;
import io.github.apace100.apoli.integration.PowerLoadEvent;
import io.github.apace100.calio.registry.DataObjectFactory;
import io.github.apace100.calio.registry.DataObjectRegistry;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.badge.Badge;
import io.github.apace100.origins.badge.BadgeFactories;
import io.github.apace100.origins.badge.BadgeFactory;
import io.github.apace100.origins.badge.CraftingRecipeBadge;
import io.github.apace100.origins.badge.KeybindBadge;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.configuration.FieldConfiguration;
import io.github.edwinmindcraft.apoli.api.power.IActivePower;
import io.github.edwinmindcraft.apoli.api.power.ITogglePower;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.RecipePower;
import io.github.edwinmindcraft.origins.api.event.AutoBadgeEvent;
import io.github.edwinmindcraft.origins.api.registry.OriginsBuiltinRegistries;
import io.github.edwinmindcraft.origins.common.OriginsCommon;
import io.github.edwinmindcraft.origins.common.network.S2CSynchronizeBadges;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.network.PacketDistributor;

public final class BadgeManager {
    public static final DataObjectRegistry<Badge> REGISTRY = new DataObjectRegistry.Builder(Origins.identifier("badge"), Badge.class).readFromData("badges", true).dataErrorHandler((id, exception) -> Origins.LOGGER.error("Failed to read badge " + id + ", caused by", (Throwable)exception)).defaultFactory(BadgeFactories.KEYBIND).buildAndRegister();
    private static final Multimap<ResourceLocation, Badge> BADGES = HashMultimap.create();
    private static final ResourceLocation TOGGLE_BADGE_SPRITE = Origins.identifier("textures/gui/badge/toggle.png");
    private static final ResourceLocation ACTIVE_BADGE_SPRITE = Origins.identifier("textures/gui/badge/active.png");
    private static final ResourceLocation RECIPE_BADGE_SPRITE = Origins.identifier("textures/gui/badge/recipe.png");
    private static final ResourceLocation TOGGLE_BADGE_ID = Origins.identifier("toggle");
    private static final ResourceLocation ACTIVE_BADGE_ID = Origins.identifier("active");

    public static void init() {
        REGISTRY.setForgeRegistryAccess(OriginsBuiltinRegistries.BADGE_FACTORIES);
        MinecraftForge.EVENT_BUS.addListener(event -> BadgeManager.clear());
        MinecraftForge.EVENT_BUS.addListener(BadgeManager::createAutoBadges);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, BadgeManager::readCustomBadges);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, BadgeManager::readAutoBadges);
        ApoliAPI.addAdditionalDataField((String)"badges");
    }

    public static void register(BadgeFactory factory) {
        REGISTRY.registerFactory(factory.id(), (DataObjectFactory)factory);
    }

    public static void putPowerBadge(ResourceLocation powerId, Badge badge) {
        BADGES.put((Object)powerId, (Object)badge);
    }

    public static List<Badge> getPowerBadges(ResourceLocation powerId) {
        return ImmutableList.copyOf((Collection)BADGES.get((Object)powerId));
    }

    public static void clear() {
        BADGES.clear();
    }

    public static S2CSynchronizeBadges createPacket() {
        return new S2CSynchronizeBadges((Multimap<ResourceLocation, Badge>)Multimaps.unmodifiableMultimap(BADGES));
    }

    public static void sync(ServerPlayer player) {
        REGISTRY.sync(player);
        OriginsCommon.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)BadgeManager.createPacket());
    }

    public static void readCustomBadges(PowerLoadEvent.Post event) {
        if (event.getAdditionalData("badges").isJsonNull()) {
            return;
        }
        ConfiguredPower powerType = event.getPower();
        ResourceLocation powerId = event.getId();
        JsonElement data = event.getAdditionalData("badges");
        if (!powerType.getData().hidden()) {
            if (data.isJsonArray()) {
                for (JsonElement badgeJson : data.getAsJsonArray()) {
                    if (badgeJson.isJsonPrimitive()) {
                        ResourceLocation badgeId = ResourceLocation.m_135820_((String)badgeJson.getAsString());
                        if (badgeId != null) {
                            Badge badge = (Badge)REGISTRY.get(badgeId);
                            if (badge != null) {
                                BadgeManager.putPowerBadge(powerId, badge);
                                continue;
                            }
                            Origins.LOGGER.error("\"badges\" field in power \"{}\" is referring to an undefined badge \"{}\"!", (Object)powerId, (Object)badgeId);
                            continue;
                        }
                        Origins.LOGGER.error("\"badges\" field in power \"{}\" is not a valid identifier!", (Object)powerId);
                        continue;
                    }
                    if (badgeJson.isJsonObject()) {
                        try {
                            BadgeManager.putPowerBadge(powerId, (Badge)REGISTRY.readDataObject(badgeJson));
                        }
                        catch (Exception exception) {
                            Origins.LOGGER.error("\"badges\" field in power \"{}\" contained an JSON object entry that cannot be resolved!", (Object)powerId, (Object)exception);
                        }
                        continue;
                    }
                    Origins.LOGGER.error("\"badges\" field in power \"{}\" contained an entry that was a JSON array, which is not allowed!", (Object)powerId);
                }
            } else {
                Origins.LOGGER.error("\"badges\" field in power \"{}\" should be an array.", (Object)powerId);
            }
        }
    }

    public static void readAutoBadges(PowerLoadEvent.Post event) {
        ConfiguredPower powerType = event.getPower();
        ResourceLocation powerId = event.getId();
        if (BADGES.containsKey((Object)powerId) || powerType.getData().hidden()) {
            return;
        }
        LinkedList<Badge> badgeList = new LinkedList<Badge>();
        for (Holder value : powerType.getContainedPowers().values()) {
            if (!value.m_203633_()) continue;
            MinecraftForge.EVENT_BUS.post((Event)new AutoBadgeEvent(powerId, (ConfiguredPower)value.m_203334_(), badgeList));
        }
        MinecraftForge.EVENT_BUS.post((Event)new AutoBadgeEvent(powerId, powerType, badgeList));
        for (Badge badge : badgeList) {
            BadgeManager.putPowerBadge(powerId, badge);
        }
    }

    public static void createAutoBadges(AutoBadgeEvent event) {
        PowerFactory factory = event.getPower().getFactory();
        if (factory instanceof IActivePower) {
            ResourceLocation autoBadgeId;
            boolean toggle = factory instanceof ITogglePower;
            ResourceLocation resourceLocation = autoBadgeId = toggle ? TOGGLE_BADGE_ID : ACTIVE_BADGE_ID;
            if (REGISTRY.containsId(autoBadgeId)) {
                event.getBadges().add((Badge)REGISTRY.get(autoBadgeId));
            } else {
                event.getBadges().add(new KeybindBadge(toggle ? TOGGLE_BADGE_SPRITE : ACTIVE_BADGE_SPRITE, toggle ? "origins.gui.badge.toggle" : "origins.gui.badge.active"));
            }
        } else if (factory instanceof RecipePower) {
            FieldConfiguration config = (FieldConfiguration)event.getPower().getConfiguration();
            Recipe recipe = (Recipe)config.value();
            String type = recipe instanceof ShapedRecipe ? "shaped" : "shapeless";
            event.getBadges().add(new CraftingRecipeBadge(RECIPE_BADGE_SPRITE, (Recipe<CraftingContainer>)recipe, (Component)Component.m_237115_((String)("origins.gui.badge.recipe.crafting." + type)), null));
        }
    }
}

