/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.badge;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.badge.Badge;
import io.github.apace100.origins.badge.BadgeFactory;
import io.github.apace100.origins.badge.CraftingRecipeBadge;
import io.github.apace100.origins.badge.KeybindBadge;
import io.github.apace100.origins.badge.SpriteBadge;
import io.github.apace100.origins.badge.TooltipBadge;
import io.github.edwinmindcraft.origins.common.registry.OriginRegisters;
import java.util.function.Function;
import net.minecraftforge.registries.RegistryObject;

public final class BadgeFactories {
    public static final RegistryObject<BadgeFactory> SPRITE = BadgeFactories.register("sprite", new SerializableData().add("sprite", SerializableDataTypes.IDENTIFIER), SpriteBadge::new);
    public static final RegistryObject<BadgeFactory> TOOLTIP = BadgeFactories.register("tooltip", new SerializableData().add("sprite", SerializableDataTypes.IDENTIFIER).add("text", SerializableDataTypes.TEXT), TooltipBadge::new);
    public static final RegistryObject<BadgeFactory> KEYBIND = BadgeFactories.register("keybind", new SerializableData().add("sprite", SerializableDataTypes.IDENTIFIER).add("text", SerializableDataTypes.STRING), KeybindBadge::new);
    public static final RegistryObject<BadgeFactory> CRAFTING_RECIPE = BadgeFactories.register("crafting_recipe", new SerializableData().add("sprite", SerializableDataTypes.IDENTIFIER).add("recipe", SerializableDataTypes.RECIPE).add("prefix", SerializableDataTypes.TEXT, null).add("suffix", SerializableDataTypes.TEXT, null), CraftingRecipeBadge::new);

    public static void bootstrap() {
    }

    private static RegistryObject<BadgeFactory> register(String name, SerializableData data, Function<SerializableData.Instance, Badge> factory) {
        return OriginRegisters.BADGE_FACTORIES.register(name, () -> new BadgeFactory(Origins.identifier(name), data, factory));
    }
}

