/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.component.button;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.component.IComponentHandler;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MultiButtonComponent
implements IScreenAddonProvider,
IComponentHandler {
    private List<ButtonComponent> basicButtonAddons = new ArrayList<ButtonComponent>();

    public void clickButton(int id, Player playerEntity, CompoundTag compound) {
        this.basicButtonAddons.stream().filter(buttonAddon -> buttonAddon.getId() == id).forEach(buttonAddon -> buttonAddon.onButtonClicked(playerEntity, compound));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList<IFactory<? extends IScreenAddon>> addons = new ArrayList<IFactory<? extends IScreenAddon>>();
        for (ButtonComponent basicButtonAddon : this.basicButtonAddons) {
            List<IFactory<? extends IScreenAddon>> addon = basicButtonAddon.getScreenAddons();
            if (addon == null) continue;
            addons.addAll(addon);
        }
        return addons;
    }

    @Override
    public void add(Object ... component) {
        Arrays.stream(component).filter(this::accepts).map(o -> (ButtonComponent)o).forEach(buttonComponent -> {
            if (buttonComponent.getId() == -1) {
                buttonComponent.setId(this.basicButtonAddons.size());
            }
            this.basicButtonAddons.add((ButtonComponent)buttonComponent);
        });
    }

    private boolean accepts(Object component) {
        return component instanceof ButtonComponent;
    }
}

