/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.util;

import dev.felnull.otyacraftengine.entity.PlayerInfoManager;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.NotNull;

public class OEPlayerUtils {
    public static void doPlayers(@NotNull LevelChunk chunk, @NotNull Consumer<ServerPlayer> playerConsumer) {
        ((ServerChunkCache)chunk.m_62953_().m_7726_()).f_8325_.m_183262_(chunk.m_7697_(), false).forEach(playerConsumer);
    }

    public static void doPlayers(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Consumer<ServerPlayer> playerConsumer) {
        LevelChunk lch = (LevelChunk)level.m_46865_(pos);
        OEPlayerUtils.doPlayers(lch, playerConsumer);
    }

    public static void giveItem(@NotNull ServerPlayer player, @NotNull ItemStack stack) {
        if (!player.m_36356_(stack)) {
            player.m_7197_(stack, false, true);
        }
    }

    @NotNull
    public static Optional<UUID> getUUIDByName(@NotNull String name) {
        return PlayerInfoManager.getInstance().getCachedUUIDByName(name);
    }

    @NotNull
    public static Optional<String> getNameByUUID(@NotNull UUID uuid) {
        return PlayerInfoManager.getInstance().getCachedNameByUUID(uuid);
    }

    @NotNull
    public static CompletableFuture<Optional<UUID>> getUUIDByNameAsync(@NotNull String name) {
        return PlayerInfoManager.getInstance().getCachedUUIDByNameAsync(name);
    }

    @NotNull
    public static CompletableFuture<Optional<String>> getNameByUUIDAsync(@NotNull UUID uuid) {
        return PlayerInfoManager.getInstance().getCachedNameByUUIDAsync(uuid);
    }
}

