/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.renderer.texture;

import com.mojang.blaze3d.platform.NativeImage;
import dev.felnull.otyacraftengine.client.renderer.texture.TextureLoadProgress;
import dev.felnull.otyacraftengine.client.renderer.texture.impl.TextureLoadProgressImpl;
import dev.felnull.otyacraftengine.include.com.madgag.gif.fmsware.GifDecoder;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNImageUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DynamicGifTexture
extends DynamicTexture
implements Tickable {
    private final ImageFrame[] frames;
    private final long duration;
    private int last;

    private DynamicGifTexture(long duration, ImageFrame ... frames) {
        super(frames[0].image());
        this.duration = duration;
        this.frames = frames;
    }

    public void m_7673_() {
        int ct = Math.toIntExact(this.getFrameByTime(System.currentTimeMillis() % this.duration));
        if (ct != this.last) {
            this.f_117977_ = this.frames[ct].image();
            this.m_117985_();
            this.last = ct;
        }
    }

    private int getFrameByTime(long time) {
        return Mth.m_14049_((int)0, (int)this.frames.length, v -> time <= this.frames[v].timestamp());
    }

    public void close() {
        super.close();
        if (this.frames != null) {
            for (ImageFrame image : this.frames) {
                if (image == null) continue;
                image.image().close();
            }
        }
    }

    @NotNull
    public static DynamicGifTexture create(@NotNull GifDecoder decoder, @Nullable Consumer<TextureLoadProgress> progress) throws IOException {
        ImageFrame[] frames = new ImageFrame[decoder.getFrameCount()];
        if (progress != null) {
            progress.accept(new TextureLoadProgressImpl("Gif decoding", decoder.getFrameCount(), 0));
        }
        long duration = 0L;
        for (int i = 0; i < decoder.getFrameCount(); ++i) {
            if (progress != null) {
                progress.accept(new TextureLoadProgressImpl("Gif decoding", decoder.getFrameCount(), i + 1));
            }
            BufferedImage img = decoder.getFrame(i);
            long delay = decoder.getDelay(i);
            duration += delay;
            try (InputStream stream = FNImageUtil.toInputStream(img, "png");){
                frames[i] = new ImageFrame(NativeImage.m_85058_((InputStream)stream), duration);
                continue;
            }
        }
        return new DynamicGifTexture(duration, frames);
    }

    private record ImageFrame(NativeImage image, long timestamp) {
    }
}

