/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.item.inv.ExtractedStack;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public class EffectInteract
extends AbstractEffect {
    public static EffectInteract INSTANCE = new EffectInteract();

    private EffectInteract() {
        super(GlyphLib.EffectInteractID, "Interact");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity e = rayTraceResult.m_82443_();
        Player player = this.getPlayer(shooter, (ServerLevel)world);
        if (!this.isRealPlayer((Entity)shooter)) {
            InventoryManager manager = spellContext.getCaster().getInvManager();
            player = this.setupFakeInventory(spellContext, world);
            player.m_36157_(e, InteractionHand.MAIN_HAND);
            for (ItemStack i : player.f_36093_.f_35974_) {
                manager.insertOrDrop(i, world, e.m_20183_());
            }
        } else {
            player.m_36157_(e, InteractionHand.MAIN_HAND);
        }
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockPos blockPos = rayTraceResult.m_82425_();
        BlockState blockState = world.m_8055_(blockPos);
        if (!BlockUtil.destroyRespectsClaim((LivingEntity)this.getPlayer(shooter, (ServerLevel)world), world, blockPos)) {
            return;
        }
        Player player = this.getPlayer(shooter, (ServerLevel)world);
        if (this.isRealPlayer((Entity)shooter)) {
            blockState.m_60664_(world, player, InteractionHand.MAIN_HAND, rayTraceResult);
        } else {
            InventoryManager manager = spellContext.getCaster().getInvManager();
            player = this.setupFakeInventory(spellContext, world);
            blockState.m_60664_(world, player, InteractionHand.MAIN_HAND, rayTraceResult);
            for (ItemStack i : player.f_36093_.f_35974_) {
                manager.insertOrDrop(i, world, rayTraceResult.m_82425_());
            }
        }
    }

    public FakePlayer setupFakeInventory(SpellContext context, Level level) {
        InventoryManager manager = context.getCaster().getInvManager();
        ANFakePlayer player = ANFakePlayer.getPlayer((ServerLevel)level);
        player.f_36093_.m_6211_();
        player.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        player.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
        ExtractedStack stack = manager.extractItem(i -> !i.m_41619_(), 1);
        if (!stack.isEmpty()) {
            player.m_8061_(EquipmentSlot.MAINHAND, stack.getStack().m_41777_());
        }
        return player;
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[0]);
    }

    @Override
    public String getBookDescription() {
        return "Interacts with blocks or entities as it were a player. Useful for reaching levers, chests, or animals.";
    }

    @Override
    public int getDefaultManaCost() {
        return 10;
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }
}

