/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.potion.PotionData;
import com.hollingsworth.arsnouveau.api.recipe.CraftingManager;
import com.hollingsworth.arsnouveau.api.recipe.IRecipeWrapper;
import com.hollingsworth.arsnouveau.api.recipe.MultiRecipeWrapper;
import com.hollingsworth.arsnouveau.api.recipe.PotionCraftingManager;
import com.hollingsworth.arsnouveau.api.recipe.PotionIngredient;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.WixieCauldron;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.block.tile.SummoningTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WixieCauldronTile
extends SummoningTile
implements ITooltipProvider {
    public List<BlockPos> inventories;
    private ItemStack setStack;
    private ItemStack stackBeingCrafted;
    public int entityID;
    public boolean hasSource;
    public boolean isCraftingPotion;
    public boolean needsPotionStorage;
    public CraftingManager craftManager = new CraftingManager();
    public int craftingIndex;

    public WixieCauldronTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.WIXIE_CAULDRON_TYPE, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        if (!this.hasSource && this.f_58857_.m_46467_() % 5L == 0L && SourceUtil.takeSourceWithParticles(this.f_58858_, this.f_58857_, 6, 50) != null) {
            this.hasSource = true;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)WixieCauldron.FILLED, (Comparable)Boolean.valueOf(true)));
            this.m_6596_();
        }
        if (!this.hasSource) {
            return;
        }
        if (this.f_58857_.m_46467_() % 100L == 0L) {
            this.updateInventories();
        }
        if (!this.f_58857_.m_5776_() && this.f_58857_.m_46467_() % 20L == 0L && this.craftManager.isCraftCompleted()) {
            this.rotateCraft();
        }
    }

    public void rotateCraft() {
        ItemStack nextStack;
        MultiRecipeWrapper recipeWrapper;
        BlockPos leftBound = this.f_58858_.m_7495_().m_122019_().m_122029_();
        BlockPos rightBound = this.f_58858_.m_7494_().m_122012_().m_122024_();
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (this.setStack != null && !this.setStack.m_41619_()) {
            itemStacks.add(this.setStack);
        }
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)leftBound, (BlockPos)rightBound)) {
            ArcanePedestalTile pedestalTile;
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof ArcanePedestalTile) || (pedestalTile = (ArcanePedestalTile)blockEntity).getStack().m_41619_() || pedestalTile.hasSignal) continue;
            itemStacks.add(pedestalTile.getStack().m_41777_());
        }
        if (itemStacks.isEmpty()) {
            return;
        }
        if (this.craftingIndex >= itemStacks.size()) {
            this.craftingIndex = 0;
        }
        if (!(recipeWrapper = this.getRecipesForStack(nextStack = (ItemStack)itemStacks.get(this.craftingIndex))).isEmpty()) {
            this.setNewCraft(recipeWrapper);
            this.stackBeingCrafted = nextStack.m_41777_();
            this.updateBlock();
        }
        ++this.craftingIndex;
    }

    public boolean hasWixie() {
        return !this.converted || this.f_58857_.m_6815_(this.entityID) != null;
    }

    public boolean isCraftingDone() {
        return this.craftManager.canBeCompleted();
    }

    public boolean needsPotion() {
        PotionCraftingManager potionCraftingManager;
        CraftingManager craftingManager = this.craftManager;
        return craftingManager instanceof PotionCraftingManager && (potionCraftingManager = (PotionCraftingManager)craftingManager).needsPotion();
    }

    public Potion getNeededPotion() {
        Potion potion;
        CraftingManager craftingManager = this.craftManager;
        if (craftingManager instanceof PotionCraftingManager) {
            PotionCraftingManager potionCraftingManager = (PotionCraftingManager)craftingManager;
            potion = potionCraftingManager.getPotionNeeded();
        } else {
            potion = null;
        }
        return potion;
    }

    public void givePotion() {
        CraftingManager craftingManager = this.craftManager;
        if (craftingManager instanceof PotionCraftingManager) {
            PotionCraftingManager potionCraftingManager = (PotionCraftingManager)craftingManager;
            potionCraftingManager.setObtainedPotion(true);
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        }
    }

    public boolean giveItem(ItemStack stack) {
        boolean res = this.craftManager.giveItem(stack.m_41720_());
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        return res;
    }

    public void attemptFinish() {
        if (!this.craftManager.canBeCompleted() || this.craftManager.isCraftCompleted()) {
            return;
        }
        this.craftManager.completeCraft(this);
        this.m_6596_();
    }

    public void setNewCraft(MultiRecipeWrapper recipeWrapper) {
        Ingredient ingredient;
        if (recipeWrapper == null) {
            return;
        }
        Map<Item, Integer> count = this.getInventoryCount();
        IRecipeWrapper.InstructionsForRecipe instructions = recipeWrapper.canCraft(count, this.f_58857_, this.f_58858_);
        if (instructions != null && !recipeWrapper.isEmpty() && (ingredient = instructions.recipe().recipeIngredients.get(0)) instanceof PotionIngredient) {
            PotionIngredient potionIngred = (PotionIngredient)ingredient;
            Ingredient itemIngred = instructions.recipe().recipeIngredients.get(1);
            ArrayList<ItemStack> needed = new ArrayList<ItemStack>(Arrays.asList(itemIngred.m_43908_()));
            this.craftManager = new PotionCraftingManager(PotionUtils.m_43579_((ItemStack)potionIngred.getStack()), needed, PotionUtils.m_43579_((ItemStack)instructions.recipe().outputStack));
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        } else if (instructions != null) {
            this.craftManager = new CraftingManager(instructions.recipe().outputStack.m_41777_(), instructions.itemsNeeded());
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        }
    }

    public MultiRecipeWrapper getRecipesForStack(ItemStack stack) {
        return MultiRecipeWrapper.fromStack(stack, this.f_58857_);
    }

    public void updateInventories() {
        this.inventories = new ArrayList<BlockPos>();
        for (BlockPos bPos : BlockPos.m_121940_((BlockPos)this.f_58858_.m_122013_(6).m_122030_(6).m_6625_(2), (BlockPos)this.f_58858_.m_122020_(6).m_122025_(6).m_6630_(2))) {
            Container container;
            BlockEntity blockEntity;
            if (!this.f_58857_.m_46749_(bPos) || !((blockEntity = this.f_58857_.m_7702_(bPos)) instanceof Container) || (container = (Container)blockEntity) instanceof ArcanePedestalTile) continue;
            this.inventories.add(bPos.m_7949_());
        }
        this.m_6596_();
    }

    @Nullable
    public static BlockPos findPotionStorage(Level level, BlockPos worldPosition, Potion passedPot) {
        for (BlockPos bPos : BlockPos.m_121925_((BlockPos)worldPosition.m_6625_(2), (int)4, (int)3, (int)4)) {
            PotionJarTile tile;
            BlockEntity blockEntity = level.m_7702_(bPos);
            if (!(blockEntity instanceof PotionJarTile) || !(tile = (PotionJarTile)blockEntity).canAccept(new PotionData(passedPot), 300)) continue;
            return bPos.m_7949_();
        }
        return null;
    }

    @Nullable
    public static BlockPos findNeededPotion(Potion passedPot, int amount, Level level, BlockPos worldPosition) {
        for (BlockPos bPos : BlockPos.m_121925_((BlockPos)worldPosition.m_6625_(2), (int)4, (int)3, (int)4)) {
            PotionJarTile tile;
            BlockEntity blockEntity = level.m_7702_(bPos);
            if (!(blockEntity instanceof PotionJarTile) || (tile = (PotionJarTile)blockEntity).getAmount() < amount || !tile.getData().areSameEffects(new PotionData(passedPot))) continue;
            return bPos.m_7949_();
        }
        return null;
    }

    public void spawnFlyingItem(BlockPos from, ItemStack stack) {
        EntityFlyingItem flyingItem = new EntityFlyingItem(this.f_58857_, from.m_7494_(), this.f_58858_);
        flyingItem.m_20088_().m_135381_(EntityFlyingItem.HELD_ITEM, (Object)stack.m_41777_());
        this.f_58857_.m_7967_((Entity)flyingItem);
    }

    @Override
    public void convertedEffect() {
        super.convertedEffect();
        if (this.tickCounter >= 120 && !this.f_58857_.f_46443_) {
            this.converted = true;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)((BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)WixieCauldron.FILLED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SummoningTile.CONVERTED, (Comparable)Boolean.valueOf(true)));
            EntityWixie wixie = new EntityWixie(this.f_58857_, true, this.f_58858_);
            wixie.m_6034_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 0.5);
            this.f_58857_.m_7967_((Entity)wixie);
            ParticleUtil.spawnPoof((ServerLevel)this.f_58857_, this.f_58858_.m_7494_());
            this.entityID = wixie.m_19879_();
            this.tickCounter = 0;
            this.m_6596_();
            return;
        }
        if (this.tickCounter % 10 == 0 && !this.f_58857_.f_46443_) {
            RandomSource r = this.f_58857_.f_46441_;
            int min = -2;
            int max = 2;
            EntityFollowProjectile proj1 = new EntityFollowProjectile(this.f_58857_, this.f_58858_.m_7918_(r.m_188503_(max - min) + min, 3, r.m_188503_(max - min) + min), this.f_58858_, r.m_188503_(255), r.m_188503_(255), r.m_188503_(255));
            this.f_58857_.m_7967_((Entity)proj1);
        }
    }

    private Map<Item, Integer> getInventoryCount() {
        ArrayList<BlockPos> stale = new ArrayList<BlockPos>();
        HashMap<Item, Integer> itemsAvailable = new HashMap<Item, Integer>();
        if (this.inventories == null) {
            return itemsAvailable;
        }
        for (BlockPos p : this.inventories) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(p);
            if (blockEntity instanceof Container) {
                Container container = (Container)blockEntity;
                for (int i = 0; i < container.m_6643_(); ++i) {
                    ItemStack stack = container.m_8020_(i);
                    if (stack == null) {
                        System.out.println("======");
                        System.out.println("A MOD IS RETURNING A NULL STACK. THIS IS NOT ALLOWED YOU NERD. TELL THIS MOD AUTHOR TO FIX IT");
                        System.out.println(container.toString());
                        System.out.println("AT POS " + p.toString());
                        continue;
                    }
                    if (!itemsAvailable.containsKey(stack.m_41720_())) {
                        itemsAvailable.put(stack.m_41720_(), stack.m_41613_());
                        continue;
                    }
                    itemsAvailable.put(stack.m_41720_(), (Integer)itemsAvailable.get(stack.m_41720_()) + stack.m_41613_());
                }
                continue;
            }
            stale.add(p);
        }
        for (BlockPos p : stale) {
            this.inventories.remove(p);
        }
        return itemsAvailable;
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("crafting")) {
            this.setStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("crafting"));
        }
        if (compound.m_128441_("currentCraft")) {
            this.stackBeingCrafted = ItemStack.m_41712_((CompoundTag)compound.m_128469_("currentCraft"));
        }
        this.craftManager = CraftingManager.fromTag(compound);
        this.entityID = compound.m_128451_("entityid");
        this.hasSource = compound.m_128471_("hasmana");
        this.isCraftingPotion = compound.m_128471_("isPotion");
        this.needsPotionStorage = compound.m_128471_("storage");
        this.craftingIndex = compound.m_128451_("craftingIndex");
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        CompoundTag itemTag;
        super.m_183515_(compound);
        if (this.setStack != null) {
            itemTag = new CompoundTag();
            this.setStack.m_41739_(itemTag);
            compound.m_128365_("crafting", (Tag)itemTag);
        }
        if (this.stackBeingCrafted != null) {
            itemTag = new CompoundTag();
            this.stackBeingCrafted.m_41739_(itemTag);
            compound.m_128365_("currentCraft", (Tag)itemTag);
        }
        if (this.craftManager != null) {
            this.craftManager.write(compound);
        }
        compound.m_128405_("entityid", this.entityID);
        compound.m_128379_("hasmana", this.hasSource);
        compound.m_128379_("isPotion", this.isCraftingPotion);
        compound.m_128379_("storage", this.needsPotionStorage);
        compound.m_128405_("craftingIndex", this.craftingIndex);
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        Object potionStack;
        PotionCraftingManager potionCraftingManager;
        if (this.stackBeingCrafted == null) {
            return;
        }
        if (this.isOff) {
            tooltip.add((Component)Component.m_237115_((String)"ars_nouveau.tooltip.turned_off"));
        }
        if (this.craftManager != null && !(this.craftManager instanceof PotionCraftingManager)) {
            tooltip.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"ars_nouveau.wixie.crafting").getString() + Component.m_237115_((String)this.stackBeingCrafted.m_41778_()).getString())));
            if (this.stackBeingCrafted.m_41720_() == Items.f_42589_) {
                PotionUtils.m_43555_((ItemStack)this.stackBeingCrafted, tooltip, (float)1.0f);
            }
        } else {
            CraftingManager craftingManager = this.craftManager;
            if (craftingManager instanceof PotionCraftingManager) {
                potionCraftingManager = (PotionCraftingManager)craftingManager;
                potionStack = new ItemStack((ItemLike)Items.f_42589_);
                PotionUtils.m_43549_((ItemStack)potionStack, (Potion)potionCraftingManager.potionOut);
                tooltip.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"ars_nouveau.wixie.crafting").getString() + potionStack.m_41786_().getString())));
                PotionUtils.m_43555_((ItemStack)potionStack, tooltip, (float)1.0f);
            }
        }
        if (!this.hasSource) {
            tooltip.add((Component)Component.m_237115_((String)"ars_nouveau.wixie.need_mana").m_130940_(ChatFormatting.GOLD));
        }
        if (this.craftManager != null && !this.craftManager.neededItems.isEmpty()) {
            ItemStack neededStack = this.craftManager.neededItems.get(0);
            tooltip.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"ars_nouveau.wixie.needs").getString() + Component.m_237115_((String)neededStack.m_41778_()).getString())).m_130940_(ChatFormatting.GOLD));
            if (neededStack.m_41720_() == Items.f_42589_) {
                PotionUtils.m_43555_((ItemStack)neededStack, tooltip, (float)1.0f);
            }
        }
        if ((potionStack = this.craftManager) instanceof PotionCraftingManager && (potionCraftingManager = (PotionCraftingManager)potionStack).needsPotion()) {
            potionStack = new ItemStack((ItemLike)Items.f_42589_);
            PotionUtils.m_43549_((ItemStack)potionStack, (Potion)potionCraftingManager.getPotionNeeded());
            tooltip.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"ars_nouveau.wixie.needs").getString() + potionStack.m_41786_().getString())).m_130940_(ChatFormatting.GOLD));
        }
        if (this.needsPotionStorage) {
            tooltip.add((Component)Component.m_237115_((String)"ars_nouveau.wixie.needs_storage").m_130940_(ChatFormatting.GOLD));
        }
    }

    public ItemStack getSetStack() {
        return this.setStack;
    }

    public void setSetStack(ItemStack setStack) {
        this.setStack = setStack;
        this.updateBlock();
    }
}

