/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.common.block.ModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.MirrorWeaveTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MirrorWeave
extends ModBlock
implements EntityBlock {
    public static final Property<Integer> LIGHT_LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)15);

    public MirrorWeave(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(b -> (Integer)b.m_61143_(LIGHT_LEVEL)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockItem blockItem;
        ItemStack stack;
        Item item;
        if (pLevel.f_46443_ || pHand != InteractionHand.MAIN_HAND) {
            return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
        }
        MirrorWeaveTile tile = (MirrorWeaveTile)pLevel.m_7702_(pPos);
        if (tile != null && (item = (stack = pPlayer.m_21120_(pHand)).m_41720_()) instanceof BlockItem && !((blockItem = (BlockItem)item).m_40614_() instanceof EntityBlock)) {
            if (tile.mimicState.m_60713_(blockItem.m_40614_())) {
                return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
            }
            tile.nextState = blockItem.m_40614_().m_5573_(new BlockPlaceContext(pLevel, pPlayer, pHand, stack, pHit));
            this.setMimicState(pLevel, pPos, !pPlayer.m_6144_());
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public void setMimicState(Level level, BlockPos pos, boolean updateNeighbors) {
        MirrorWeaveTile tile = (MirrorWeaveTile)level.m_7702_(pos);
        if (tile == null || tile.mimicState == null || tile.nextState == null || tile.nextState.equals(tile.mimicState)) {
            return;
        }
        BlockState previousState = tile.mimicState;
        tile.mimicState = tile.nextState;
        level.m_46597_(pos, (BlockState)tile.m_58900_().m_61124_(LIGHT_LEVEL, (Comparable)Integer.valueOf(tile.mimicState.getLightEmission((BlockGetter)level, pos))));
        tile.updateBlock();
        int ticks = 1;
        if (!updateNeighbors) {
            return;
        }
        for (Direction d : Direction.values()) {
            BlockPos offset = pos.m_121945_(d);
            BlockEntity blockEntity = level.m_7702_(offset);
            if (!(blockEntity instanceof MirrorWeaveTile)) continue;
            MirrorWeaveTile neighbor = (MirrorWeaveTile)blockEntity;
            if (neighbor.mimicState != previousState) continue;
            neighbor.nextState = tile.mimicState;
            level.m_186460_(offset, neighbor.m_58900_().m_60734_(), ticks++);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        MirrorWeaveTile tile = (MirrorWeaveTile)pLevel.m_7702_(pPos);
        if (tile == null) {
            return;
        }
        this.setMimicState((Level)pLevel, pPos, true);
    }

    public VoxelShape m_6079_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof MirrorWeaveTile) {
            MirrorWeaveTile tile = (MirrorWeaveTile)blockEntity;
            if (tile.mimicState.m_60734_() != this) {
                return tile.mimicState.m_60820_(pLevel, pPos);
            }
        }
        return super.m_6079_(pState, pLevel, pPos);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof MirrorWeaveTile) {
            MirrorWeaveTile tile = (MirrorWeaveTile)blockEntity;
            if (tile.mimicState.m_60734_() != this) {
                return tile.mimicState.m_60808_(pLevel, pPos);
            }
        }
        return super.m_5940_(pState, pLevel, pPos, pContext);
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof MirrorWeaveTile) {
            MirrorWeaveTile tile = (MirrorWeaveTile)blockEntity;
            if (tile.mimicState.m_60734_() != this) {
                return tile.mimicState.m_60742_(pLevel, pPos, pContext);
            }
        }
        return super.m_5939_(pState, pLevel, pPos, pContext);
    }

    public boolean m_180643_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof MirrorWeaveTile) {
            MirrorWeaveTile tile = (MirrorWeaveTile)blockEntity;
            if (tile.mimicState.m_60734_() != this) {
                return tile.mimicState != null && tile.mimicState.m_60838_(pLevel, pPos);
            }
        }
        return super.m_180643_(pState, pLevel, pPos);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new MirrorWeaveTile(pPos, pState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIGHT_LEVEL});
    }
}

