/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class SpellContext
implements Cloneable {
    private boolean isCanceled;
    private Spell spell;
    @Nullable
    private LivingEntity caster;
    private int currentIndex;
    @Nullable
    public BlockEntity castingTile;
    private ParticleColor colors = ParticleColor.defaultParticleColor();
    private CasterType type;
    private Level level;
    public CompoundTag tag = new CompoundTag();
    private IWrappedCaster wrappedCaster;

    @Deprecated(forRemoval=true, since="3.4.0")
    public SpellContext(Level level, @NotNull Spell spell, @Nullable LivingEntity caster) {
        this.level = level;
        this.spell = spell;
        this.caster = caster;
        this.isCanceled = false;
        this.currentIndex = 0;
        this.colors = spell.color.clone();
        this.wrappedCaster = new LivingCaster(this.getUnwrappedCaster());
    }

    public SpellContext(Level level, @NotNull Spell spell, @Nullable LivingEntity caster, IWrappedCaster wrappedCaster) {
        this(level, spell, caster);
        this.wrappedCaster = wrappedCaster;
    }

    @Nullable
    public AbstractSpellPart nextPart() {
        ++this.currentIndex;
        AbstractSpellPart part = null;
        try {
            part = this.getSpell().recipe.get(this.currentIndex - 1);
        }
        catch (Throwable e) {
            System.out.println("=======");
            System.out.println("Invalid spell cast found! This is a bug and should be reported!");
            System.out.println(this.spell.getDisplayString());
            System.out.println("Casting player: ");
            System.out.println(this.caster);
            System.out.println("Casting tile:");
            System.out.println(this.castingTile);
            System.out.println("=======");
            e.printStackTrace();
        }
        return part;
    }

    public boolean hasNextPart() {
        return this.spell.isValid() && !this.isCanceled() && this.currentIndex < this.spell.recipe.size();
    }

    public SpellContext resetCastCounter() {
        this.currentIndex = 0;
        this.isCanceled = false;
        return this;
    }

    @Deprecated(forRemoval=true, since="3.4.0")
    public SpellContext withCastingTile(BlockEntity tile) {
        this.castingTile = tile;
        return this;
    }

    @Deprecated(forRemoval=true, since="3.4.0")
    public SpellContext withCaster(@Nullable LivingEntity caster) {
        this.caster = caster;
        return this;
    }

    public SpellContext withColors(ParticleColor colors) {
        this.colors = colors;
        return this;
    }

    @Deprecated(forRemoval=true, since="3.4.0")
    public SpellContext withType(CasterType type) {
        this.type = type;
        return this;
    }

    public SpellContext withSpell(Spell spell) {
        this.spell = spell;
        return this;
    }

    @NotNull
    public LivingEntity getUnwrappedCaster() {
        Object shooter = this.caster;
        if (shooter == null && this.castingTile != null) {
            shooter = ANFakePlayer.getPlayer((ServerLevel)this.level);
            BlockPos pos = this.castingTile.m_58899_();
            shooter.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        }
        shooter = shooter == null ? ANFakePlayer.getPlayer((ServerLevel)this.level) : shooter;
        return shooter;
    }

    @NotNull
    public IWrappedCaster getCaster() {
        return this.wrappedCaster;
    }

    @Deprecated(forRemoval=true, since="3.4.0")
    public CasterType getType() {
        return this.type == null ? this.wrappedCaster.getCasterType() : this.type;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int newIndex) {
        this.currentIndex = newIndex;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean canceled) {
        this.isCanceled = canceled;
    }

    @NotNull
    public Spell getSpell() {
        return this.spell == null ? new Spell() : this.spell;
    }

    @NotNull
    public Spell getRemainingSpell() {
        if (this.getCurrentIndex() >= this.getSpell().recipe.size()) {
            return this.getSpell().clone().setRecipe(new ArrayList<AbstractSpellPart>());
        }
        return this.getSpell().clone().setRecipe(new ArrayList<AbstractSpellPart>(this.getSpell().recipe.subList(this.getCurrentIndex(), this.getSpell().recipe.size())));
    }

    public SpellContext clone() {
        try {
            SpellContext clone = (SpellContext)super.clone();
            clone.spell = this.spell.clone();
            clone.colors = this.colors.clone();
            clone.tag = this.tag.m_6426_();
            clone.caster = this.caster;
            clone.castingTile = this.castingTile;
            clone.type = this.type;
            clone.level = this.level;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public ParticleColor getColors() {
        return this.colors.clone();
    }

    public void setColors(ParticleColor colors) {
        this.colors = colors;
    }

    public void setCaster(@Nullable LivingEntity caster) {
        this.caster = caster;
    }

    public static class CasterType {
        public static final CasterType RUNE = new CasterType("rune");
        public static final CasterType TURRET = new CasterType("turret");
        public static final CasterType ENTITY = new CasterType("entity");
        public static final CasterType OTHER = new CasterType("other");
        public static final CasterType LIVING_ENTITY = new CasterType("living_entity");
        public static final CasterType PLAYER = new CasterType("player");
        public String id;

        public CasterType(String id) {
            this.id = id;
        }
    }
}

