/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.source;

import com.hollingsworth.arsnouveau.api.source.ISpecialSourceProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class SourceManager {
    private Map<String, Set<ISpecialSourceProvider>> posMap = new HashMap<String, Set<ISpecialSourceProvider>>();
    public static SourceManager INSTANCE = new SourceManager();

    public void addInterface(Level world, ISpecialSourceProvider pos) {
        String key = world.m_46472_().m_135782_().toString();
        if (!this.posMap.containsKey(key)) {
            this.posMap.put(key, new HashSet());
        }
        this.posMap.get(key).add(pos);
    }

    public Set<ISpecialSourceProvider> getSetForLevel(Level world) {
        String key = world.m_46472_().m_135782_().toString();
        return this.posMap.computeIfAbsent(key, k -> new HashSet());
    }

    @Nullable
    public ISpecialSourceProvider takeSourceNearby(BlockPos pos, Level world, int range, int amount) {
        for (ISpecialSourceProvider sourceInterface : this.getSetForLevel(world)) {
            if (!sourceInterface.isValid() || !sourceInterface.getCurrentPos().m_123314_((Vec3i)pos, (double)range)) continue;
            sourceInterface.getSource().removeSource(amount);
            return sourceInterface;
        }
        return null;
    }

    @Nullable
    public ISpecialSourceProvider hasSourceNearby(BlockPos pos, Level world, int range, int amount) {
        for (ISpecialSourceProvider sourceInterface : this.getSetForLevel(world)) {
            if (!sourceInterface.isValid() || !sourceInterface.getCurrentPos().m_123314_((Vec3i)pos, (double)range) || sourceInterface.getSource().getSource() < amount) continue;
            return sourceInterface;
        }
        return null;
    }

    public List<ISpecialSourceProvider> canGiveSourceNearby(BlockPos pos, Level world, int range) {
        ArrayList<ISpecialSourceProvider> list = new ArrayList<ISpecialSourceProvider>();
        for (ISpecialSourceProvider sourceInterface : this.getSetForLevel(world)) {
            if (!sourceInterface.isValid() || !sourceInterface.getCurrentPos().m_123314_((Vec3i)pos, (double)range) || !sourceInterface.getSource().canAcceptSource()) continue;
            list.add(sourceInterface);
        }
        return list;
    }

    public List<ISpecialSourceProvider> canTakeSourceNearby(BlockPos pos, Level world, int range) {
        ArrayList<ISpecialSourceProvider> list = new ArrayList<ISpecialSourceProvider>();
        for (ISpecialSourceProvider sourceInterface : this.getSetForLevel(world)) {
            if (!sourceInterface.isValid() || !sourceInterface.getCurrentPos().m_123314_((Vec3i)pos, (double)range) || sourceInterface.getSource().getSource() < 0) continue;
            list.add(sourceInterface);
        }
        return list;
    }

    public void tick(Level level) {
        if (level.m_46467_() % 60L == 0L) {
            this.getSetForLevel(level).removeIf(iSourceInterface -> !iSourceInterface.isValid());
        }
    }

    private SourceManager() {
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.LevelTickEvent e) {
        if (e.level.f_46443_ || e.phase != TickEvent.Phase.END) {
            return;
        }
        INSTANCE.tick(e.level);
    }
}

