/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.village.wanderer;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.BasicItemListing;
import shadows.apotheosis.adventure.affix.trades.AffixTrade;
import shadows.apotheosis.village.VillageModule;
import shadows.apotheosis.village.wanderer.BasicJsonTrade;
import shadows.apotheosis.village.wanderer.JsonTrade;
import shadows.placebo.json.ItemAdapter;
import shadows.placebo.json.PSerializer;
import shadows.placebo.json.PlaceboJsonReloadListener;

public class WandererTradeManager
extends PlaceboJsonReloadListener<JsonTrade> {
    public static final WandererTradeManager INSTANCE = new WandererTradeManager();
    protected final Map<ResourceLocation, BasicItemListing> registry = new HashMap<ResourceLocation, BasicItemListing>();
    protected final List<VillagerTrades.ItemListing> normTrades = new ArrayList<VillagerTrades.ItemListing>();
    protected final List<VillagerTrades.ItemListing> rareTrades = new ArrayList<VillagerTrades.ItemListing>();

    public WandererTradeManager() {
        super(VillageModule.LOGGER, "wanderer_trades", false, true);
    }

    protected void registerBuiltinSerializers() {
        this.registerSerializer(new ResourceLocation("apotheosis", "basic_trade"), new PSerializer.Builder("Basic JSON Trade").withJsonDeserializer(e -> {
            JsonObject obj = e.getAsJsonObject();
            ItemStack price1 = (ItemStack)ItemAdapter.ITEM_READER.fromJson(obj.get("input_1"), ItemStack.class);
            ItemStack price2 = obj.has("input_2") ? (ItemStack)ItemAdapter.ITEM_READER.fromJson(obj.get("input_2"), ItemStack.class) : ItemStack.f_41583_;
            ItemStack output = (ItemStack)ItemAdapter.ITEM_READER.fromJson(obj.get("output"), ItemStack.class);
            int maxTrades = GsonHelper.m_13824_((JsonObject)obj, (String)"max_trades", (int)1);
            int xp = GsonHelper.m_13824_((JsonObject)obj, (String)"xp", (int)0);
            float priceMult = GsonHelper.m_13820_((JsonObject)obj, (String)"price_mult", (float)1.0f);
            boolean rare = GsonHelper.m_13855_((JsonObject)obj, (String)"rare", (boolean)false);
            return new BasicJsonTrade(price1, price2, output, maxTrades, xp, priceMult, rare);
        }));
        this.registerSerializer(new ResourceLocation("apotheosis", "affix"), new PSerializer.Builder("Affix Trade").withJsonDeserializer(obj -> (JsonTrade)ItemAdapter.ITEM_READER.fromJson(obj, AffixTrade.class)));
    }

    protected <T extends JsonTrade> void register(ResourceLocation key, T trade) {
        super.register(key, trade);
    }

    protected void onReload() {
        super.onReload();
        this.getValues().forEach(trade -> {
            if (trade.isRare()) {
                this.rareTrades.add((VillagerTrades.ItemListing)trade);
            } else {
                this.normTrades.add((VillagerTrades.ItemListing)trade);
            }
        });
    }

    public List<VillagerTrades.ItemListing> getNormalTrades() {
        return this.normTrades;
    }

    public List<VillagerTrades.ItemListing> getRareTrades() {
        return this.rareTrades;
    }
}

