/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.table;

import it.unimi.dsi.fastutil.floats.Float2FloatMap;
import it.unimi.dsi.fastutil.floats.Float2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.network.simple.SimpleChannel;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.advancements.EnchantedTrigger;
import shadows.apotheosis.ench.table.ApothEnchantTile;
import shadows.apotheosis.ench.table.ClueMessage;
import shadows.apotheosis.ench.table.EnchantingRecipe;
import shadows.apotheosis.ench.table.EnchantingStatManager;
import shadows.apotheosis.ench.table.IEnchantableItem;
import shadows.apotheosis.ench.table.RealEnchantmentHelper;
import shadows.apotheosis.util.FloatReferenceHolder;
import shadows.placebo.network.PacketDistro;

public class ApothEnchantContainer
extends EnchantmentMenu {
    protected final FloatReferenceHolder eterna = new FloatReferenceHolder(0.0f, 0.0f, EnchantingStatManager.getAbsoluteMaxEterna());
    protected final FloatReferenceHolder quanta = new FloatReferenceHolder(0.0f, 0.0f, 100.0f);
    protected final FloatReferenceHolder arcana = new FloatReferenceHolder(0.0f, 0.0f, 100.0f);
    protected final FloatReferenceHolder rectification = new FloatReferenceHolder(0.0f, -100.0f, 100.0f);
    protected final DataSlot clues = DataSlot.m_39401_();
    protected final Player player;

    public ApothEnchantContainer(int id, Inventory inv) {
        super(id, inv, ContainerLevelAccess.f_39287_);
        this.player = inv.f_35978_;
        this.f_38839_.clear();
        this.addSecretSlot(new Slot(this.f_39449_, 0, 15, 47){

            public boolean m_5857_(ItemStack stack) {
                return true;
            }

            public int m_6641_() {
                return 1;
            }
        });
        this.addSecretSlot(new Slot(this.f_39449_, 1, 35, 47){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_204117_(Tags.Items.ENCHANTING_FUELS);
            }
        });
        this.initCommon(inv);
    }

    public ApothEnchantContainer(int id, Inventory inv, ContainerLevelAccess wPos, ApothEnchantTile te) {
        super(id, inv, wPos);
        this.player = inv.f_35978_;
        this.f_38839_.clear();
        this.addSecretSlot(new Slot(this.f_39449_, 0, 15, 47){

            public boolean m_5857_(ItemStack stack) {
                return true;
            }

            public int m_6641_() {
                return 1;
            }
        });
        this.addSecretSlot((Slot)new SlotItemHandler((IItemHandler)te.inv, 0, 35, 47){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_204117_(Tags.Items.ENCHANTING_FUELS);
            }
        });
        this.initCommon(inv);
    }

    protected Slot addSecretSlot(Slot pSlot) {
        pSlot.f_40219_ = this.f_38839_.size();
        this.f_38839_.add((Object)pSlot);
        return pSlot;
    }

    private void initCommon(Inventory inv) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSecretSlot(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18 + 31));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSecretSlot(new Slot((Container)inv, k, 8 + k * 18, 173));
        }
        this.m_38884_((ContainerData)this.eterna.getArray());
        this.m_38884_((ContainerData)this.quanta.getArray());
        this.m_38884_((ContainerData)this.arcana.getArray());
        this.m_38884_((ContainerData)this.rectification.getArray());
        this.clues.m_6422_(0);
        this.m_38895_(this.clues);
    }

    public boolean m_6366_(Player player, int id) {
        int level = this.f_39446_[id];
        ItemStack toEnchant = this.f_39449_.m_8020_(0);
        ItemStack lapis = this.m_38853_(1).m_7993_();
        int cost = id + 1;
        if ((lapis.m_41619_() || lapis.m_41613_() < cost) && !player.m_150110_().f_35937_) {
            return false;
        }
        if (this.f_39446_[id] <= 0 || toEnchant.m_41619_() || (player.f_36078_ < cost || player.f_36078_ < this.f_39446_[id]) && !player.m_150110_().f_35937_) {
            return false;
        }
        this.f_39450_.m_39292_((world, pos) -> {
            ItemStack enchanted = toEnchant;
            float eterna = this.eterna.get();
            float quanta = this.quanta.get();
            float arcana = this.arcana.get();
            float rectification = this.rectification.get();
            List<EnchantmentInstance> list = this.getEnchantmentList(toEnchant, id, this.f_39446_[id]);
            if (list.isEmpty()) return;
            player.m_7408_(toEnchant, cost);
            if (list.get((int)0).f_44947_ == Apoth.Enchantments.INFUSION.get()) {
                EnchantingRecipe match = EnchantingRecipe.findMatch(world, toEnchant, eterna, quanta, arcana);
                if (match == null) return;
                this.f_39449_.m_6836_(0, match.assemble(toEnchant, eterna, quanta, arcana));
            } else {
                this.f_39449_.m_6836_(0, ((IEnchantableItem)toEnchant.m_41720_()).onEnchantment(toEnchant, list));
            }
            if (!player.m_150110_().f_35937_) {
                lapis.m_41774_(cost);
                if (lapis.m_41619_()) {
                    this.f_39449_.m_6836_(1, ItemStack.f_41583_);
                }
            }
            player.m_36220_(Stats.f_12964_);
            if (player instanceof ServerPlayer) {
                ((EnchantedTrigger)CriteriaTriggers.f_10575_).trigger((ServerPlayer)player, enchanted, level, eterna, quanta, arcana, rectification);
            }
            this.f_39449_.m_6596_();
            this.f_39452_.m_6422_(player.m_36322_());
            this.m_6199_(this.f_39449_);
            world.m_5594_((Player)null, pos, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
        });
        return true;
    }

    public void m_6199_(Container inventoryIn) {
        this.f_39450_.m_6721_((world, pos) -> {
            if (inventoryIn == this.f_39449_) {
                ItemStack toEnchant = inventoryIn.m_8020_(0);
                this.gatherStats();
                EnchantingRecipe match = EnchantingRecipe.findItemMatch(world, toEnchant);
                if (toEnchant.m_41613_() == 1 && (match != null || toEnchant.m_41720_().m_8120_(toEnchant) && ApothEnchantContainer.isEnchantableEnough(toEnchant))) {
                    int slot;
                    float eterna = this.eterna.get();
                    if ((double)eterna < 1.5) {
                        eterna = 1.5f;
                    }
                    this.f_39451_.m_188584_((long)this.f_39452_.m_6501_());
                    for (slot = 0; slot < 3; ++slot) {
                        this.f_39446_[slot] = RealEnchantmentHelper.getEnchantmentCost(this.f_39451_, slot, eterna, toEnchant);
                        this.f_39447_[slot] = -1;
                        this.f_39448_[slot] = -1;
                        if (this.f_39446_[slot] < slot + 1) {
                            int n = slot;
                            this.f_39446_[n] = this.f_39446_[n] + 1;
                        }
                        this.f_39446_[slot] = ForgeEventFactory.onEnchantmentLevelSet((Level)world, (BlockPos)pos, (int)slot, (int)Math.round(eterna), (ItemStack)toEnchant, (int)this.f_39446_[slot]);
                    }
                    for (slot = 0; slot < 3; ++slot) {
                        List<EnchantmentInstance> list;
                        if (this.f_39446_[slot] <= 0 || (list = this.getEnchantmentList(toEnchant, slot, this.f_39446_[slot])) == null || list.isEmpty()) continue;
                        EnchantmentInstance enchantmentdata = list.remove(this.f_39451_.m_188503_(list.size()));
                        this.f_39447_[slot] = Registry.f_122825_.m_7447_((Object)enchantmentdata.f_44947_);
                        this.f_39448_[slot] = enchantmentdata.f_44948_;
                        int clues = 1 + this.clues.m_6501_();
                        ArrayList<EnchantmentInstance> clueList = new ArrayList<EnchantmentInstance>();
                        if (clues-- > 0) {
                            clueList.add(enchantmentdata);
                        }
                        while (clues-- > 0 && !list.isEmpty()) {
                            clueList.add(list.remove(this.f_39451_.m_188503_(list.size())));
                        }
                        PacketDistro.sendTo((SimpleChannel)Apotheosis.CHANNEL, (Object)new ClueMessage(slot, clueList, list.isEmpty()), (Player)this.player);
                    }
                    this.m_38946_();
                } else {
                    for (int i = 0; i < 3; ++i) {
                        this.f_39446_[i] = 0;
                        this.f_39447_[i] = -1;
                        this.f_39448_[i] = -1;
                    }
                    this.eterna.set(0.0f);
                    this.quanta.set(0.0f);
                    this.arcana.set(0.0f);
                }
            }
            return this;
        });
    }

    private List<EnchantmentInstance> getEnchantmentList(ItemStack stack, int enchantSlot, int level) {
        this.f_39451_.m_188584_((long)(this.f_39452_.m_6501_() + enchantSlot));
        List<EnchantmentInstance> list = RealEnchantmentHelper.selectEnchantment(this.f_39451_, stack, level, this.quanta.get(), this.arcana.get(), this.rectification.get(), false);
        EnchantingRecipe match = ((Optional)this.f_39450_.m_6721_((world, pos) -> Optional.ofNullable(EnchantingRecipe.findMatch(world, stack, this.eterna.get(), this.quanta.get(), this.arcana.get()))).get()).orElse(null);
        if (enchantSlot == 2 && match != null) {
            list.clear();
            list.add(new EnchantmentInstance((Enchantment)Apoth.Enchantments.INFUSION.get(), 1));
        }
        return list;
    }

    public void gatherStats() {
        this.f_39450_.m_6721_((world, pos) -> {
            Float2FloatOpenHashMap eternaMap = new Float2FloatOpenHashMap();
            float[] stats = new float[]{0.0f, 15.0f, 0.0f, 0.0f, 0.0f};
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (j == 0 && k == 0 || !ApothEnchantContainer.isEmptyEnough(world, pos.m_7918_(k, 0, j)) || !ApothEnchantContainer.isEmptyEnough(world, pos.m_7918_(k, 1, j))) continue;
                    ApothEnchantContainer.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.m_7918_(k * 2, 0, j * 2));
                    ApothEnchantContainer.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.m_7918_(k * 2, 1, j * 2));
                    if (k == 0 || j == 0) continue;
                    ApothEnchantContainer.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.m_7918_(k * 2, 0, j));
                    ApothEnchantContainer.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.m_7918_(k * 2, 1, j));
                    ApothEnchantContainer.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.m_7918_(k, 0, j * 2));
                    ApothEnchantContainer.gatherStats((Float2FloatMap)eternaMap, stats, world, pos.m_7918_(k, 1, j * 2));
                }
            }
            ArrayList entries = new ArrayList(eternaMap.float2FloatEntrySet());
            Collections.sort(entries, Comparator.comparing(Float2FloatMap.Entry::getFloatKey));
            for (Float2FloatMap.Entry e : entries) {
                if (e.getFloatKey() > 0.0f) {
                    stats[0] = Math.min(e.getFloatKey(), stats[0] + e.getFloatValue());
                    continue;
                }
                stats[0] = stats[0] + e.getFloatValue();
            }
            this.eterna.set(stats[0]);
            this.quanta.set(stats[1]);
            this.arcana.set(stats[2] + (float)this.m_38853_(0).m_7993_().getEnchantmentValue() / 2.0f);
            this.rectification.set(stats[3]);
            this.clues.m_6422_((int)stats[4]);
            return this;
        }).orElse(this);
    }

    private static boolean isEmptyEnough(Level level, BlockPos pos) {
        return level.m_46859_(pos) || level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
    }

    public static void gatherStats(Float2FloatMap eternaMap, float[] stats, Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_()) {
            return;
        }
        float max = EnchantingStatManager.getMaxEterna(state, world, pos);
        float eterna = EnchantingStatManager.getEterna(state, world, pos);
        eternaMap.put(max, eternaMap.getOrDefault(max, 0.0f) + eterna);
        float quanta = EnchantingStatManager.getQuanta(state, world, pos);
        stats[1] = stats[1] + quanta;
        float arcana = EnchantingStatManager.getArcana(state, world, pos);
        stats[2] = stats[2] + arcana;
        float quantaRec = EnchantingStatManager.getQuantaRectification(state, world, pos);
        stats[3] = stats[3] + quantaRec;
        int clues = EnchantingStatManager.getBonusClues(state, world, pos);
        stats[4] = stats[4] + (float)clues;
    }

    public MenuType<?> m_6772_() {
        return (MenuType)Apoth.Menus.ENCHANTING_TABLE.get();
    }

    public static boolean isEnchantableEnough(ItemStack stack) {
        if (!stack.m_41793_()) {
            return true;
        }
        return EnchantmentHelper.m_44831_((ItemStack)stack).keySet().stream().allMatch(Enchantment::m_6589_);
    }

    public static enum Arcana {
        EMPTY(0.0f, 10, 5, 2, 1),
        LITTLE(10.0f, 8, 5, 3, 1),
        FEW(20.0f, 7, 5, 4, 2),
        SOME(30.0f, 5, 5, 4, 2),
        LESS(40.0f, 5, 5, 4, 3),
        MEDIUM(50.0f, 5, 5, 5, 5),
        MORE(60.0f, 3, 4, 5, 5),
        VALUE(70.0f, 2, 4, 5, 5),
        EXTRA(80.0f, 2, 4, 5, 7),
        ALMOST(90.0f, 1, 3, 5, 8),
        MAX(99.0f, 1, 2, 5, 10);

        final float threshold;
        final int[] rarities;
        static Arcana[] VALUES;

        private Arcana(float threshold, int ... rarities) {
            this.threshold = threshold;
            this.rarities = rarities;
        }

        public int[] getRarities() {
            return this.rarities;
        }

        public static Arcana getForThreshold(float threshold) {
            for (int i = VALUES.length - 1; i >= 0; --i) {
                if (!(threshold >= Arcana.VALUES[i].threshold)) continue;
                return VALUES[i];
            }
            return EMPTY;
        }

        static {
            VALUES = Arcana.values();
        }
    }
}

