/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableInt;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.placebo.color.GradientColor;
import shadows.placebo.json.WeightedJsonReloadListener;

public record LootRarity(int defaultWeight, String id, TextColor color, List<LootRule> rules, int ordinal) implements WeightedJsonReloadListener.ILuckyWeighted
{
    public static final List<LootRarity> LIST;
    public static final Map<String, LootRarity> BY_ID;
    public static final Map<LootRarity, float[]> WEIGHTS;
    public static final LootRarity COMMON;
    public static final LootRarity UNCOMMON;
    public static final LootRarity RARE;
    public static final LootRarity EPIC;
    public static final LootRarity MYTHIC;
    public static final LootRarity ANCIENT;
    private static int num;

    private LootRarity(int defaultWeight, String id, TextColor color, List<LootRule> rules) {
        this(defaultWeight, id, color, rules, num++);
    }

    private LootRarity(int defaultWeight, String id, int color, List<LootRule> rules) {
        this(defaultWeight, id, TextColor.m_131266_((int)color), rules);
    }

    public float getQuality() {
        return WEIGHTS.get(this)[1];
    }

    public int getWeight() {
        return (int)WEIGHTS.get(this)[0];
    }

    public boolean isAtLeast(LootRarity other) {
        return this.ordinal() >= other.ordinal();
    }

    public LootRarity min(@Nullable LootRarity other) {
        if (other == null) {
            return this;
        }
        return this.ordinal <= other.ordinal ? this : other;
    }

    public LootRarity max(@Nullable LootRarity other) {
        if (other == null) {
            return this;
        }
        return this.ordinal >= other.ordinal ? this : other;
    }

    public LootRarity clamp(LootRarity lowerBound, LootRarity upperBound) {
        return this.min(upperBound).max(lowerBound);
    }

    public Component toComponent() {
        return Component.m_237115_((String)("rarity.apoth." + this.id)).m_130948_(Style.f_131099_.m_131148_(this.color));
    }

    @Override
    public String toString() {
        return this.id;
    }

    public static LootRarity byId(String id) {
        return BY_ID.get(id.toLowerCase(Locale.ROOT));
    }

    public static Set<String> ids() {
        return BY_ID.keySet();
    }

    public static List<LootRarity> values() {
        return LIST;
    }

    public static LootRarity random(RandomSource rand, float luck) {
        return LootRarity.random(rand, luck, null, null);
    }

    public static LootRarity random(RandomSource rand, float luck, @Nullable Clamped item) {
        if (item == null) {
            return LootRarity.random(rand, luck);
        }
        return LootRarity.random(rand, luck, item.getMinRarity(), item.getMaxRarity());
    }

    public static LootRarity random(RandomSource rand, float luck, @Nullable LootRarity min, @Nullable LootRarity max) {
        List<WeightedEntry.Wrapper> list = LIST.stream().filter(r -> r.clamp(min, max) == r).map(r -> r.wrap(luck)).toList();
        return WeightedRandom.m_216822_((RandomSource)rand, list).map(WeightedEntry.Wrapper::m_146310_).get();
    }

    static {
        WEIGHTS = new HashMap<LootRarity, float[]>();
        COMMON = new LootRarity(400, "common", 0x808080, (List<LootRule>)ImmutableList.of((Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 0.25f)));
        UNCOMMON = new LootRarity(320, "uncommon", 0x33FF33, (List<LootRule>)ImmutableList.of((Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 0.45f, new LootRule(AffixType.ABILITY, 0.25f)), (Object)new LootRule(AffixType.SOCKET, 0.2f)));
        RARE = new LootRarity(150, "rare", 0x5555FF, (List<LootRule>)ImmutableList.of((Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 1.0f, new LootRule(AffixType.ABILITY, 0.25f)), (Object)new LootRule(AffixType.ABILITY, 1.0f), (Object)new LootRule(AffixType.ABILITY, 0.33f), (Object)new LootRule(AffixType.SOCKET, 0.33f), (Object)new LootRule(AffixType.DURABILITY, 0.1f)));
        EPIC = new LootRarity(90, "epic", 0xBB00BB, (List<LootRule>)ImmutableList.of((Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 1.0f, new LootRule(AffixType.ABILITY, 0.45f)), (Object)new LootRule(AffixType.STAT, 0.5f, new LootRule(AffixType.ABILITY, 0.33f)), (Object)new LootRule(AffixType.ABILITY, 1.0f), (Object)new LootRule(AffixType.ABILITY, 0.65f), (Object)new LootRule(AffixType.SOCKET, 0.5f), (Object)new LootRule(AffixType.SOCKET, 0.33f), (Object)new LootRule(AffixType.DURABILITY, 0.3f)));
        MYTHIC = new LootRarity(40, "mythic", 15560724, (List<LootRule>)ImmutableList.of((Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 1.0f, new LootRule(AffixType.ABILITY, 0.5f)), (Object)new LootRule(AffixType.STAT, 1.0f, new LootRule(AffixType.ABILITY, 0.4f)), (Object)new LootRule(AffixType.ABILITY, 1.0f), (Object)new LootRule(AffixType.ABILITY, 1.0f), (Object)new LootRule(AffixType.ABILITY, 0.3f), (Object)new LootRule(AffixType.SOCKET, 0.5f), (Object)new LootRule(AffixType.SOCKET, 0.45f), (Object)new LootRule(AffixType.SOCKET, 0.4f), (Object)new LootRule(AffixType.DURABILITY, 0.5f)));
        ANCIENT = new LootRarity(0, "ancient", (TextColor)GradientColor.RAINBOW, (List<LootRule>)ImmutableList.of((Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 1.0f, new LootRule(AffixType.ABILITY, 0.7f)), (Object)new LootRule(AffixType.STAT, 1.0f, new LootRule(AffixType.ABILITY, 0.6f)), (Object)new LootRule(AffixType.STAT, 1.0f, new LootRule(AffixType.ABILITY, 0.5f)), (Object)new LootRule(AffixType.STAT, 1.0f, new LootRule(AffixType.ABILITY, 0.4f)), (Object)new LootRule(AffixType.ABILITY, 1.0f), (Object)new LootRule(AffixType.ABILITY, 1.0f), (Object)new LootRule(AffixType.ABILITY, 0.75f), (Object)new LootRule(AffixType.ABILITY, 0.45f), (Object)new LootRule(AffixType.SOCKET, 1.0f), (Object)new LootRule(AffixType.SOCKET, 0.85f), (Object[])new LootRule[]{new LootRule(AffixType.SOCKET, 0.65f), new LootRule(AffixType.SOCKET, 0.45f), new LootRule(AffixType.SOCKET, 0.25f), new LootRule(AffixType.DURABILITY, 0.75f)}));
        LIST = ImmutableList.of((Object)COMMON, (Object)UNCOMMON, (Object)RARE, (Object)EPIC, (Object)MYTHIC, (Object)ANCIENT);
        BY_ID = ImmutableMap.copyOf(LIST.stream().collect(Collectors.toMap(LootRarity::id, Function.identity())));
        num = 0;
    }

    public static interface Clamped {
        public LootRarity getMinRarity();

        public LootRarity getMaxRarity();

        default public LootRarity clamp(LootRarity rarity) {
            return rarity.clamp(this.getMinRarity(), this.getMaxRarity());
        }
    }

    public record LootRule(AffixType type, float chance, @Nullable LootRule backup) {
        private static Random jRand = new Random();

        public LootRule(AffixType type, float chance) {
            this(type, chance, null);
        }

        public void execute(ItemStack stack, LootRarity rarity, Set<Affix> currentAffixes, MutableInt sockets, RandomSource rand) {
            if (this.type == AffixType.DURABILITY) {
                return;
            }
            if (rand.m_188501_() <= this.chance) {
                if (this.type == AffixType.SOCKET) {
                    sockets.add(1);
                    return;
                }
                List available = AffixHelper.byType(this.type).stream().filter(a -> a.canApplyTo(stack, rarity) && !currentAffixes.contains(a)).collect(Collectors.toList());
                if (available.size() == 0) {
                    if (this.backup != null) {
                        this.backup.execute(stack, rarity, currentAffixes, sockets, rand);
                    } else {
                        AdventureModule.LOGGER.error("Failed to execute LootRule {}/{}/{}/{}!", (Object)ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), (Object)rarity.id(), (Object)this.type, (Object)Float.valueOf(this.chance));
                    }
                    return;
                }
                jRand.setSeed(rand.m_188505_());
                Collections.shuffle(available, jRand);
                currentAffixes.add((Affix)((Object)available.get(0)));
            }
        }
    }

    public static class Serializer
    implements JsonSerializer<LootRarity>,
    JsonDeserializer<LootRarity> {
        public LootRarity deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return LootRarity.byId(json.getAsString());
        }

        public JsonElement serialize(LootRarity src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.id);
        }
    }
}

