/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixInstance;
import shadows.apotheosis.adventure.affix.AffixManager;
import shadows.apotheosis.adventure.affix.effect.DamageReductionAffix;
import shadows.apotheosis.adventure.affix.socket.gem.GemManager;
import shadows.apotheosis.adventure.commands.CategoryCheckCommand;
import shadows.apotheosis.adventure.commands.GemCommand;
import shadows.apotheosis.adventure.commands.LootifyCommand;
import shadows.apotheosis.adventure.commands.ModifierCommand;
import shadows.apotheosis.adventure.commands.RarityCommand;
import shadows.apotheosis.adventure.commands.SocketCommand;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootController;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.apotheosis.util.DamageSourceUtil;
import shadows.placebo.events.AnvilLandEvent;
import shadows.placebo.events.ItemUseEvent;
import shadows.placebo.json.WeightedJsonReloadListener;

public class AdventureEvents {
    private static final UUID HEAVY_WEAPON_AS = UUID.fromString("f8c3de3d-1fea-4d7c-a8b0-29f63c4c3454");
    private static final Set<Float> values = ImmutableSet.of((Object)Float.valueOf(0.1f), (Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.33f), (Object)Float.valueOf(0.5f), (Object)Float.valueOf(1.0f), (Object[])new Float[]{Float.valueOf(1.1f), Float.valueOf(1.2f), Float.valueOf(1.25f), Float.valueOf(1.33f), Float.valueOf(1.5f), Float.valueOf(2.0f), Float.valueOf(2.1f), Float.valueOf(2.25f), Float.valueOf(2.33f), Float.valueOf(2.5f), Float.valueOf(3.0f)});
    private static boolean noRecurse = false;

    @SubscribeEvent
    public void reloads(AddReloadListenerEvent e) {
    }

    @SubscribeEvent
    public void cmds(Apotheosis.ApotheosisCommandEvent e) {
        RarityCommand.register(e.getRoot());
        CategoryCheckCommand.register(e.getRoot());
        LootifyCommand.register(e.getRoot());
        ModifierCommand.register(e.getRoot());
        GemCommand.register(e.getRoot());
        SocketCommand.register(e.getRoot());
    }

    @SubscribeEvent
    public void affixModifiers(ItemAttributeModifierEvent e) {
        ItemStack stack = e.getItemStack();
        if (stack.m_41782_()) {
            Map<Affix, AffixInstance> affixes = AffixHelper.getAffixes(stack);
            affixes.forEach((afx, inst) -> inst.addModifiers(e.getSlotType(), (arg_0, arg_1) -> ((ItemAttributeModifierEvent)e).addModifier(arg_0, arg_1)));
            if (AffixHelper.getRarity(stack) != null && LootCategory.forItem(stack) == LootCategory.HEAVY_WEAPON && e.getSlotType() == EquipmentSlot.MAINHAND) {
                double amt = -0.15 - 0.1 * (double)AffixHelper.getRarity(stack).ordinal();
                e.addModifier(Attributes.f_22283_, new AttributeModifier(HEAVY_WEAPON_AS, "Heavy Weapon AS", amt, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
        }
    }

    @SubscribeEvent
    public void drawSpeed(LivingEntityUseItemEvent.Tick e) {
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            double t = player.m_21051_((Attribute)Apoth.Attributes.DRAW_SPEED.get()).m_22135_() - 1.0;
            if (t == 0.0 || !LootCategory.forItem(e.getItem()).isRanged()) {
                return;
            }
            for (float clamped = values.stream().filter(f -> (double)f.floatValue() >= t).min(Float::compareTo).orElse(Float.valueOf(3.0f)).floatValue(); clamped > 0.0f; clamped -= 1.0f) {
                if (e.getEntity().f_19797_ % (int)Math.floor(1.0 / Math.min(1.0, t)) != 0) continue;
                e.setDuration(e.getDuration() - 1);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void fireArrow(EntityJoinLevelEvent e) {
        Entity shooter;
        AbstractArrow arrow;
        Entity entity = e.getEntity();
        if (entity instanceof AbstractArrow && !(arrow = (AbstractArrow)entity).getPersistentData().m_128471_("apoth.generated") && (shooter = arrow.m_37282_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)shooter;
            ItemStack bow = living.m_21205_();
            Map<Affix, AffixInstance> affixes = AffixHelper.getAffixes(bow);
            CompoundTag nbt = new CompoundTag();
            affixes.values().forEach(a -> {
                a.onArrowFired(living, arrow);
                nbt.m_128350_(a.affix().getId().toString(), a.level());
                nbt.m_128359_("rarity", a.rarity().id());
            });
            arrow.getPersistentData().m_128365_("apoth.affixes", (Tag)nbt);
        }
    }

    @SubscribeEvent
    public void impact(ProjectileImpactEvent e) {
        Projectile projectile = e.getProjectile();
        if (projectile instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)projectile;
            CompoundTag nbt = arrow.getPersistentData().m_128469_("apoth.affixes");
            LootRarity rarity = AffixHelper.getRarity(nbt);
            for (String s : nbt.m_128431_()) {
                Affix a = (Affix)AffixManager.INSTANCE.getValue(new ResourceLocation(s));
                if (a == null) continue;
                a.onArrowImpact(rarity, nbt.m_128457_(s), arrow, e.getRayTraceResult(), e.getRayTraceResult().m_6662_());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void pierce(LivingHurtEvent e) {
        Entity entity = e.getSource().m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (!e.getSource().m_19376_() && !e.getSource().m_19387_()) {
                LivingEntity target = e.getEntity();
                float pierce = (float)(attacker.m_21133_((Attribute)Apoth.Attributes.PIERCING.get()) - 1.0);
                if ((double)pierce > 0.001) {
                    float pierceDmg = e.getAmount() * pierce;
                    e.setAmount(e.getAmount() - pierceDmg);
                    int time = target.f_19802_;
                    target.f_19802_ = 0;
                    target.m_6469_(DamageSourceUtil.copy(e.getSource()).m_19380_(), pierceDmg);
                    target.f_19802_ = time;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onDamage(LivingHurtEvent e) {
        Apoth.Affixes.MAGICAL.ifPresent(afx -> afx.onHurt(e));
        DamageReductionAffix.onHurt(e);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void afterDamage(LivingHurtEvent e) {
        Entity entity = e.getSource().m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (!e.getSource().m_19387_()) {
                float overheal;
                float lifesteal = (float)attacker.m_21133_((Attribute)Apoth.Attributes.LIFE_STEAL.get()) - 1.0f;
                float dmg = Math.min(e.getAmount(), e.getEntity().m_21223_());
                if ((double)lifesteal > 0.001) {
                    attacker.m_5634_(dmg * lifesteal);
                }
                if ((overheal = (float)attacker.m_21133_((Attribute)Apoth.Attributes.OVERHEAL.get()) - 1.0f) > 0.0f && attacker.m_6103_() < 20.0f) {
                    attacker.m_7911_(Math.min(20.0f, attacker.m_6103_() + dmg * overheal));
                }
            }
        }
        if (e.getSource() == DamageSource.f_19310_ && e.getEntity().getPersistentData().m_128441_("apoth.boss")) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void attack(LivingAttackEvent e) {
        if (e.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (noRecurse) {
            return;
        }
        noRecurse = true;
        Entity entity = e.getSource().m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (!e.getSource().m_19387_()) {
                float hpDmg = (float)attacker.m_21133_((Attribute)Apoth.Attributes.CURRENT_HP_DAMAGE.get()) - 1.0f;
                float fireDmg = (float)attacker.m_21133_((Attribute)Apoth.Attributes.FIRE_DAMAGE.get());
                float coldDmg = (float)attacker.m_21133_((Attribute)Apoth.Attributes.COLD_DAMAGE.get());
                LivingEntity target = e.getEntity();
                int time = target.f_19802_;
                target.f_19802_ = 0;
                if ((double)hpDmg > 0.001 && Apotheosis.localAtkStrength >= 0.85f) {
                    target.m_6469_(AdventureEvents.src(attacker), Apotheosis.localAtkStrength * hpDmg * target.m_21223_());
                }
                target.f_19802_ = 0;
                if ((double)fireDmg > 0.001 && Apotheosis.localAtkStrength >= 0.45f) {
                    target.m_6469_(AdventureEvents.src(attacker).m_19389_().m_19380_(), Apotheosis.localAtkStrength * fireDmg);
                    target.m_7311_(Math.max(target.m_20094_(), (int)(15.0f * fireDmg)));
                }
                target.f_19802_ = 0;
                if ((double)coldDmg > 0.001 && Apotheosis.localAtkStrength >= 0.45f) {
                    target.m_6469_(AdventureEvents.src(attacker).m_19389_().m_19380_(), Apotheosis.localAtkStrength * coldDmg);
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, (int)(15.0f * coldDmg), Mth.m_14143_((float)(coldDmg / 5.0f))));
                }
                target.f_19802_ = time;
            }
        }
        noRecurse = false;
    }

    private static DamageSource src(LivingEntity entity) {
        DamageSource damageSource;
        if (entity instanceof Player) {
            Player p = (Player)entity;
            damageSource = DamageSource.m_19344_((Player)p);
        } else {
            damageSource = DamageSource.m_19370_((LivingEntity)entity);
        }
        return damageSource;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void crit(CriticalHitEvent e) {
        double critChance = e.getEntity().m_21133_((Attribute)Apoth.Attributes.CRIT_CHANCE.get()) - 1.0;
        float critDmg = (float)e.getEntity().m_21133_((Attribute)Apoth.Attributes.CRIT_DAMAGE.get());
        float overcritMult = Math.max(1.5f, critDmg - 1.5f);
        RandomSource rand = e.getEntity().f_19796_;
        if (e.isVanillaCritical() && critChance >= 0.5) {
            critChance -= 0.5;
            critDmg *= 1.5f;
        }
        if ((double)rand.m_188501_() <= critChance || critChance >= 1.0) {
            e.setResult(Event.Result.ALLOW);
        }
        critChance -= 1.0;
        while ((double)rand.m_188501_() <= critChance) {
            e.setResult(Event.Result.ALLOW);
            critChance -= 1.0;
            critDmg *= overcritMult;
        }
        e.setDamageModifier(critDmg);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void breakSpd(PlayerEvent.BreakSpeed e) {
        e.setNewSpeed(e.getNewSpeed() * (float)e.getEntity().m_21133_((Attribute)Apoth.Attributes.MINING_SPEED.get()));
    }

    @SubscribeEvent
    public void onItemUse(ItemUseEvent e) {
        ItemStack s = e.getItemStack();
        Map<Affix, AffixInstance> affixes = AffixHelper.getAffixes(s);
        for (AffixInstance inst : affixes.values()) {
            InteractionResult type = inst.onItemUse(e.getContext());
            if (type == null) continue;
            e.setCanceled(true);
            e.setCancellationResult(type);
        }
    }

    @SubscribeEvent
    public void shieldBlock(ShieldBlockEvent e) {
        ItemStack stack = e.getEntity().m_21211_();
        Map<Affix, AffixInstance> affixes = AffixHelper.getAffixes(stack);
        float blocked = e.getBlockedDamage();
        for (AffixInstance inst : affixes.values()) {
            blocked = inst.onShieldBlock(e.getEntity(), e.getDamageSource(), blocked);
        }
        if (blocked != e.getOriginalBlockedDamage()) {
            e.setBlockedDamage(blocked);
        }
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent e) {
        ItemStack stack = e.getPlayer().m_21205_();
        Map<Affix, AffixInstance> affixes = AffixHelper.getAffixes(stack);
        for (AffixInstance inst : affixes.values()) {
            inst.onBlockBreak(e.getPlayer(), e.getLevel(), e.getPos(), e.getState());
        }
    }

    @SubscribeEvent
    public void arrow(EntityJoinLevelEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)entity;
            if (arrow.f_19853_.f_46443_ || arrow.getPersistentData().m_128471_("apoth.attrib.done")) {
                return;
            }
            Entity entity2 = arrow.m_37282_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity2;
                arrow.m_36781_(arrow.m_36789_() * le.m_21133_((Attribute)Apoth.Attributes.ARROW_DAMAGE.get()));
                arrow.m_20256_(arrow.m_20184_().m_82490_(le.m_21133_((Attribute)Apoth.Attributes.ARROW_VELOCITY.get())));
                if (!arrow.m_36792_()) {
                    arrow.m_36762_((double)arrow.f_19796_.m_188501_() <= le.m_21133_((Attribute)Apoth.Attributes.CRIT_CHANCE.get()) - 1.0);
                }
            }
            arrow.getPersistentData().m_128379_("apoth.attrib.done", true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void dropsHigh(LivingDropsEvent e) {
        Entity entity = e.getSource().m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)entity;
            if (e.getEntity() instanceof Monster) {
                if (p instanceof FakePlayer) {
                    return;
                }
                float chance = AdventureConfig.gemDropChance + (e.getEntity().getPersistentData().m_128441_("apoth.boss") ? AdventureConfig.gemBossBonus : 0.0f);
                if (p.f_19796_.m_188501_() <= chance) {
                    LivingEntity ent = e.getEntity();
                    e.getDrops().add(new ItemEntity(ent.f_19853_, ent.m_20185_(), ent.m_20186_(), ent.m_20189_(), GemManager.getRandomGemStack(p.f_19796_, p.m_36336_(), WeightedJsonReloadListener.IDimensional.matches((Level)p.m_9236_())), 0.0, 0.0, 0.0));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void drops(LivingDropsEvent e) {
        Apoth.Affixes.FESTIVE.ifPresent(afx -> afx.drops(e));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void deathMark(LivingDeathEvent e) {
        Apoth.Affixes.FESTIVE.ifPresent(afx -> afx.markEquipment(e));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void dropsLowest(LivingDropsEvent e) {
        Apoth.Affixes.TELEPATHIC.ifPresent(afx -> afx.drops(e));
    }

    @SubscribeEvent
    public void harvest(PlayerEvent.HarvestCheck e) {
        Apoth.Affixes.OMNETIC.ifPresent(afx -> afx.harvest(e));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void speed(PlayerEvent.BreakSpeed e) {
        Apoth.Affixes.OMNETIC.ifPresent(afx -> afx.speed(e));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onBreak(BlockEvent.BreakEvent e) {
        Apoth.Affixes.RADIAL.ifPresent(afx -> afx.onBreak(e));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void special(LivingSpawnEvent.SpecialSpawn e) {
        if (e.getSpawnReason() == MobSpawnType.NATURAL && e.getLevel().m_213780_().m_188501_() <= AdventureConfig.randomAffixItem && e.getEntity() instanceof Monster) {
            e.setCanceled(true);
            Player nearest = e.getEntity().f_19853_.m_45930_((Entity)e.getEntity(), 32.0);
            float luck = nearest != null ? nearest.m_36336_() : 0.0f;
            ItemStack affixItem = LootController.createRandomLootItem(e.getLevel().m_213780_(), null, luck, (ServerLevelAccessor)((ServerLevel)e.getEntity().f_19853_));
            if (affixItem.m_41619_()) {
                return;
            }
            affixItem.m_41784_().m_128379_("apoth_rspawn", true);
            LootCategory cat = LootCategory.forItem(affixItem);
            EquipmentSlot slot = cat.getSlots(affixItem)[0];
            e.getEntity().m_8061_(slot, affixItem);
            e.getEntity().m_21508_(slot);
        }
    }

    @SubscribeEvent
    public void gemSmashing(AnvilLandEvent e) {
        Level level = e.getLevel();
        BlockPos pos = e.getPos();
        List items = level.m_45976_(ItemEntity.class, new AABB(pos, pos.m_7918_(1, 1, 1)));
        for (ItemEntity ent : items) {
            ItemStack stack = ent.m_32055_();
            if (stack.m_41720_() != Apoth.Items.GEM.get()) continue;
            ent.m_32045_(new ItemStack((ItemLike)Apoth.Items.GEM_DUST.get(), stack.m_41613_()));
        }
    }
}

