/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells_x_origins;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.requirement.IRequirementType;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.registry.OriginsDynamicRegistries;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.ContainerLevelAccess;

public class LayerRequirement
extends Requirement {
    protected ResourceLocation layer;
    protected ResourceLocation origin;

    public LayerRequirement(IRequirementType<?> type) {
        super(type);
    }

    public LayerRequirement(IRequirementType<?> type, ResourceLocation layer, ResourceLocation origin) {
        super(type);
        this.layer = layer;
        this.origin = origin;
    }

    public boolean passes(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess containerLevelAccess) {
        AtomicBoolean ret = new AtomicBoolean(false);
        IOriginContainer.get((Entity)spellProgressionHolder.getPlayer()).ifPresent(container -> {
            ResourceKey originKey;
            ResourceKey layerKey = ResourceKey.m_135785_((ResourceKey)OriginsDynamicRegistries.LAYERS_REGISTRY, (ResourceLocation)this.layer);
            if (container.hasOrigin(layerKey) && (originKey = container.getOrigin(layerKey)) != null && originKey.m_135782_().equals((Object)this.origin)) {
                ret.set(true);
            }
        });
        return ret.get();
    }

    public MutableComponent makeDescription(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess containerLevelAccess) {
        return Component.m_237110_((String)this.getDescriptionId(), (Object[])new Object[]{Component.m_237115_((String)("layer." + this.origin.m_135827_() + "." + this.origin.m_135815_() + ".name")), Component.m_237115_((String)("origin." + this.origin.m_135827_() + "." + this.origin.m_135815_() + ".name"))});
    }

    public void writeToJson(JsonObject jsonObject) {
        jsonObject.addProperty("origin", this.origin.toString());
        jsonObject.addProperty("layer", this.layer.toString());
    }

    public void readFromJson(JsonObject jsonObject) {
        this.origin = new ResourceLocation(SpellsFileUtil.jsonString((JsonObject)jsonObject, (String)"origin"));
        this.layer = new ResourceLocation(SpellsFileUtil.jsonString((JsonObject)jsonObject, (String)"layer"));
    }

    public void writeToBuf(FriendlyByteBuf buf) {
        buf.m_130085_(this.origin);
        buf.m_130085_(this.layer);
    }

    public void readFromBuf(FriendlyByteBuf buf) {
        this.origin = buf.m_130281_();
        this.layer = buf.m_130281_();
    }
}

