/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ActorInstance;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.foundation.config.AllConfigs;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public interface MovementBehaviour {
    default public boolean isActive(MovementContext context) {
        return true;
    }

    default public void tick(MovementContext context) {
    }

    default public void startMoving(MovementContext context) {
    }

    default public void visitNewPosition(MovementContext context, BlockPos pos) {
    }

    default public Vec3 getActiveAreaOffset(MovementContext context) {
        return Vec3.f_82478_;
    }

    default public void dropItem(MovementContext context, ItemStack stack) {
        ItemStack remainder = (Boolean)AllConfigs.SERVER.kinetics.moveItemsToStorage.get() != false ? ItemHandlerHelper.insertItem((IItemHandler)context.contraption.getSharedInventory(), (ItemStack)stack, (boolean)false) : stack;
        if (remainder.m_41619_()) {
            return;
        }
        Vec3 vec = context.position;
        ItemEntity itemEntity = new ItemEntity(context.world, vec.f_82479_, vec.f_82480_, vec.f_82481_, remainder);
        itemEntity.m_20256_(context.motion.m_82520_(0.0, 0.5, 0.0).m_82490_((double)(context.world.f_46441_.m_188501_() * 0.3f)));
        context.world.m_7967_((Entity)itemEntity);
    }

    default public void onSpeedChanged(MovementContext context, Vec3 oldMotion, Vec3 motion) {
    }

    default public void stopMoving(MovementContext context) {
    }

    default public void cancelStall(MovementContext context) {
        context.stall = false;
    }

    default public void writeExtraData(MovementContext context) {
    }

    default public boolean renderAsNormalTileEntity() {
        return false;
    }

    default public boolean hasSpecialInstancedRendering() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    default public ActorInstance createInstance(MaterialManager materialManager, VirtualRenderWorld simulationWorld, MovementContext context) {
        return null;
    }
}

