/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.base;

import com.jozufozu.flywheel.backend.Backend;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.KineticDebugger;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.SuperByteBufferCache;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.commons.lang3.ArrayUtils;

public class KineticTileEntityRenderer
extends SafeTileEntityRenderer<KineticTileEntity> {
    public static final SuperByteBufferCache.Compartment<BlockState> KINETIC_TILE = new SuperByteBufferCache.Compartment();
    public static boolean rainbowMode = false;
    protected static final RenderType[] REVERSED_CHUNK_BUFFER_LAYERS = (RenderType[])RenderType.m_110506_().toArray(RenderType[]::new);

    public KineticTileEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)te.m_58904_())) {
            return;
        }
        BlockState state = this.getRenderedBlockState(te);
        RenderType type = this.getRenderType(te, state);
        if (type != null) {
            KineticTileEntityRenderer.renderRotatingBuffer(te, this.getRotatedModel(te, state), ms, buffer.m_6299_(type), light);
        }
    }

    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        return te.m_58900_();
    }

    protected RenderType getRenderType(KineticTileEntity te, BlockState state) {
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        ChunkRenderTypeSet typeSet = model.getRenderTypes(state, RandomSource.m_216335_((long)42L), ModelData.EMPTY);
        for (RenderType type : REVERSED_CHUNK_BUFFER_LAYERS) {
            if (!typeSet.contains(type)) continue;
            return type;
        }
        return null;
    }

    protected SuperByteBuffer getRotatedModel(KineticTileEntity te, BlockState state) {
        return CachedBufferer.block(KINETIC_TILE, state);
    }

    public static void renderRotatingKineticBlock(KineticTileEntity te, BlockState renderedState, PoseStack ms, VertexConsumer buffer, int light) {
        SuperByteBuffer superByteBuffer = CachedBufferer.block(KINETIC_TILE, renderedState);
        KineticTileEntityRenderer.renderRotatingBuffer(te, superByteBuffer, ms, buffer, light);
    }

    public static void renderRotatingBuffer(KineticTileEntity te, SuperByteBuffer superBuffer, PoseStack ms, VertexConsumer buffer, int light) {
        KineticTileEntityRenderer.standardKineticRotationTransform(superBuffer, te, light).renderInto(ms, buffer);
    }

    public static float getAngleForTe(KineticTileEntity te, BlockPos pos, Direction.Axis axis) {
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)te.m_58904_());
        float offset = KineticTileEntityRenderer.getRotationOffsetForPosition(te, pos, axis);
        float angle = (time * te.getSpeed() * 3.0f / 10.0f + offset) % 360.0f / 180.0f * (float)Math.PI;
        return angle;
    }

    public static SuperByteBuffer standardKineticRotationTransform(SuperByteBuffer buffer, KineticTileEntity te, int light) {
        BlockPos pos = te.m_58899_();
        Direction.Axis axis = ((IRotate)te.m_58900_().m_60734_()).getRotationAxis(te.m_58900_());
        return KineticTileEntityRenderer.kineticRotationTransform(buffer, te, axis, KineticTileEntityRenderer.getAngleForTe(te, pos, axis), light);
    }

    public static SuperByteBuffer kineticRotationTransform(SuperByteBuffer buffer, KineticTileEntity te, Direction.Axis axis, float angle, int light) {
        buffer.light(light);
        buffer.rotateCentered(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis), angle);
        if (KineticDebugger.isActive()) {
            rainbowMode = true;
            buffer.color(te.hasNetwork() ? Color.generateFromLong(te.network) : Color.WHITE);
        } else {
            float overStressedEffect = te.effects.overStressedEffect;
            if (overStressedEffect != 0.0f) {
                if (overStressedEffect > 0.0f) {
                    buffer.color(Color.WHITE.mixWith(Color.RED, overStressedEffect));
                } else {
                    buffer.color(Color.WHITE.mixWith(Color.SPRING_GREEN, -overStressedEffect));
                }
            } else {
                buffer.color(Color.WHITE);
            }
        }
        return buffer;
    }

    public static float getRotationOffsetForPosition(KineticTileEntity te, BlockPos pos, Direction.Axis axis) {
        float offset = ICogWheel.isLargeCog(te.m_58900_()) ? 11.25f : 0.0f;
        double d = ((axis == Direction.Axis.X ? 0 : pos.m_123341_()) + (axis == Direction.Axis.Y ? 0 : pos.m_123342_()) + (axis == Direction.Axis.Z ? 0 : pos.m_123343_())) % 2;
        if (d == 0.0) {
            offset = 22.5f;
        }
        return offset + (float)te.getRotationAngleOffset(axis);
    }

    public static BlockState shaft(Direction.Axis axis) {
        return (BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)axis);
    }

    public static Direction.Axis getRotationAxisOf(KineticTileEntity te) {
        return ((IRotate)te.m_58900_().m_60734_()).getRotationAxis(te.m_58900_());
    }

    static {
        ArrayUtils.reverse((Object[])REVERSED_CHUNK_BUFFER_LAYERS);
    }
}

