/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class PacketToggleArmorFeatureBulk {
    private final List<FeatureSetting> features;

    public PacketToggleArmorFeatureBulk(List<FeatureSetting> features) {
        this.features = features;
    }

    PacketToggleArmorFeatureBulk(FriendlyByteBuf buffer) {
        this.features = new ArrayList<FeatureSetting>();
        int len = buffer.m_130242_();
        for (int i = 0; i < len; ++i) {
            this.features.add(new FeatureSetting(buffer));
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130130_(this.features.size());
        this.features.forEach(f -> f.toBytes(buf));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer((Player)player);
                this.features.forEach(arg_0 -> PacketToggleArmorFeatureBulk.lambda$handle$1((Player)player, handler, arg_0));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$1(Player player, CommonArmorHandler handler, FeatureSetting f) {
        if (f.featureIndex >= 0 && f.featureIndex < ArmorUpgradeRegistry.getInstance().getHandlersForSlot(f.slot).size() && PneumaticArmorItem.isPneumaticArmorPiece(player, f.slot)) {
            handler.setUpgradeEnabled(f.slot, f.featureIndex, f.state);
        }
    }

    public static class FeatureSetting {
        private final EquipmentSlot slot;
        private final byte featureIndex;
        private final boolean state;

        FeatureSetting(FriendlyByteBuf buffer) {
            this(EquipmentSlot.values()[buffer.readByte()], buffer.readByte(), buffer.readBoolean());
        }

        public FeatureSetting(EquipmentSlot slot, byte featureIndex, boolean state) {
            this.slot = slot;
            this.featureIndex = featureIndex;
            this.state = state;
        }

        void toBytes(FriendlyByteBuf buffer) {
            buffer.writeByte(this.slot.ordinal());
            buffer.writeByte((int)this.featureIndex);
            buffer.writeBoolean(this.state);
        }
    }
}

