/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableEntity;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.hacking.HackManager;
import me.desht.pneumaticcraft.common.hacking.HackTickTracker;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class PacketHackingEntityFinish {
    private final int entityId;

    public PacketHackingEntityFinish(Entity entity) {
        this.entityId = entity.m_19879_();
    }

    public PacketHackingEntityFinish(FriendlyByteBuf buffer) {
        this.entityId = buffer.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            IHackableEntity<?> hackableEntity;
            Player player = ClientUtils.getClientPlayer();
            Entity entity = player.f_19853_.m_6815_(this.entityId);
            if (entity != null && (hackableEntity = HackManager.getHackableForEntity(entity, player)) != null) {
                hackableEntity._onHackFinished(entity, player);
                HackTickTracker.getInstance(entity.f_19853_).trackEntity(entity, hackableEntity);
                CommonArmorHandler.getHandlerForPlayer(player).getExtensionData(CommonUpgradeHandlers.hackHandler).setHackedEntity(null);
                player.m_5496_((SoundEvent)ModSounds.HELMET_HACK_FINISH.get(), 1.0f, 1.0f);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

