/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.GPSAreaToolScreen;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.item.IGPSToolSync;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.Validate;

public class GPSAreaToolItem
extends Item
implements IPositionProvider,
IGPSToolSync {
    public GPSAreaToolItem() {
        super(ModItems.defaultProps());
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        if (ctx.m_43723_() != null) {
            GPSAreaToolItem.setGPSPosAndNotify(ctx.m_43723_(), ctx.m_43724_(), ctx.m_8083_(), 0);
            ctx.m_43723_().m_5496_((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.5f);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (worldIn.f_46443_) {
            GPSAreaToolScreen.showGUI(stack, handIn, 0);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public static void setGPSPosAndNotify(Player player, ItemStack stack, BlockPos pos, int index) {
        GPSAreaToolItem.setGPSLocation(player, stack, pos, null, index, true);
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            player.m_5661_((Component)Component.m_237113_((String)(ChatFormatting.AQUA + String.format("[%s] ", stack.m_41611_().getString()))).m_7220_(GPSAreaToolItem.getMessageText(player.f_19853_, pos, index)), false);
            sp.f_8906_.m_9829_((Packet)new ClientboundSetCarriedItemPacket(player.m_150109_().f_35977_));
        }
    }

    public static void setGPSPosAndNotify(Player player, InteractionHand hand, BlockPos pos, int index) {
        GPSAreaToolItem.setGPSPosAndNotify(player, player.m_21120_(hand), pos, index);
    }

    private static Component getMessageText(Level worldIn, BlockPos pos, int index) {
        Component translated = PneumaticCraftUtils.getBlockNameAt(worldIn, pos);
        MutableComponent blockName = worldIn.m_46749_(pos) ? Component.m_237113_((String)" (").m_7220_(translated).m_130946_(")") : Component.m_237119_().m_6879_();
        String str = String.format("P%d%s: [%d, %d, %d]", index + 1, ChatFormatting.YELLOW, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        return Component.m_237113_((String)str).m_130940_(index == 0 ? ChatFormatting.RED : ChatFormatting.GREEN).m_7220_((Component)blockName.m_130940_(ChatFormatting.GREEN));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> infoList, TooltipFlag par4) {
        super.m_7373_(stack, worldIn, infoList, par4);
        if (worldIn != null) {
            ClientUtils.addGuiContextSensitiveTooltip(stack, infoList);
            int n = infoList.size();
            ProgWidgetArea area = GPSAreaToolItem.getArea(ClientUtils.getClientPlayer(), stack);
            for (int index = 0; index < 2; ++index) {
                int i = index;
                GPSAreaToolItem.getGPSLocation(ClientUtils.getClientPlayer(), stack, index).ifPresent(pos -> infoList.add(GPSAreaToolItem.getMessageText(worldIn, pos, i)));
                String varName = area.getVarName(index);
                if (varName.isEmpty()) continue;
                infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.gpsTool.variable", varName));
            }
            if (infoList.size() - n >= 2) {
                area.addAreaTypeTooltip(infoList);
            }
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean heldItem) {
        if (!world.f_46443_ && entity instanceof Player) {
            Player p = (Player)entity;
            ProgWidgetArea area = GPSAreaToolItem.getArea(p, stack);
            for (int index = 0; index < 2; ++index) {
                BlockPos pos;
                BlockPos curPos;
                String varName = area.getVarName(index);
                if (varName.isEmpty() || (curPos = area.getPos(index).orElse(PneumaticCraftUtils.invalidPos())).equals((Object)(pos = GlobalVariableHelper.getPos(entity.m_20148_(), varName, PneumaticCraftUtils.invalidPos())))) continue;
                GPSAreaToolItem.setGPSLocation(p, stack, pos, area, index, false);
            }
        }
    }

    @Nonnull
    public static ProgWidgetArea getArea(UUID playerId, ItemStack stack) {
        Validate.isTrue((boolean)(stack.m_41720_() instanceof GPSAreaToolItem));
        ProgWidgetArea area = new ProgWidgetArea();
        if (stack.m_41782_()) {
            area.setVariableProvider(GlobalVariableHelper.getVariableProvider(), playerId);
            area.readFromNBT(stack.m_41783_());
        }
        return area;
    }

    public static ProgWidgetArea getArea(Player player, ItemStack stack) {
        return GPSAreaToolItem.getArea(player.m_20148_(), stack);
    }

    public static Optional<BlockPos> getGPSLocation(Player player, ItemStack gpsTool, int index) {
        Validate.isTrue((index == 0 || index == 1 ? 1 : 0) != 0, (String)"index must be 0 or 1!", (Object[])new Object[0]);
        ProgWidgetArea area = GPSAreaToolItem.getArea(player, gpsTool);
        Optional<BlockPos> pos = area.getPos(index);
        String var = area.getVarName(index);
        if (!var.isEmpty() && !player.m_9236_().f_46443_) {
            BlockPos newPos = GlobalVariableHelper.getPos(player.m_20148_(), var);
            if (pos.isEmpty() || !pos.get().equals((Object)newPos)) {
                area.setPos(index, newPos);
                area.writeToNBT(gpsTool.m_41784_());
            }
            return Optional.of(newPos);
        }
        return pos;
    }

    private static void setGPSLocation(Player player, ItemStack gpsTool, BlockPos pos, ProgWidgetArea area, int index, boolean updateVar) {
        String varName;
        if (area == null) {
            area = GPSAreaToolItem.getArea(player, gpsTool);
        }
        area.setPos(index, pos);
        area.writeToNBT(gpsTool.m_41784_());
        if (updateVar && !(varName = area.getVarName(index)).isEmpty()) {
            GlobalVariableHelper.setPos(player.m_20148_(), varName, pos);
        }
    }

    public static void setVariable(Player player, ItemStack gpsTool, String variable, int index) {
        ProgWidgetArea area = GPSAreaToolItem.getArea(player, gpsTool);
        area.setVarName(index, variable);
        area.writeToNBT(gpsTool.m_41784_());
    }

    public static String getVariable(Player player, ItemStack gpsTool, int index) {
        return GPSAreaToolItem.getArea(player, gpsTool).getVarName(index);
    }

    @Override
    public void syncVariables(ServerPlayer player, ItemStack stack) {
        ProgWidgetArea area = GPSAreaToolItem.getArea((Player)player, stack);
        String v1 = area.getVarName(0);
        String v2 = area.getVarName(1);
        if (GlobalVariableHelper.hasPrefix(v1)) {
            PneumaticRegistry.getInstance().getMiscHelpers().syncGlobalVariable(player, v1);
        }
        if (GlobalVariableHelper.hasPrefix(v2)) {
            PneumaticRegistry.getInstance().getMiscHelpers().syncGlobalVariable(player, v2);
        }
    }

    @Override
    public List<BlockPos> getStoredPositions(UUID playerId, @Nonnull ItemStack stack) {
        HashSet<BlockPos> posSet = new HashSet<BlockPos>();
        GPSAreaToolItem.getArea(playerId, stack).getArea(posSet);
        return new ArrayList<BlockPos>(posSet);
    }

    @Override
    public List<BlockPos> getRawStoredPositions(Player player, ItemStack stack) {
        ProgWidgetArea area = GPSAreaToolItem.getArea(player, stack);
        return ImmutableList.of((Object)area.getPos(0).orElse(BlockPos.f_121853_), (Object)area.getPos(1).orElse(BlockPos.f_121853_));
    }

    @Override
    public int getRenderColor(int index) {
        return 0x60FFFF00;
    }

    @Override
    public boolean disableDepthTest() {
        return false;
    }

    @Override
    public void syncFromClient(Player player, ItemStack stack, int index, BlockPos pos, String varName) {
        GPSAreaToolItem.setVariable(player, stack, varName, index);
        GPSAreaToolItem.setGPSPosAndNotify(player, stack, pos, index);
        if (!varName.isEmpty()) {
            GlobalVariableHelper.setPos(player.m_20148_(), varName, pos);
        }
    }

    public static class EventHandler {
        @SubscribeEvent
        public static void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
            if (event.getItemStack().m_41720_() == ModItems.GPS_AREA_TOOL.get()) {
                Optional<BlockPos> optPos = GPSAreaToolItem.getGPSLocation(event.getEntity(), event.getItemStack(), 1);
                if (!event.getPos().equals(optPos.orElse(null))) {
                    event.getEntity().m_5496_((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.5f);
                    GPSAreaToolItem.setGPSPosAndNotify(event.getEntity(), event.getHand(), event.getPos(), 1);
                }
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onLeftClickAir(PlayerInteractEvent.LeftClickEmpty event) {
            if (event.getItemStack().m_41720_() == ModItems.GPS_AREA_TOOL.get()) {
                GPSAreaToolScreen.showGUI(event.getItemStack(), event.getHand(), 1);
            }
        }
    }
}

