/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.function.Predicate;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractChestUpgradeKitItem
extends Item {
    private final Supplier<? extends Block> chestBlock;
    private final Predicate<BlockState> blockPredicate;

    private AbstractChestUpgradeKitItem(Item.Properties properties, Supplier<? extends Block> chestBlock, Predicate<BlockState> blockPredicate) {
        super(properties);
        this.chestBlock = chestBlock;
        this.blockPredicate = blockPredicate;
    }

    protected void onUpgraded(BlockState oldState, UseOnContext context) {
        if (oldState.m_204336_(Tags.Blocks.CHESTS_WOODEN)) {
            PneumaticCraftUtils.dropItemOnGround(new ItemStack((ItemLike)oldState.m_60734_()), context.m_43725_(), context.m_8083_().m_121945_(context.m_43719_()));
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Level world = context.m_43725_();
        BlockState state = world.m_8055_(pos = context.m_8083_());
        if (this.blockPredicate.test(state)) {
            if (!world.f_46443_) {
                Direction facing = state.m_61138_((Property)HorizontalDirectionalBlock.f_54117_) ? (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) : Direction.NORTH;
                BlockEntity te = world.m_7702_(pos);
                NonNullList inv = NonNullList.m_122779_();
                if (te != null) {
                    te.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                        Pair<Integer, Integer> range = this.getInvRange(state, (IItemHandler)handler);
                        for (int i = ((Integer)range.getLeft()).intValue(); i < (Integer)range.getRight(); ++i) {
                            inv.add((Object)handler.extractItem(i, Integer.MAX_VALUE, false));
                        }
                    });
                }
                BlockState newState = this.chestBlock.get().m_49966_();
                world.m_46597_(pos, (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing));
                if (context.m_43723_() instanceof ServerPlayer) {
                    world.m_5594_(null, pos, SoundEvents.f_11669_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    world.m_5898_(context.m_43723_(), 2001, pos, Block.m_49956_((BlockState)newState));
                }
                PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, AbstractPneumaticCraftBlockEntity.class).ifPresent(teRC -> {
                    IItemHandler chestInv = teRC.getPrimaryInventory();
                    for (int i = 0; i < inv.size(); ++i) {
                        if (i < chestInv.getSlots()) {
                            chestInv.insertItem(i, (ItemStack)inv.get(i), false);
                            continue;
                        }
                        PneumaticCraftUtils.dropItemOnGround((ItemStack)inv.get(i), world, pos.m_121945_(context.m_43719_()));
                    }
                });
                this.onUpgraded(state, context);
                context.m_43722_().m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private Pair<Integer, Integer> getInvRange(BlockState state, IItemHandler handler) {
        if (state.m_60734_() == Blocks.f_50087_ && state.m_61138_((Property)ChestBlock.f_51479_)) {
            return switch ((ChestType)state.m_61143_((Property)ChestBlock.f_51479_)) {
                default -> throw new IncompatibleClassChangeError();
                case ChestType.RIGHT -> Pair.of((Object)0, (Object)(handler.getSlots() / 2));
                case ChestType.LEFT -> Pair.of((Object)(handler.getSlots() / 2), (Object)handler.getSlots());
                case ChestType.SINGLE -> Pair.of((Object)0, (Object)handler.getSlots());
            };
        }
        return Pair.of((Object)0, (Object)handler.getSlots());
    }

    public static class Smart
    extends AbstractChestUpgradeKitItem {
        public Smart() {
            super(ModItems.defaultProps(), (Supplier<? extends Block>)ModBlocks.SMART_CHEST, state -> state.m_204336_(Tags.Blocks.CHESTS_WOODEN) || state.m_60734_() == ModBlocks.REINFORCED_CHEST.get());
        }

        @Override
        protected void onUpgraded(BlockState oldState, UseOnContext context) {
            if (oldState.m_60734_() == ModBlocks.REINFORCED_CHEST.get()) {
                PneumaticCraftUtils.dropItemOnGround(new ItemStack((ItemLike)ModBlocks.REINFORCED_CHEST.get()), context.m_43725_(), context.m_8083_().m_121945_(context.m_43719_()));
            } else {
                super.onUpgraded(oldState, context);
            }
        }
    }

    public static class Reinforced
    extends AbstractChestUpgradeKitItem {
        public Reinforced() {
            super(ModItems.defaultProps(), (Supplier<? extends Block>)ModBlocks.REINFORCED_CHEST, state -> state.m_204336_(Tags.Blocks.CHESTS_WOODEN));
        }
    }
}

