/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spelltree;

import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.spell.ISpell;
import de.cas_ual_ty.spells.spell.base.SpellIcon;
import de.cas_ual_ty.spells.spelltree.SpellNode;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.ContainerLevelAccess;

public class SpellTree {
    public UUID id;
    public String filename;
    public SpellNode root;
    public Component title;
    public ISpell icon;
    public List<Requirement> treeRequirements;

    public SpellTree(UUID id, SpellNode root, Component title, ISpell icon) {
        this.id = id;
        this.root = root;
        this.title = title;
        this.icon = icon;
        this.treeRequirements = new LinkedList<Requirement>();
    }

    public SpellTree(UUID id, SpellNode root, Component title) {
        this(id, root, title, root.getSpell());
    }

    public SpellTree setFilename(String filename) {
        this.filename = filename;
        return this;
    }

    public SpellTree setRequirements(List<Requirement> requirements) {
        this.treeRequirements = requirements;
        return this;
    }

    public UUID getId() {
        return this.id;
    }

    public SpellNode getRoot() {
        return this.root;
    }

    public Component getTitle() {
        return this.title;
    }

    public List<Component> getTooltip(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        LinkedList<Component> tooltips = new LinkedList<Component>();
        tooltips.add(this.getTitle());
        this.treeRequirements.forEach((? super T requirement) -> tooltips.add((Component)requirement.makeDescription(spellProgressionHolder, access)));
        return tooltips;
    }

    public void setTitle(Component title) {
        this.title = title;
    }

    public ISpell getIconSpell() {
        return this.icon;
    }

    public SpellIcon getIcon() {
        return this.getIconSpell().getIcon();
    }

    public void setIcon(ISpell spell) {
        this.icon = spell;
    }

    public List<Requirement> getRequirements() {
        return this.treeRequirements;
    }

    public int getDepth(ISpell spell) {
        if (this.root == null) {
            return 0;
        }
        return this.find(1, this.root, spell);
    }

    public boolean passes(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        return this.treeRequirements.stream().allMatch(requirement -> requirement.passes(spellProgressionHolder, access));
    }

    public boolean canSee(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        return spellProgressionHolder.getPlayer().m_7500_() || this.passes(spellProgressionHolder, access);
    }

    private int find(int depth, SpellNode spellNode, ISpell spell) {
        if (spellNode.getSpell() == spell) {
            return depth;
        }
        ++depth;
        for (SpellNode child : spellNode.getChildren()) {
            int found = this.find(depth, child, spell);
            if (found == 0) continue;
            return found;
        }
        return 0;
    }

    public SpellTree assignNodeIds() {
        AtomicInteger i = new AtomicInteger(0);
        this.forEach(spellNode -> spellNode.setId(i.getAndIncrement()));
        return this;
    }

    public SpellNode findNode(int id) {
        Stack<SpellNode> stack = new Stack<SpellNode>();
        stack.push(this.root);
        while (!stack.isEmpty()) {
            SpellNode node = (SpellNode)stack.pop();
            if (node.getId() == id) {
                return node;
            }
            node.getChildren().forEach(stack::push);
        }
        return null;
    }

    public void forEach(Consumer<SpellNode> consumer) {
        if (this.root != null) {
            this.innerForEach(this.root, consumer);
        }
    }

    private void innerForEach(SpellNode spellNode, Consumer<SpellNode> consumer) {
        consumer.accept(spellNode);
        for (SpellNode child : spellNode.getChildren()) {
            this.innerForEach(child, consumer);
        }
    }

    public SpellTree copy() {
        return new SpellTree(this.id, this.innerDeepCopy(this.root), (Component)this.title.m_6881_(), this.icon).setFilename(this.filename).setRequirements(this.treeRequirements);
    }

    private SpellNode innerDeepCopy(SpellNode original) {
        SpellNode copy = original.copy();
        for (SpellNode child : original.getChildren()) {
            SpellTree.connect(copy, this.innerDeepCopy(child));
        }
        return copy;
    }

    public static void connect(SpellNode parent, SpellNode child) {
        parent.addChild(child);
        child.setParent(parent);
    }

    public static Builder builder(UUID id, Component treeTitle, Supplier<ISpell> root, int levelCost, Requirement ... requirements) {
        return new Builder(id, treeTitle, root, levelCost, requirements);
    }

    public static Builder builder(String filename, Component treeTitle, Supplier<ISpell> root, int levelCost, Requirement ... requirements) {
        return new Builder(filename, treeTitle, root, levelCost, requirements);
    }

    public static Builder builder(UUID id, Component treeTitle, ISpell root, int levelCost, Requirement ... requirements) {
        return new Builder(id, treeTitle, root, levelCost, requirements);
    }

    public static Builder builder(UUID id, Component treeTitle, SpellNode root) {
        return new Builder(id, treeTitle, root);
    }

    public static class Builder {
        private UUID id;
        private Component title;
        private Stack<SpellNode> stack;
        private SpellNode root;
        private ISpell icon;
        private String filename;
        private List<Requirement> treeRequirements;

        private Builder(UUID id, Component title, SpellNode root) {
            this.id = id;
            this.title = title;
            this.stack = new Stack();
            this.root = root;
            this.icon = null;
            this.stack.push(this.root);
            this.filename = null;
            this.treeRequirements = new LinkedList<Requirement>();
        }

        private Builder(String filename, Component title, SpellNode root) {
            this(SpellsUtil.generateUUIDForTree(filename), title, root);
            this.filename = filename;
        }

        private Builder(UUID id, Component title, ISpell root, int levelCost, Requirement ... requirements) {
            this(id, title, new SpellNode(root, levelCost, List.of(requirements)));
        }

        private Builder(String filename, Component title, ISpell root, int levelCost, Requirement ... requirements) {
            this(filename, title, new SpellNode(root, levelCost, List.of(requirements)));
        }

        public Builder(UUID id, Component title, Supplier<ISpell> root, int levelCost, Requirement ... requirements) {
            this(id, title, root.get(), levelCost, requirements);
        }

        public Builder(String filename, Component title, Supplier<ISpell> root, int levelCost, Requirement ... requirements) {
            this(filename, title, root.get(), levelCost, requirements);
        }

        public Builder requirement(Requirement requirement) {
            this.treeRequirements.add(requirement);
            return this;
        }

        public Builder add(Supplier<ISpell> spell, int levelCost, Requirement ... requirements) {
            return this.add(spell.get(), levelCost, requirements);
        }

        public Builder add(ISpell spell, int levelCost, Requirement ... requirements) {
            return this.add(new SpellNode(spell, levelCost, List.of(requirements)));
        }

        public Builder add(SpellNode spellNode) {
            SpellTree.connect(this.stack.peek(), spellNode);
            this.stack.push(spellNode);
            return this;
        }

        public Builder leaf() {
            this.stack.pop();
            return this;
        }

        public Builder icon(ISpell spell) {
            this.icon = spell;
            return this;
        }

        public SpellTree finish() {
            return new SpellTree(this.id, this.root, this.title, this.icon != null ? this.icon : this.root.getSpell()).setFilename(this.filename).setRequirements(this.treeRequirements);
        }
    }
}

