/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.impl;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.base.BaseIngredientsSpell;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TeleportSpell
extends BaseIngredientsSpell {
    public final int defaultTeleportRange;
    protected int teleportRange;

    public TeleportSpell(float manaCost, List<ItemStack> handIngredients, List<ItemStack> inventoryIngredients, int teleportRange) {
        super(manaCost, handIngredients, inventoryIngredients);
        this.defaultTeleportRange = teleportRange;
    }

    public TeleportSpell(float manaCost, ItemStack handIngredient, int teleportRange) {
        super(manaCost, handIngredient);
        this.defaultTeleportRange = teleportRange;
    }

    public TeleportSpell(float manaCost, int teleportRange) {
        super(manaCost);
        this.defaultTeleportRange = teleportRange;
    }

    public TeleportSpell() {
        this(10.0f, new ItemStack((ItemLike)Items.f_42730_), 32);
    }

    @Override
    public void perform(ManaHolder manaHolder) {
        Level level = manaHolder.getPlayer().f_19853_;
        LivingEntity entity = manaHolder.getPlayer();
        HitResult hit = SpellsUtil.rayTrace(level, (Entity)entity, this.teleportRange, e -> true, 0.5f, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY);
        Vec3 oldPos = entity.m_20182_();
        if (hit.m_6662_() != HitResult.Type.MISS) {
            Vec3 pos = null;
            if (hit.m_6662_() == HitResult.Type.BLOCK && hit instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)hit;
                pos = blockHit.m_82450_().m_82520_(0.0, 1.0E-5, 0.0);
            } else if (hit.m_6662_() == HitResult.Type.ENTITY && hit instanceof EntityHitResult) {
                EntityHitResult entityHit = (EntityHitResult)hit;
                pos = entityHit.m_82443_().m_20182_().m_82520_(0.0, 1.0E-5, 0.0);
            }
            if (pos != null) {
                level.m_6269_(null, (Entity)entity, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                entity.m_6021_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                level.m_6269_(null, (Entity)entity, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        } else {
            Vec3 dir = entity.m_20154_();
            Vec3 pos = entity.m_20182_().m_82549_(dir.m_82490_((double)this.teleportRange));
            level.m_6269_(null, (Entity)entity, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            entity.m_6021_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            level.m_6269_(null, (Entity)entity, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public JsonObject makeDefaultConfig() {
        JsonObject json = super.makeDefaultConfig();
        json.addProperty("teleportRange", (Number)this.defaultTeleportRange);
        return json;
    }

    @Override
    public void readFromConfig(JsonObject json) {
        super.readFromConfig(json);
        this.teleportRange = SpellsFileUtil.jsonInt(json, "teleportRange");
    }

    @Override
    public void applyDefaultConfig() {
        super.applyDefaultConfig();
        this.teleportRange = this.defaultTeleportRange;
    }
}

