/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.impl;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.base.HandIngredientSpell;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class SummonAnimalSpell
extends HandIngredientSpell {
    public final Map<Item, Ingredient> defaultIngredientMap;
    protected Map<Item, Ingredient> ingredientMap;

    public SummonAnimalSpell(float manaCost, Map<Item, Ingredient> ingredientMap) {
        super(manaCost);
        this.defaultIngredientMap = ImmutableMap.copyOf(ingredientMap);
        this.ingredientMap = new HashMap<Item, Ingredient>();
    }

    public SummonAnimalSpell() {
        super(18.0f);
        this.ingredientMap = new HashMap<Item, Ingredient>();
        this.addIngredient(Items.f_42579_, 8, EntityType.f_20557_);
        this.addIngredient(Items.f_42581_, 8, EntityType.f_20555_);
        this.addIngredient(Items.f_42658_, 8, EntityType.f_20520_);
        this.addIngredient(Items.f_42485_, 8, EntityType.f_20510_);
        this.defaultIngredientMap = ImmutableMap.copyOf(this.ingredientMap);
        this.ingredientMap.clear();
    }

    public void addIngredient(ItemStack ingredient, EntityType<?> entity) {
        this.ingredientMap.put(ingredient.m_41720_(), new Ingredient(ingredient, entity));
    }

    public void addIngredient(Item ingredient, int count, EntityType<?> entity) {
        this.ingredientMap.put(ingredient, new Ingredient(new ItemStack((ItemLike)ingredient, count), entity));
    }

    @Override
    public void perform(ManaHolder manaHolder, ItemStack itemStack) {
        Level level = manaHolder.getPlayer().f_19853_;
        Ingredient ingredient = this.ingredientMap.getOrDefault(itemStack.m_41720_(), null);
        if (ingredient == null || ingredient.entity() == null) {
            return;
        }
        EntityType<?> entityType = ingredient.entity();
        Entity entity = entityType.m_20615_(manaHolder.getPlayer().f_19853_);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Vec3 position = manaHolder.getPlayer().m_20182_();
            livingEntity.m_7678_(position.f_82479_, position.f_82480_, position.f_82481_, 0.0f, manaHolder.getPlayer().m_146908_() - 180.0f);
            if (livingEntity instanceof AgeableMob) {
                AgeableMob ageableMob = (AgeableMob)livingEntity;
                ageableMob.m_6863_(true);
            }
            level.m_7967_((Entity)livingEntity);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                RandomSource random = livingEntity.m_217043_();
                int count = 3;
                double spread = 0.4;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, position.f_82479_, position.f_82480_, position.f_82481_, 3, random.m_188583_() * 0.4, random.m_188583_() * 0.4, random.m_188583_() * 0.4, 0.0);
            }
        }
    }

    @Override
    public boolean checkHandIngredient(ManaHolder manaHolder, ItemStack itemStack) {
        return itemStack.m_41613_() >= this.getRequiredCount(itemStack) && this.ingredientMap.containsKey(itemStack.m_41720_());
    }

    @Override
    public boolean checkInventoryIngredient(ManaHolder manaHolder, ItemStack itemStack) {
        return false;
    }

    public int getRequiredCount(ItemStack itemStack) {
        return this.ingredientMap.get(itemStack.m_41720_()).count();
    }

    @Override
    public void consumeItemStack(ManaHolder manaHolder, ItemStack itemStack) {
        itemStack.m_41774_(this.ingredientMap.get(itemStack.m_41720_()).count());
    }

    @Override
    public JsonObject makeDefaultConfig() {
        JsonObject json = super.makeDefaultConfig();
        JsonArray ingredients = new JsonArray();
        this.defaultIngredientMap.forEach((item, ingredient) -> {
            JsonObject o = new JsonObject();
            SpellsFileUtil.jsonItemStack(o, ingredient.ingredient());
            o.addProperty("entity", ForgeRegistries.ENTITY_TYPES.getKey(ingredient.entity()).toString());
            ingredients.add((JsonElement)o);
        });
        json.add("ingredients", (JsonElement)ingredients);
        return json;
    }

    @Override
    public void readFromConfig(JsonObject json) {
        super.readFromConfig(json);
        JsonArray ingredients = SpellsFileUtil.jsonArray(json, "ingredients");
        for (JsonElement e : ingredients) {
            if (!e.isJsonObject()) {
                throw new IllegalStateException();
            }
            JsonObject ingredient = e.getAsJsonObject();
            ItemStack itemStack = SpellsFileUtil.jsonItemStack(ingredient);
            EntityType entity = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(SpellsFileUtil.jsonString(ingredient, "entity")));
            if (itemStack.m_41619_()) {
                throw new IllegalStateException();
            }
            if (entity == null) {
                throw new IllegalStateException(new NullPointerException());
            }
            this.addIngredient(itemStack, entity);
        }
    }

    @Override
    public void applyDefaultConfig() {
        super.applyDefaultConfig();
        this.ingredientMap.clear();
        this.ingredientMap.putAll(this.defaultIngredientMap);
    }

    private record Ingredient(ItemStack ingredient, EntityType<?> entity) {
        public Item item() {
            return this.ingredient().m_41720_();
        }

        public int count() {
            return this.ingredient().m_41613_();
        }
    }
}

