/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.base;

import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.base.AttributeSpell;
import de.cas_ual_ty.spells.spell.base.BaseIngredientsSpell;
import de.cas_ual_ty.spells.spell.base.PassiveSpell;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class TemporaryMobEffectSpell
extends BaseIngredientsSpell {
    public final MobEffect mobEffect;
    public final int duration;
    public final int amplifier;
    public final boolean ambient;
    public final boolean visible;
    public final boolean showIcon;

    public TemporaryMobEffectSpell(float manaCost, List<ItemStack> handIngredients, List<ItemStack> inventoryIngredients, MobEffect mobEffect, int duration, int amplifier, boolean ambient, boolean visible, boolean showIcon) {
        super(manaCost, handIngredients, inventoryIngredients);
        this.mobEffect = mobEffect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.ambient = ambient;
        this.visible = visible;
        this.showIcon = showIcon;
        ResourceLocation rl = ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect);
        this.setIcon(new ResourceLocation(rl.m_135827_(), "textures/mob_effect/" + rl.m_135815_() + ".png"));
    }

    public TemporaryMobEffectSpell(float manaCost, ItemStack handIngredient, MobEffect mobEffect, int duration, int amplifier, boolean ambient, boolean visible, boolean showIcon) {
        super(manaCost, handIngredient);
        this.mobEffect = mobEffect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.ambient = ambient;
        this.visible = visible;
        this.showIcon = showIcon;
        ResourceLocation rl = ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect);
        this.setIcon(new ResourceLocation(rl.m_135827_(), "textures/mob_effect/" + rl.m_135815_() + ".png"));
    }

    public TemporaryMobEffectSpell(float manaCost, MobEffect mobEffect, int duration, int amplifier, boolean ambient, boolean visible, boolean showIcon) {
        super(manaCost);
        this.mobEffect = mobEffect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.ambient = ambient;
        this.visible = visible;
        this.showIcon = showIcon;
        ResourceLocation rl = ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect);
        this.setIcon(new ResourceLocation(rl.m_135827_(), "textures/mob_effect/" + rl.m_135815_() + ".png"));
    }

    public TemporaryMobEffectSpell(float manaCost, ItemStack handIngredient, MobEffect mobEffect, int duration) {
        this(manaCost, handIngredient, mobEffect, duration, 0, false, true, true);
    }

    public TemporaryMobEffectSpell(float manaCost, ItemStack handIngredient, MobEffect mobEffect) {
        this(manaCost, handIngredient, mobEffect, 400);
    }

    public TemporaryMobEffectSpell(ItemStack handIngredient, MobEffect mobEffect) {
        this(5.0f, handIngredient, mobEffect, 400);
    }

    @Override
    public void perform(ManaHolder manaHolder) {
        manaHolder.getPlayer().m_7292_(new MobEffectInstance(this.mobEffect, this.duration, this.amplifier, this.ambient, this.visible, this.showIcon));
        manaHolder.getPlayer().f_19853_.m_6269_(null, (Entity)manaHolder.getPlayer(), SoundEvents.f_12436_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public MutableComponent getSpellName() {
        MutableComponent component = Component.m_237115_((String)this.mobEffect.m_19481_());
        if (this.amplifier > 0) {
            component = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{component, Component.m_237115_((String)("potion.potency." + this.amplifier))});
        }
        return Component.m_237110_((String)this.getNameKey(), (Object[])new Object[]{component});
    }

    @Override
    public MutableComponent getSpellDesc() {
        MutableComponent component = Component.m_237115_((String)this.mobEffect.m_19481_());
        if (this.amplifier > 0) {
            component = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{component, Component.m_237115_((String)("potion.potency." + this.amplifier))});
        }
        return Component.m_237110_((String)this.getDescKey(), (Object[])new Object[]{component.m_130940_(ChatFormatting.YELLOW)});
    }

    @Override
    public void addSpellDesc(List<Component> list) {
        super.addSpellDesc(list);
        Map map = this.mobEffect.m_19485_();
        if (!map.isEmpty()) {
            list.add((Component)Component.m_237119_());
            list.add((Component)PassiveSpell.whenAppliedComponent());
            for (Map.Entry entry : map.entrySet()) {
                Attribute attribute = (Attribute)entry.getKey();
                AttributeModifier attributeModifier = (AttributeModifier)entry.getValue();
                attributeModifier = new AttributeModifier(attributeModifier.m_22214_(), this.mobEffect.m_7048_(this.amplifier, attributeModifier), attributeModifier.m_22217_());
                AttributeSpell.addTooltip(list, attribute, attributeModifier);
            }
        }
    }
}

