/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.requirement;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.SpellsRegistries;
import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.requirement.IRequirementType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.ContainerLevelAccess;

public abstract class Requirement {
    public final IRequirementType<?> type;
    protected String descriptionId;

    public Requirement(IRequirementType<?> type) {
        this.type = type;
        ResourceLocation rl = SpellsRegistries.REQUIREMENTS_REGISTRY.get().getKey(type);
        this.descriptionId = "requirement." + rl.m_135827_() + "." + rl.m_135815_();
    }

    public IRequirementType<?> getType() {
        return this.type;
    }

    public abstract boolean passes(SpellProgressionHolder var1, ContainerLevelAccess var2);

    public void onSpellLearned(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
    }

    public abstract MutableComponent makeDescription(SpellProgressionHolder var1, ContainerLevelAccess var2);

    public String getDescriptionId() {
        return this.descriptionId;
    }

    public abstract void writeToJson(JsonObject var1);

    public abstract void readFromJson(JsonObject var1);

    public abstract void writeToBuf(FriendlyByteBuf var1);

    public abstract void readFromBuf(FriendlyByteBuf var1);
}

