/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.requirement;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.requirement.IRequirementType;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import net.minecraft.advancements.Advancement;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;

public class AdvancementRequirement
extends Requirement {
    public static final String ERROR_SUFFIX = ".error";
    protected ResourceLocation advancementRL;

    public AdvancementRequirement(IRequirementType<?> type) {
        super(type);
    }

    public AdvancementRequirement(IRequirementType<?> type, ResourceLocation advancementRL) {
        super(type);
        this.advancementRL = advancementRL;
    }

    @Override
    public boolean passes(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        Player player = spellProgressionHolder.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Advancement a = player2.f_8924_.m_129889_().m_136041_(this.advancementRL);
            if (a != null) {
                return player2.m_8960_().m_135996_(a).m_8193_();
            }
            return true;
        }
        return false;
    }

    @Override
    public MutableComponent makeDescription(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        Player player = spellProgressionHolder.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Advancement a = player2.f_8924_.m_129889_().m_136041_(this.advancementRL);
            if (a != null) {
                return Component.m_237110_((String)this.descriptionId, (Object[])new Object[]{a.m_138320_().m_14977_()});
            }
            return Component.m_237110_((String)(this.descriptionId + ERROR_SUFFIX), (Object[])new Object[]{this.advancementRL.toString()});
        }
        return Component.m_237119_();
    }

    @Override
    public void writeToJson(JsonObject json) {
        json.addProperty("advancement", this.advancementRL.toString());
    }

    @Override
    public void readFromJson(JsonObject json) {
        this.advancementRL = new ResourceLocation(SpellsFileUtil.jsonString(json, "advancement"));
    }

    @Override
    public void writeToBuf(FriendlyByteBuf buf) {
        buf.m_130085_(this.advancementRL);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf buf) {
        this.advancementRL = (ResourceLocation)buf.readRegistryId();
    }
}

