/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.custom.Candle;
import net.joefoxe.hexerei.client.renderer.entity.model.CandleModel;
import net.joefoxe.hexerei.data.candle.AbstractCandleEffect;
import net.joefoxe.hexerei.data.candle.CandleData;
import net.joefoxe.hexerei.data.candle.CandleEffects;
import net.joefoxe.hexerei.data.candle.PotionCandleEffect;
import net.joefoxe.hexerei.item.custom.CandleItem;
import net.joefoxe.hexerei.item.custom.CustomItemRenderer;
import net.joefoxe.hexerei.tileentity.CandleTile;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.data.ModelData;

public class CandleItemRenderer
extends CustomItemRenderer {
    CandleModel herbLayer;
    CandleModel glowLayer;
    CandleModel swirlLayer;
    CandleModel candleModel;
    CandleModel baseModel;

    @OnlyIn(value=Dist.CLIENT)
    public static CandleTile loadBlockEntityFromItem(CompoundTag tag, ItemStack stack) {
        BlockItem blockItem;
        Block block;
        Item item = stack.m_41720_();
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()) instanceof Candle) {
            Candle candle = (Candle)block;
            CandleTile te = (CandleTile)candle.m_142194_(BlockPos.f_121853_, block.m_49966_());
            te.setHeight(CandleItem.getHeight(stack));
            te.setDyeColor(CandleItemRenderer.getCustomColor(tag));
            String herbLayer = CandleItem.getHerbLayer(stack);
            String baseLayer = CandleItem.getBaseLayer(stack);
            String glowLayer = CandleItem.getGlowLayer(stack);
            String swirlLayer = CandleItem.getSwirlLayer(stack);
            String effectLocation = CandleItem.getEffectLocation(stack);
            List<ResourceLocation> effectParticle = CandleItem.getEffectParticle(stack);
            ((CandleData)te.candles.get((int)0)).herb.layer = herbLayer != null ? (herbLayer.equals("minecraft:missingno") ? null : new ResourceLocation(herbLayer)) : null;
            ((CandleData)te.candles.get((int)0)).base.layer = baseLayer != null ? (baseLayer.equals("minecraft:missingno") ? null : new ResourceLocation(baseLayer)) : null;
            ((CandleData)te.candles.get((int)0)).glow.layer = glowLayer != null ? (glowLayer.equals("minecraft:missingno") ? null : new ResourceLocation(glowLayer)) : null;
            ((CandleData)te.candles.get((int)0)).swirl.layer = swirlLayer != null ? (swirlLayer.equals("minecraft:missingno") ? null : new ResourceLocation(swirlLayer)) : null;
            if (effectLocation != null) {
                ((CandleData)te.candles.get(0)).setEffect(CandleEffects.getEffect(effectLocation).getCopy());
                ((CandleData)te.candles.get((int)0)).cooldown = 0;
            } else {
                ((CandleData)te.candles.get((int)0)).effect = new AbstractCandleEffect();
            }
            ((CandleData)te.candles.get((int)0)).effectParticle = effectParticle != null ? effectParticle : null;
            return te;
        }
        return null;
    }

    @Override
    public void renderByItem(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderTileStuff(stack.m_41782_() ? stack.m_41784_() : null, stack, transformType, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    public static int getCustomColor(CompoundTag tag) {
        if (tag != null && !tag.m_128456_()) {
            CompoundTag compoundtag = tag.m_128441_("display") ? tag.m_128469_("display") : null;
            return compoundtag != null && compoundtag.m_128425_("color", 99) ? compoundtag.m_128451_("color") : 13419416;
        }
        return 13419416;
    }

    private void renderItem(ItemStack stack, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.GUI, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, 1);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
        Minecraft.m_91087_().m_91289_().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.f_118083_, ModelData.EMPTY, null);
    }

    /*
     * Unable to fully structure code
     */
    public void renderTileStuff(CompoundTag tag, ItemStack stack, ItemTransforms.TransformType transformType, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        block17: {
            tileEntityIn = CandleItemRenderer.loadBlockEntityFromItem(tag, stack);
            if (tileEntityIn == null) {
                return;
            }
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.2, -0.1, -0.1);
            matrixStackIn.m_85837_(0.5, 1.75, 0.5);
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            candleData = (CandleData)tileEntityIn.candles.get(0);
            v0 = hasBase = candleData.base.layer != null;
            if (this.herbLayer == null) {
                this.herbLayer = new CandleModel<T>(Minecraft.m_91087_().m_167973_().m_171103_(CandleModel.CANDLE_HERB_LAYER));
            }
            if (this.glowLayer == null) {
                this.glowLayer = new CandleModel<T>(Minecraft.m_91087_().m_167973_().m_171103_(CandleModel.CANDLE_GLOW_LAYER));
            }
            if (this.swirlLayer == null) {
                this.swirlLayer = new CandleModel<T>(Minecraft.m_91087_().m_167973_().m_171103_(CandleModel.CANDLE_SWIRL_LAYER));
            }
            if (this.candleModel == null) {
                this.candleModel = new CandleModel<T>(Minecraft.m_91087_().m_167973_().m_171103_(CandleModel.CANDLE_LAYER));
            }
            if (this.baseModel == null) {
                this.baseModel = new CandleModel<T>(Minecraft.m_91087_().m_167973_().m_171103_(CandleModel.CANDLE_BASE_LAYER));
            }
            col = HexereiUtil.rgbIntToFloatArray(candleData.dyeColor);
            if (candleData.base.layer != null) {
                vertexConsumer2 = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)candleData.base.layer));
                this.baseModel.base.m_104306_(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                matrixStackIn.m_85837_(0.0, 0.0625, 0.0);
            }
            vertexConsumer = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)new ResourceLocation("hexerei", "textures/block/candle.png")));
            if (candleData.height != 0 && candleData.height <= 7) {
                this.candleModel.wax[candleData.height - 1].m_104306_(matrixStackIn, vertexConsumer, combinedLightIn, OverlayTexture.f_118083_, col[0], col[1], col[2], 1.0f);
            }
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.0, (double)((float)(7 - candleData.height) / 16.0f), 0.0);
            this.candleModel.wick.m_104306_(matrixStackIn, vertexConsumer, combinedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.m_85849_();
            if (candleData.herb.layer != null) {
                vertexConsumer2 = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)candleData.herb.layer));
                if (candleData.height != 0 && candleData.height <= 7) {
                    this.herbLayer.wax[candleData.height - 1].m_104306_(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.75f);
                }
            }
            if (candleData.glow.layer == null) break block17;
            vertexConsumer2 = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)candleData.glow.layer));
            var15_15 = candleData.effect;
            if (!(var15_15 instanceof PotionCandleEffect)) ** GOTO lbl-1000
            potionCandleEffect = (PotionCandleEffect)var15_15;
            if (potionCandleEffect.effect != null) {
                color = potionCandleEffect.effect.m_19484_();
                col2 = HexereiUtil.rgbIntToFloatArray(color);
                if (candleData.height != 0 && candleData.height <= 7) {
                    this.glowLayer.wax[candleData.height - 1].m_104306_(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.f_118083_, col2[0], col2[1], col2[2], 0.75f);
                }
            } else if (candleData.height != 0 && candleData.height <= 7) {
                this.glowLayer.wax[candleData.height - 1].m_104306_(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.75f);
            }
        }
        if (candleData.swirl.layer != null) {
            offset = Hexerei.getClientTicksWithoutPartial() + Minecraft.m_91087_().m_91296_();
            vertexConsumer2 = bufferIn.m_6299_(RenderType.m_110436_((ResourceLocation)candleData.swirl.layer, (float)(offset * 0.01f % 1.0f), (float)(offset * 0.01f % 1.0f)));
            if (candleData.height != 0 && candleData.height <= 7) {
                this.swirlLayer.wax[candleData.height - 1].m_104306_(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.f_118083_, col[0], col[1], col[2], 0.75f);
            }
        }
        matrixStackIn.m_85849_();
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.f_118083_, ModelData.EMPTY, color);
    }

    public void renderSingleBlock(BlockState p_110913_, PoseStack p_110914_, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.m_60799_();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                    BakedModel bakedmodel = dispatcher.m_110910_(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.m_110937_().renderModel(p_110914_.m_85850_(), p_110915_.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.m_60734_());
                    IClientItemExtensions.of((Item)stack.m_41720_()).getCustomRenderer().m_108829_(stack, ItemTransforms.TransformType.NONE, p_110914_, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

