/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import mezz.jei.api.gui.drawable.IDrawable;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.MixingCauldron;
import net.joefoxe.hexerei.data.recipes.FluidMixingRecipe;
import net.joefoxe.hexerei.data.recipes.MixingCauldronRecipe;
import net.joefoxe.hexerei.fluid.PotionMixingRecipes;
import net.joefoxe.hexerei.tileentity.renderer.MixingCauldronRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.Tags;

public class ExtraCauldronIcon
implements IDrawable {
    private Supplier<ItemStack> extraSupplier;
    private ItemStack extraStack;
    private boolean findNewRecipe;
    private Recipe<?> recipeShown;
    private String type;
    private boolean showOutputItemInstead;

    public ExtraCauldronIcon(Supplier<ItemStack> secondary) {
        this.extraSupplier = secondary;
        this.findNewRecipe = true;
        this.type = "Fluid";
        this.showOutputItemInstead = false;
    }

    public ExtraCauldronIcon(Supplier<ItemStack> secondary, boolean showOutputItemInstead) {
        this.extraSupplier = secondary;
        this.findNewRecipe = true;
        this.type = "Fluid";
        this.showOutputItemInstead = showOutputItemInstead;
    }

    public ExtraCauldronIcon(Supplier<ItemStack> secondary, String type, boolean showOutputItemInstead) {
        this.extraSupplier = secondary;
        this.findNewRecipe = true;
        this.type = type;
        this.showOutputItemInstead = showOutputItemInstead;
    }

    public ExtraCauldronIcon(Supplier<ItemStack> secondary, String type) {
        this.extraSupplier = secondary;
        this.findNewRecipe = true;
        this.type = type;
        this.showOutputItemInstead = false;
    }

    public int getWidth() {
        return 18;
    }

    public int getHeight() {
        return 18;
    }

    public void draw(PoseStack matrixStack, int xOffset, int yOffset) {
        float craftPercent;
        if (this.extraStack == null) {
            this.extraStack = this.extraSupplier.get();
        }
        if ((double)(craftPercent = Hexerei.getClientTicks() % 100.0f / 100.0f) <= 0.1 && this.findNewRecipe || this.recipeShown == null) {
            this.findNewRecipe = false;
            if (Minecraft.m_91087_().f_91073_ != null) {
                List list = this.type.equals("Fluid") ? Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((RecipeType)FluidMixingRecipe.Type.INSTANCE) : (this.type.equals("Potion") ? PotionMixingRecipes.ALL : Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((RecipeType)MixingCauldronRecipe.Type.INSTANCE));
                this.recipeShown = (Recipe)list.get(new Random().nextInt(list.size()));
            }
        }
        if ((double)craftPercent > 0.1) {
            this.findNewRecipe = true;
        }
        RenderSystem.m_69482_();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)xOffset, (double)yOffset, 0.0);
        matrixStack.m_166854_(Matrix4f.m_27632_((float)1.0f, (float)-1.0f, (float)1.0f));
        matrixStack.m_85836_();
        matrixStack.m_85837_(2.0, -13.0, 0.0);
        matrixStack.m_85841_(10.0f, 10.0f, 10.0f);
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 rotationOffset = new Vec3(0.0, 0.0, 0.0);
        float zRot = 0.0f;
        float xRot = 20.0f;
        float yRot = 30.0f;
        matrixStack.m_85837_(rotationOffset.f_82479_, rotationOffset.f_82480_, rotationOffset.f_82481_);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(zRot));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(xRot));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(yRot));
        matrixStack.m_85837_(-rotationOffset.f_82479_, -rotationOffset.f_82480_, -rotationOffset.f_82481_);
        BlockState blockState = (BlockState)((MixingCauldron)ModBlocks.MIXING_CAULDRON.get()).m_49966_().m_61124_((Property)MixingCauldron.GUI_RENDER, (Comparable)Boolean.valueOf(true));
        BlockRenderDispatcher rendererer = Minecraft.m_91087_().m_91289_();
        rendererer.m_110910_(blockState);
        BakedModel bakedModel = rendererer.m_110910_(blockState);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderBlock(matrixStack, (MultiBufferSource)buffer, 0xF000F0, blockState, -12566464);
        if (this.recipeShown instanceof FluidMixingRecipe || this.recipeShown instanceof MixingCauldronRecipe) {
            Object recipe;
            float fillPercentage = 1.0f;
            Recipe<?> recipe2 = this.recipeShown;
            if (recipe2 instanceof FluidMixingRecipe) {
                recipe = (FluidMixingRecipe)recipe2;
                if (((FluidMixingRecipe)recipe).getLiquid().getFluid().m_205067_(Tags.Fluids.GASEOUS)) {
                    MixingCauldronRenderer.renderFluidGUI(matrixStack, (MultiBufferSource)buffer, ((FluidMixingRecipe)recipe).getLiquid(), fillPercentage, 1.0f, OverlayTexture.f_118083_);
                } else {
                    MixingCauldronRenderer.renderFluidGUI(matrixStack, (MultiBufferSource)buffer, ((FluidMixingRecipe)recipe).getLiquid(), 1.0f, fillPercentage, OverlayTexture.f_118083_);
                }
            }
            if ((recipe2 = this.recipeShown) instanceof MixingCauldronRecipe) {
                recipe = (MixingCauldronRecipe)recipe2;
                if (((MixingCauldronRecipe)recipe).getLiquid().getFluid().m_205067_(Tags.Fluids.GASEOUS)) {
                    MixingCauldronRenderer.renderFluidGUI(matrixStack, (MultiBufferSource)buffer, ((MixingCauldronRecipe)recipe).getLiquid(), fillPercentage, 1.0f, OverlayTexture.f_118083_);
                } else {
                    MixingCauldronRenderer.renderFluidGUI(matrixStack, (MultiBufferSource)buffer, ((MixingCauldronRecipe)recipe).getLiquid(), 1.0f, fillPercentage, OverlayTexture.f_118083_);
                }
            }
            float height = 0.25f + 0.6875f * fillPercentage;
            Lighting.m_84931_();
            for (int i = 0; i < this.recipeShown.m_7527_().size(); ++i) {
                ItemStack[] items = ((Ingredient)this.recipeShown.m_7527_().get(i)).m_43908_();
                if (items.length <= 0) continue;
                matrixStack.m_85836_();
                matrixStack.m_85837_(0.5, (double)(height + 0.00390625f), 0.5);
                double itemRotationOffset = 0.8 * (double)i + (double)(craftPercent * (20.0f * craftPercent));
                matrixStack.m_85837_(0.0 + Math.sin(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f), Math.sin(Math.PI * (double)Hexerei.getClientTicks() / 30.0 + (double)(i * 20)) / 10.0 * 0.2, 0.0 + Math.cos(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f));
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_((float)((double)((float)(45 * i) - 1.0f) + 2.0 * Math.sin((Hexerei.getClientTicks() + (float)(i * 20)) / 40.0f))));
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_((float)(82.5 + 5.0 * Math.cos((Hexerei.getClientTicks() + (float)(i * 22)) / 40.0f))));
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_((float)(-2.5 + 5.0 * Math.cos((Hexerei.getClientTicks() + (float)(i * 24)) / 40.0f))));
                matrixStack.m_85841_(1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f);
                matrixStack.m_85841_(0.4f, 0.4f, 0.4f);
                this.renderItemFixed(items[(int)Hexerei.getClientTicksWithoutPartial() / 40 % items.length], matrixStack, (MultiBufferSource)buffer, 0xF000F0);
                matrixStack.m_85849_();
            }
        }
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(14.0, -14.0, 100.0);
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        matrixStack.m_85841_(16.0f, 16.0f, 16.0f);
        matrixStack.m_85850_().m_85864_().m_8171_(Vector3f.f_122225_.m_122240_(-45.0f));
        if (!this.extraStack.m_41619_() || this.showOutputItemInstead) {
            if (!this.showOutputItemInstead) {
                this.renderItem(this.extraStack, matrixStack, (MultiBufferSource)buffer, 0xF000F0);
            } else {
                this.renderItem(this.recipeShown.m_8043_(), matrixStack, (MultiBufferSource)buffer, 0xF000F0);
            }
        }
        matrixStack.m_85849_();
        matrixStack.m_85849_();
        buffer.m_109911_();
        RenderSystem.m_69482_();
        Lighting.m_84931_();
    }

    private void renderItem(ItemStack stack, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.GUI, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, 1);
    }

    private void renderItemFixed(ItemStack stack, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderBlock(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStack, bufferIn, combinedLightIn, OverlayTexture.f_118083_, ModelData.EMPTY, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderSingleBlock(BlockState p_110913_, PoseStack poseStack, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.m_60799_();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                    BakedModel bakedmodel = dispatcher.m_110910_(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.m_110937_().renderModel(poseStack.m_85850_(), p_110915_.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.m_60734_());
                    poseStack.m_85837_(0.2, -0.1, -0.1);
                    IClientItemExtensions.of((Item)stack.m_41720_()).getCustomRenderer().m_108829_(stack, ItemTransforms.TransformType.NONE, poseStack, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

