/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.candle;

import java.util.ArrayList;
import java.util.List;
import net.joefoxe.hexerei.data.candle.AbstractCandleEffect;
import net.joefoxe.hexerei.data.candle.CandleEffects;
import net.joefoxe.hexerei.data.candle.CandleLayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CandleData {
    public boolean returnToBlock;
    public boolean hasCandle;
    public float x;
    public float y;
    public float z;
    public int height;
    public boolean lit;
    public int meltTimer;
    public static int meltTimerMAX = 6000;
    public int dyeColor;
    public int cooldown;
    public CandleLayer base;
    public CandleLayer herb;
    public CandleLayer glow;
    public CandleLayer swirl;
    public AbstractCandleEffect effect;
    public ArrayList<AbstractCandleEffect> effects;
    public Component customName;
    public List<ResourceLocation> effectParticle;

    public CandleData(int dyeColor, boolean returnToBlock, float x, float y, float z, int height, int meltTimer, AbstractCandleEffect effect) {
        this.dyeColor = dyeColor;
        this.returnToBlock = returnToBlock;
        this.x = x;
        this.y = y;
        this.z = z;
        this.height = height;
        this.meltTimer = meltTimer;
        this.effect = effect;
        this.effects = new ArrayList();
        this.effects.add(effect);
        this.effectParticle = null;
        this.cooldown = 0;
        this.base = new CandleLayer(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, null, false);
        this.herb = new CandleLayer(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, null, false);
        this.glow = new CandleLayer(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, null, false);
        this.swirl = new CandleLayer(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, null, false);
    }

    public boolean hasBase() {
        return this.base.layer != null;
    }

    public void setEffect(AbstractCandleEffect effect) {
        this.effect = effect;
    }

    public AbstractCandleEffect getEffect() {
        return this.effect;
    }

    public ArrayList<AbstractCandleEffect> getEffects() {
        return this.effects;
    }

    public CompoundTag save() {
        CompoundTag ct;
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("dyeColor", this.dyeColor);
        tag.m_128405_("height", this.height);
        tag.m_128405_("meltTimer", this.meltTimer);
        tag.m_128379_("hasCandle", this.hasCandle);
        tag.m_128379_("lit", this.lit);
        tag.m_128379_("returnToBlock", this.returnToBlock);
        tag.m_128350_("x", this.x);
        tag.m_128350_("y", this.y);
        tag.m_128350_("z", this.z);
        tag.m_128359_("effect", this.effect.getLocationName());
        tag.m_128405_("cooldown", this.cooldown);
        if (this.effectParticle != null) {
            CompoundTag compoundTag = new CompoundTag();
            for (int i = 0; i < this.effectParticle.size(); ++i) {
                compoundTag.m_128359_("particle" + i, this.effectParticle.get(i).toString());
                tag.m_128365_("effectParticle", (Tag)compoundTag);
            }
        }
        if (this.base.layer != null) {
            ct = new CompoundTag();
            ct.m_128350_("meltingSpeedMultiplier", this.base.meltingSpeedMultiplier);
            ct.m_128350_("radiusMultiplier", this.base.radiusMultiplier);
            ct.m_128350_("effectAmplifierMultiplier", this.base.effectAmplifierMultiplier);
            ct.m_128350_("effectCooldownMultiplier", this.base.effectCooldownMultiplier);
            ct.m_128350_("effectDurationMultiplier", this.base.effectDurationMultiplier);
            ct.m_128379_("layerFromBlockLocation", this.base.layerFromBlockLocation);
            ct.m_128359_("layer", this.base.layer.toString());
            tag.m_128365_("base", (Tag)ct);
        }
        if (this.herb.layer != null) {
            ct = new CompoundTag();
            ct.m_128350_("meltingSpeedMultiplier", this.herb.meltingSpeedMultiplier);
            ct.m_128350_("radiusMultiplier", this.herb.radiusMultiplier);
            ct.m_128350_("effectAmplifierMultiplier", this.herb.effectAmplifierMultiplier);
            ct.m_128350_("effectCooldownMultiplier", this.herb.effectCooldownMultiplier);
            ct.m_128350_("effectDurationMultiplier", this.herb.effectDurationMultiplier);
            ct.m_128379_("layerFromBlockLocation", this.herb.layerFromBlockLocation);
            ct.m_128359_("layer", this.herb.layer.toString());
            tag.m_128365_("herb", (Tag)ct);
        }
        if (this.glow.layer != null) {
            ct = new CompoundTag();
            ct.m_128350_("meltingSpeedMultiplier", this.glow.meltingSpeedMultiplier);
            ct.m_128350_("radiusMultiplier", this.glow.radiusMultiplier);
            ct.m_128350_("effectAmplifierMultiplier", this.glow.effectAmplifierMultiplier);
            ct.m_128350_("effectCooldownMultiplier", this.glow.effectCooldownMultiplier);
            ct.m_128350_("effectDurationMultiplier", this.glow.effectDurationMultiplier);
            ct.m_128379_("layerFromBlockLocation", this.glow.layerFromBlockLocation);
            ct.m_128359_("layer", this.glow.layer.toString());
            tag.m_128365_("glow", (Tag)ct);
        }
        if (this.swirl.layer != null) {
            ct = new CompoundTag();
            ct.m_128350_("meltingSpeedMultiplier", this.swirl.meltingSpeedMultiplier);
            ct.m_128350_("radiusMultiplier", this.swirl.radiusMultiplier);
            ct.m_128350_("effectAmplifierMultiplier", this.swirl.effectAmplifierMultiplier);
            ct.m_128350_("effectCooldownMultiplier", this.swirl.effectCooldownMultiplier);
            ct.m_128350_("effectDurationMultiplier", this.swirl.effectDurationMultiplier);
            ct.m_128379_("layerFromBlockLocation", this.swirl.layerFromBlockLocation);
            ct.m_128359_("layer", this.swirl.layer.toString());
            tag.m_128365_("swirl", (Tag)ct);
        }
        if (this.customName != null) {
            tag.m_128359_("customName", Component.Serializer.m_130703_((Component)this.customName));
        }
        return tag;
    }

    public void load(CompoundTag tag) {
        CompoundTag ct;
        this.dyeColor = tag.m_128451_("dyeColor");
        this.height = tag.m_128451_("height");
        this.meltTimer = tag.m_128451_("meltTimer");
        this.hasCandle = tag.m_128471_("hasCandle");
        this.lit = tag.m_128471_("lit");
        this.returnToBlock = tag.m_128471_("returnToBlock");
        this.x = tag.m_128457_("x");
        this.y = tag.m_128457_("y");
        this.z = tag.m_128457_("z");
        if (tag.m_128441_("effect")) {
            this.setEffect(CandleEffects.getEffect(tag.m_128461_("effect")));
            this.cooldown = tag.m_128451_("cooldown");
        }
        if (tag.m_128441_("effectParticle")) {
            this.effectParticle = new ArrayList<ResourceLocation>();
            CompoundTag compoundTag = tag.m_128469_("effectParticle");
            for (int i = 0; i < compoundTag.m_128440_(); ++i) {
                this.effectParticle.add(new ResourceLocation(compoundTag.m_128461_("particle" + i)));
            }
        }
        if (tag.m_128441_("base")) {
            ct = tag.m_128469_("base");
            this.base = new CandleLayer(ct.m_128457_("meltingSpeedMultiplier"), ct.m_128457_("radiusMultiplier"), ct.m_128457_("effectAmplifierMultiplier"), ct.m_128457_("effectCooldownMultiplier"), ct.m_128457_("effectDurationMultiplier"), new ResourceLocation(ct.m_128461_("layer")), ct.m_128471_("layerFromBlockLocation"));
        }
        if (tag.m_128441_("herb")) {
            ct = tag.m_128469_("herb");
            this.herb = new CandleLayer(ct.m_128457_("meltingSpeedMultiplier"), ct.m_128457_("radiusMultiplier"), ct.m_128457_("effectAmplifierMultiplier"), ct.m_128457_("effectCooldownMultiplier"), ct.m_128457_("effectDurationMultiplier"), new ResourceLocation(ct.m_128461_("layer")), ct.m_128471_("layerFromBlockLocation"));
        }
        if (tag.m_128441_("glow")) {
            ct = tag.m_128469_("glow");
            this.glow = new CandleLayer(ct.m_128457_("meltingSpeedMultiplier"), ct.m_128457_("radiusMultiplier"), ct.m_128457_("effectAmplifierMultiplier"), ct.m_128457_("effectCooldownMultiplier"), ct.m_128457_("effectDurationMultiplier"), new ResourceLocation(ct.m_128461_("layer")), ct.m_128471_("layerFromBlockLocation"));
        }
        if (tag.m_128441_("swirl")) {
            ct = tag.m_128469_("swirl");
            this.swirl = new CandleLayer(ct.m_128457_("meltingSpeedMultiplier"), ct.m_128457_("radiusMultiplier"), ct.m_128457_("effectAmplifierMultiplier"), ct.m_128457_("effectCooldownMultiplier"), ct.m_128457_("effectDurationMultiplier"), new ResourceLocation(ct.m_128461_("layer")), ct.m_128471_("layerFromBlockLocation"));
        }
        if (tag.m_128441_("customName")) {
            this.customName = Component.Serializer.m_130701_((String)tag.m_128461_("customName"));
        }
    }
}

