/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class ArmorModel<T extends LivingEntity>
extends HumanoidModel<T>
implements IClientItemExtensions {
    public EquipmentSlot slot;
    public LivingEntity entity;
    public Class entityClass;
    ModelPart root;
    ModelPart modelHead;
    ModelPart modelBody;
    ModelPart modelLeft_arm;
    ModelPart modelRight_arm;
    ModelPart modelBelt;
    ModelPart modelLeft_leg;
    ModelPart modelRight_leg;
    ModelPart modelLeft_foot;
    ModelPart modelRight_foot;

    public ArmorModel(ModelPart root) {
        super(root);
        this.root = root;
        this.modelBelt = root.m_171324_("Belt");
        this.modelBody = root.m_171324_("Body");
        this.modelRight_foot = root.m_171324_("RightBoot");
        this.modelLeft_foot = root.m_171324_("LeftBoot");
        this.modelLeft_arm = root.m_171324_("LeftArm");
        this.modelRight_arm = root.m_171324_("RightArm");
        this.modelRight_leg = root.m_171324_("LeftLeg");
        this.modelLeft_leg = root.m_171324_("RightLeg");
        this.modelHead = root.m_171324_("Head");
    }

    public static PartDefinition createHumanoidAlias(MeshDefinition mesh) {
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("Body", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("Belt", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("Head", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("LeftLeg", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("LeftBoot", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("RightLeg", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("RightBoot", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("LeftArm", new CubeListBuilder(), PartPose.f_171404_);
        root.m_171599_("RightArm", new CubeListBuilder(), PartPose.f_171404_);
        return root;
    }

    protected Iterable<ModelPart> m_5607_() {
        return this.slot == EquipmentSlot.HEAD ? ImmutableList.of((Object)this.modelHead) : ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        if (this.slot == EquipmentSlot.CHEST) {
            return ImmutableList.of((Object)this.modelBody, (Object)this.modelLeft_arm, (Object)this.modelRight_arm);
        }
        if (this.slot == EquipmentSlot.LEGS) {
            return ImmutableList.of((Object)this.modelLeft_leg, (Object)this.modelRight_leg, (Object)this.modelBelt);
        }
        if (this.slot == EquipmentSlot.FEET) {
            return ImmutableList.of((Object)this.modelLeft_foot, (Object)this.modelRight_foot);
        }
        return ImmutableList.of();
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        EntityModel entityModel;
        matrixStack.m_85836_();
        if (this.entity != null && (entityModel = ((LivingEntityRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)this.entity)).m_7200_()) instanceof HumanoidModel) {
            HumanoidModel livingModel = (HumanoidModel)entityModel;
            this.f_102608_ = livingModel.f_102608_;
            this.f_102609_ = livingModel.f_102609_;
            this.f_102610_ = livingModel.f_102610_;
            this.f_102815_ = livingModel.f_102815_;
            this.f_102816_ = livingModel.f_102816_;
            this.f_102817_ = livingModel.f_102817_;
            this.f_102808_.m_104315_(livingModel.f_102808_);
            this.f_102810_.m_104315_(livingModel.f_102810_);
            this.f_102811_.m_104315_(livingModel.f_102811_);
            this.f_102812_.m_104315_(livingModel.f_102812_);
            this.f_102813_.m_104315_(livingModel.f_102813_);
            this.f_102814_.m_104315_(livingModel.f_102814_);
        }
        if (this.slot == EquipmentSlot.HEAD) {
            this.modelHead.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        } else if (this.slot == EquipmentSlot.CHEST) {
            this.modelBody.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.modelRight_arm.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.modelLeft_arm.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        } else if (this.slot == EquipmentSlot.LEGS) {
            this.modelBelt.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.modelRight_leg.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.modelLeft_leg.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        } else if (this.slot == EquipmentSlot.FEET) {
            this.modelRight_foot.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.modelLeft_foot.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        matrixStack.m_85849_();
    }

    public void copyFromDefault(HumanoidModel model) {
        this.modelBody.m_104315_(model.f_102810_);
        this.modelBelt.m_104315_(model.f_102810_);
        this.modelHead.m_104315_(model.f_102808_);
        this.modelLeft_arm.m_104315_(model.f_102812_);
        this.modelRight_arm.m_104315_(model.f_102811_);
        this.modelLeft_leg.m_104315_(this.f_102814_);
        this.modelRight_leg.m_104315_(this.f_102813_);
        this.modelLeft_foot.m_104315_(this.f_102814_);
        this.modelRight_foot.m_104315_(this.f_102813_);
        this.f_102609_ = model.f_102609_;
        this.f_102815_ = model.f_102815_;
        this.f_102816_ = model.f_102816_;
        this.f_102608_ = model.f_102608_;
    }
}

