/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.caffeineconfig;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.caffeinemc.caffeineconfig.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CaffeineConfig {
    private final Map<String, Option> options = new HashMap<String, Option>();
    private final Set<Option> optionsWithDependencies = new ObjectLinkedOpenHashSet();
    private final String modName;
    private Logger logger;

    private CaffeineConfig(String modName) {
        this.modName = modName;
    }

    public static Builder builder(String modName) {
        CaffeineConfig config = new CaffeineConfig(modName);
        config.logger = LoggerFactory.getLogger((String)(modName + " Config"));
        String jsonKey = modName.toLowerCase() + ":options";
        return config.new Builder().withSettingsKey(jsonKey);
    }

    public String getModName() {
        return this.modName;
    }

    public Logger getLogger() {
        return this.logger;
    }

    private void addOptionDependency(String optionName, String dependency, boolean requiredValue) {
        String mixinOptionName = CaffeineConfig.getMixinOptionName(optionName);
        Option option = this.options.get(mixinOptionName);
        if (option == null) {
            throw new IllegalArgumentException(String.format("Option %s for dependency '%s depends on %s=%s' not found", optionName, optionName, dependency, requiredValue));
        }
        String dependencyOptionName = CaffeineConfig.getMixinOptionName(dependency);
        Option dependencyOption = this.options.get(dependencyOptionName);
        if (dependencyOption == null) {
            throw new IllegalArgumentException(String.format("Option %s for dependency '%s depends on %s=%s' not found", dependency, optionName, dependency, requiredValue));
        }
        option.addDependency(dependencyOption, requiredValue);
        this.optionsWithDependencies.add(option);
    }

    private void addMixinOption(String mixin, boolean enabled) {
        String name = CaffeineConfig.getMixinOptionName(mixin);
        if (this.options.putIfAbsent(name, new Option(name, enabled, false)) != null) {
            throw new IllegalStateException("Mixin option already defined: " + mixin);
        }
    }

    private void readProperties(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            boolean enabled;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Option option = this.options.get(key);
            if (option == null) {
                this.logger.warn("No configuration key exists with name '{}', ignoring", (Object)key);
                continue;
            }
            if (value.equalsIgnoreCase("true")) {
                enabled = true;
            } else if (value.equalsIgnoreCase("false")) {
                enabled = false;
            } else {
                this.logger.warn("Invalid value '{}' encountered for configuration key '{}', ignoring", (Object)value, (Object)key);
                continue;
            }
            option.setEnabled(enabled, true);
        }
    }

    public Option getEffectiveOptionForMixin(String mixinClassName) {
        int nextSplit;
        int lastSplit = 0;
        Option option = null;
        while ((nextSplit = mixinClassName.indexOf(46, lastSplit)) != -1) {
            String key = CaffeineConfig.getMixinOptionName(mixinClassName.substring(0, nextSplit));
            Option candidate = this.options.get(key);
            if (candidate != null && !(option = candidate).isEnabled()) {
                return option;
            }
            lastSplit = nextSplit + 1;
        }
        return option;
    }

    private boolean applyDependencies() {
        boolean changed = false;
        for (Option optionWithDependency : this.optionsWithDependencies) {
            changed |= optionWithDependency.disableIfDependenciesNotMet(this.logger);
        }
        return changed;
    }

    private static void writeDefaultConfig(Path file, String modName, String infoUrl) throws IOException {
        Path dir = file.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException("The parent file is not a directory");
        }
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            writer.write(String.format("# This is the configuration file for %s.\n", modName));
            writer.write("# This file exists for debugging purposes and should not be configured otherwise.\n");
            writer.write("#\n");
            if (infoUrl != null) {
                writer.write("# You can find information on editing this file and all the available options here:\n");
                writer.write("# " + infoUrl + "\n");
                writer.write("#\n");
            }
            writer.write("# By default, this file will be empty except for this notice.\n");
        }
    }

    private static String getMixinOptionName(String name) {
        return "mixin." + name;
    }

    public int getOptionCount() {
        return this.options.size();
    }

    public int getOptionOverrideCount() {
        return (int)this.options.values().stream().filter(Option::isOverridden).count();
    }

    public final class Builder {
        private boolean alreadyBuilt = false;
        private String infoUrl;
        private String jsonKey;

        private Builder() {
        }

        public Builder addMixinOption(String mixin, boolean enabled) {
            CaffeineConfig.this.addMixinOption(mixin, enabled);
            return this;
        }

        public Builder addOptionDependency(String option, String dependency, boolean requiredValue) {
            CaffeineConfig.this.addOptionDependency(option, dependency, requiredValue);
            return this;
        }

        public Builder withLogger(Logger logger) {
            CaffeineConfig.this.logger = logger;
            return this;
        }

        public Builder withSettingsKey(String key) {
            this.jsonKey = key;
            return this;
        }

        public Builder withInfoUrl(String url) {
            this.infoUrl = url;
            return this;
        }

        public CaffeineConfig build(Path path) {
            if (this.alreadyBuilt) {
                throw new IllegalStateException("Cannot build a CaffeineConfig twice from the same builder");
            }
            if (Files.exists(path, new LinkOption[0])) {
                Properties props = new Properties();
                try (InputStream fin = Files.newInputStream(path, new OpenOption[0]);){
                    props.load(fin);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not load config file", e);
                }
                CaffeineConfig.this.readProperties(props);
            } else {
                try {
                    CaffeineConfig.writeDefaultConfig(path, CaffeineConfig.this.modName, this.infoUrl);
                }
                catch (IOException e) {
                    CaffeineConfig.this.logger.warn("Could not write default configuration file", (Throwable)e);
                }
            }
            while (CaffeineConfig.this.applyDependencies()) {
            }
            this.alreadyBuilt = true;
            return CaffeineConfig.this;
        }
    }
}

