/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class SerializerBlockPos
implements ISerializer<BlockPos> {
    public static final ISerializer<BlockPos> SERIALIZER = new SerializerBlockPos();

    @Override
    public BlockPos fromJSON(JsonElement json) {
        if (json.isJsonObject()) {
            JsonObject object = json.getAsJsonObject();
            int x = Serializers.INT.fromJSON(object, "x");
            int y = Serializers.INT.fromJSON(object, "y");
            int z = Serializers.INT.fromJSON(object, "z");
            return new BlockPos(x, y, z);
        }
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            if (array.size() == 3) {
                return new BlockPos(array.get(0).getAsInt(), array.get(1).getAsInt(), array.get(2).getAsInt());
            }
            throw new JsonParseException("Invalid number of args in array. Expected 3 but got " + array.size());
        }
        if (json.isJsonPrimitive()) {
            JsonPrimitive primitive = json.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return BlockPos.m_122022_((long)json.getAsLong());
            }
            throw new JsonParseException("Expected JSON primitive to be a number.");
        }
        throw new JsonParseException("BlockPos data is not in a readable format.");
    }

    @Override
    public JsonElement toJSON(BlockPos toWrite) {
        JsonObject object = new JsonObject();
        object.addProperty("x", (Number)toWrite.m_123341_());
        object.addProperty("y", (Number)toWrite.m_123342_());
        object.addProperty("z", (Number)toWrite.m_123343_());
        return object;
    }

    @Override
    public BlockPos fromByteBuf(FriendlyByteBuf buffer) {
        return BlockPos.m_122022_((long)buffer.readLong());
    }

    @Override
    public void toByteBuf(FriendlyByteBuf buffer, BlockPos toWrite) {
        buffer.writeLong(toWrite.m_121878_());
    }

    @Override
    public Tag toNBT(BlockPos toWrite) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("x", toWrite.m_123341_());
        tag.m_128405_("y", toWrite.m_123342_());
        tag.m_128405_("z", toWrite.m_123343_());
        return tag;
    }

    @Override
    public BlockPos fromNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)nbt;
            int x = compound.m_128451_("x");
            int y = compound.m_128451_("y");
            int z = compound.m_128451_("z");
            return new BlockPos(x, y, z);
        }
        if (nbt instanceof ListTag) {
            ListTag list = (ListTag)nbt;
            if (list.size() == 3) {
                return new BlockPos(Serializers.INT.fromNBT(list.get(0)).intValue(), Serializers.INT.fromNBT(list.get(1)).intValue(), Serializers.INT.fromNBT(list.get(2)).intValue());
            }
            throw new NBTParseException("Invalid number of args in array. Expected 3 but got " + list.size());
        }
        if (nbt instanceof NumericTag) {
            NumericTag numberTag = (NumericTag)nbt;
            return BlockPos.m_122022_((long)numberTag.m_7046_());
        }
        throw new NBTParseException("BlockPos data is not in a readable format.");
    }
}

