/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.registry;

import java.util.function.Supplier;
import net.darkhax.bookshelf.api.ClientServices;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.block.IBindRenderLayer;
import net.darkhax.bookshelf.api.block.IItemBlockProvider;
import net.darkhax.bookshelf.api.commands.ICommandBuilder;
import net.darkhax.bookshelf.api.registry.CommandArgumentRegistryEntries;
import net.darkhax.bookshelf.api.registry.IOwnedRegistryEntries;
import net.darkhax.bookshelf.api.registry.RecipeTypeEntries;
import net.darkhax.bookshelf.api.registry.RegistryEntries;
import net.darkhax.bookshelf.api.registry.VillagerTradeEntries;
import net.darkhax.bookshelf.mixin.item.AccessorItem;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;

public class RegistryDataProvider {
    private final String ownerId;
    public final IOwnedRegistryEntries<Block> blocks = new RegistryEntries<Block>(this::getOwner, Registry.f_122901_);
    public final IOwnedRegistryEntries<Fluid> fluids = new RegistryEntries<Fluid>(this::getOwner, Registry.f_122899_);
    public final IOwnedRegistryEntries<Item> items = new RegistryEntries<Item>(this::getOwner, Registry.f_122904_);
    public final IOwnedRegistryEntries<BannerPattern> bannerPatterns = new RegistryEntries<BannerPattern>(this::getOwner, Registry.f_235735_);
    public final IOwnedRegistryEntries<MobEffect> mobEffects = new RegistryEntries<MobEffect>(this::getOwner, Registry.f_122900_);
    public final IOwnedRegistryEntries<SoundEvent> sounds = new RegistryEntries<SoundEvent>(this::getOwner, Registry.f_122898_);
    public final IOwnedRegistryEntries<Potion> potions = new RegistryEntries<Potion>(this::getOwner, Registry.f_122905_);
    public final IOwnedRegistryEntries<Enchantment> enchantments = new RegistryEntries<Enchantment>(this::getOwner, Registry.f_122902_);
    public final IOwnedRegistryEntries<EntityType<?>> entities = new RegistryEntries(this::getOwner, Registry.f_122903_);
    public final IOwnedRegistryEntries<BlockEntityType<?>> blockEntities = new RegistryEntries(this::getOwner, Registry.f_122907_);
    public final IOwnedRegistryEntries<ParticleType<?>> particleTypes = new RegistryEntries(this::getOwner, Registry.f_122906_);
    public final IOwnedRegistryEntries<MenuType<?>> menus = new RegistryEntries(this::getOwner, Registry.f_122913_);
    public final IOwnedRegistryEntries<RecipeSerializer<?>> recipeSerializers = new RegistryEntries(this::getOwner, Registry.f_122915_);
    public final IOwnedRegistryEntries<PaintingVariant> paintings = new RegistryEntries<PaintingVariant>(this::getOwner, Registry.f_235743_);
    public final IOwnedRegistryEntries<Attribute> attributes = new RegistryEntries<Attribute>(this::getOwner, Registry.f_122916_);
    public final IOwnedRegistryEntries<StatType<?>> stats = new RegistryEntries(this::getOwner, Registry.f_122917_);
    public final IOwnedRegistryEntries<VillagerProfession> villagerProfessions = new RegistryEntries<VillagerProfession>(this::getOwner, Registry.f_122809_);
    public final CommandArgumentRegistryEntries commandArguments = new CommandArgumentRegistryEntries(this::getOwner, Registry.f_235724_);
    public final RecipeTypeEntries recipeTypes = new RecipeTypeEntries(this::getOwner);
    public final IOwnedRegistryEntries<ICommandBuilder> commands = new RegistryEntries<ICommandBuilder>(this::getOwner, "Command");
    public final VillagerTradeEntries trades = new VillagerTradeEntries();
    public final IOwnedRegistryEntries<PreparableReloadListener> resourceListeners = new RegistryEntries<PreparableReloadListener>(this::getOwner, "Resource Listener");
    public final IOwnedRegistryEntries<PreparableReloadListener> dataListeners = new RegistryEntries<PreparableReloadListener>(this::getOwner, "Data Listener");
    @Deprecated
    public final IOwnedRegistryEntries<MenuType<?>> menuTypes = this.menus;

    public RegistryDataProvider(String ownerId) {
        this.ownerId = ownerId;
    }

    public final RegistryDataProvider withCreativeTab(Supplier<? extends ItemLike> iconProvider) {
        return this.withCreativeTab(iconProvider, "creative_tab");
    }

    public final RegistryDataProvider withCreativeTab(Supplier<? extends ItemLike> iconProvider, String id) {
        return this.withCreativeTab(Services.CONSTRUCTS.creativeTab(this.ownerId, id).setIcon(iconProvider).build());
    }

    public final RegistryDataProvider withCreativeTab(CreativeModeTab tab) {
        this.items.addRegistryListener((id, item) -> {
            if (item instanceof AccessorItem) {
                AccessorItem accessor = (AccessorItem)item;
                accessor.bookshelf$setCreativeTab(tab);
            }
        });
        return this;
    }

    public final RegistryDataProvider bindBlockRenderLayers() {
        if (Services.PLATFORM.isPhysicalClient()) {
            this.blocks.addRegistryListener((id, block) -> {
                if (block instanceof IBindRenderLayer) {
                    IBindRenderLayer binder = (IBindRenderLayer)block;
                    ClientServices.CLIENT.setRenderType((Block)block, binder.getRenderLayerToBind());
                }
            });
        }
        return this;
    }

    public final RegistryDataProvider withAutoItemBlocks() {
        this.blocks.addRegistryListener((id, block) -> {
            if (block instanceof IItemBlockProvider) {
                IItemBlockProvider provider = (IItemBlockProvider)block;
                if (provider.hasItemBlock((Block)block)) {
                    this.items.add(() -> provider.createItemBlock((Block)block), (ResourceLocation)id);
                }
            } else {
                this.items.add(() -> IItemBlockProvider.DEFAULT.createItemBlock((Block)block), (ResourceLocation)id);
            }
        });
        return this;
    }

    public String getOwner() {
        return this.ownerId;
    }
}

