/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maenchants.common.capabilities.level;

import com.maciej916.maenchants.common.capabilities.level.ILevelCapability;
import com.maciej916.maenchants.common.registries.ModCapabilities;
import com.maciej916.maenchants.common.registries.ModEnchantments;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LevelCapability
implements ILevelCapability,
ICapabilitySerializable<CompoundTag> {
    private final LazyOptional<ILevelCapability> levelCapabilityLazyOptional = LazyOptional.of(() -> this);
    private final Level level;
    public HashMap<Integer, Integer> TRUE_SHOT_ARROWS = new HashMap();

    public LevelCapability(Level level) {
        this.level = level;
    }

    public Level getLevel() {
        return this.level;
    }

    @Override
    public void tick() {
        try {
            Set<Integer> keys = this.TRUE_SHOT_ARROWS.keySet();
            Integer[] array = keys.toArray(new Integer[keys.size()]);
            for (int i = this.TRUE_SHOT_ARROWS.size() - 1; i >= 0; --i) {
                int arrowId = array[i];
                Entity entity = this.level.m_6815_(arrowId);
                boolean toRemove = false;
                if (entity != null && entity.m_6084_()) {
                    if (entity instanceof AbstractArrow) {
                        AbstractArrow abstractArrow = (AbstractArrow)entity;
                        int arrowTickCount = this.TRUE_SHOT_ARROWS.get(arrowId);
                        if (abstractArrow.m_20072_()) {
                            abstractArrow.m_20242_(false);
                            toRemove = true;
                        }
                        if (arrowTickCount >= 400) {
                            toRemove = true;
                            abstractArrow.m_146870_();
                        }
                        this.TRUE_SHOT_ARROWS.put(arrowId, arrowTickCount + 1);
                    }
                } else {
                    toRemove = true;
                }
                if (!toRemove) continue;
                this.TRUE_SHOT_ARROWS.remove(arrowId);
            }
        }
        catch (Exception e) {
            this.TRUE_SHOT_ARROWS = new HashMap();
        }
    }

    @Override
    public void entityJoinLevelEvent(EntityJoinLevelEvent event) {
        this.handleTrueShot(event);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ModCapabilities.LEVEL_CAPABILITY) {
            return this.levelCapabilityLazyOptional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("trueArrowSize", this.TRUE_SHOT_ARROWS.size());
        CompoundTag tagArrows = new CompoundTag();
        int i = 0;
        for (int id : this.TRUE_SHOT_ARROWS.keySet()) {
            tagArrows.m_128405_("id_" + i, id);
            tagArrows.m_128405_("tick_" + i, this.TRUE_SHOT_ARROWS.get(id).intValue());
        }
        tag.m_128365_("trueArrowList", (Tag)tagArrows);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        int trueArrowSize = nbt.m_128451_("trueArrowSize");
        HashMap<Integer, Integer> arrowDes = new HashMap<Integer, Integer>();
        CompoundTag tagArrows = nbt.m_128469_("trueArrowList");
        for (int i = 0; i < trueArrowSize; ++i) {
            arrowDes.put(tagArrows.m_128451_("id_" + i), tagArrows.m_128451_("tick_" + i));
        }
        this.TRUE_SHOT_ARROWS = arrowDes;
    }

    public void handleTrueShot(EntityJoinLevelEvent event) {
        AbstractArrow abstractArrow;
        Entity entity;
        Entity entity2;
        if (!event.getLevel().m_5776_() && (entity2 = event.getEntity()) instanceof AbstractArrow && (entity = (abstractArrow = (AbstractArrow)entity2).m_37282_()) instanceof Player) {
            Player player = (Player)entity;
            ItemStack stack = player.m_21120_(player.m_7655_());
            int lvl = stack.getEnchantmentLevel((Enchantment)ModEnchantments.TRUE_SHOT.get());
            if (lvl == 0) {
                return;
            }
            entity2.m_20242_(true);
            this.TRUE_SHOT_ARROWS.put(abstractArrow.m_19879_(), 0);
        }
    }
}

