/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;

public abstract class ResourceGenerator {
    protected final String modid;
    protected final String modName;
    protected final ResourceCache cache;

    public static DataProvider createDataProvider(final Function<ResourceCache, ResourceGenerator> generator, final ExistingFileHelper existingFileHelper, final DataGenerator dataGenerator) {
        return new DataProvider(){
            private String name = "Resource Generator";

            public void m_213708_(CachedOutput cachedOutput) {
                ResourceCache resourceCache = ResourceCache.wrap(existingFileHelper, cachedOutput, dataGenerator.m_123916_());
                ResourceGenerator resourceGenerator = (ResourceGenerator)generator.apply(resourceCache);
                this.name = resourceGenerator.getName();
                resourceGenerator.generate();
                resourceGenerator.save();
            }

            public String m_6055_() {
                return this.name;
            }
        };
    }

    public ResourceGenerator(String modid, ResourceCache cache) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        String activeMod = ModLoadingContext.get().getActiveNamespace();
        if (activeMod != null && !activeMod.equals("minecraft") && !activeMod.equals("forge")) {
            if (!activeMod.equals(modid)) {
                CoreLib.LOGGER.warn("Mod '" + ModLoadingContext.get().getActiveContainer().getModInfo().getDisplayName() + "' is creating a resource generator with different modid '" + modid + "'!");
            }
        } else if (modid.equals("minecraft") || modid.equals("forge")) {
            CoreLib.LOGGER.warn("Mod is creating a resource generator with modid '" + modid + "'!");
        }
        this.modid = modid;
        this.cache = cache;
        Optional modContainer = ModList.get().getModContainerById(modid);
        this.modName = modContainer.map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(modid);
    }

    public abstract void generate();

    public void save() {
    }

    public String getName() {
        return this.modName + " Resource Generator";
    }

    public final String getOwnerModid() {
        return this.modid;
    }
}

