/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.placementhandlers;

import com.ldtteam.domumornamentum.block.AbstractBlockDoor;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.decorative.FancyDoorBlock;
import com.ldtteam.domumornamentum.block.decorative.FancyTrapdoorBlock;
import com.ldtteam.domumornamentum.block.types.DoorType;
import com.ldtteam.domumornamentum.block.types.FancyDoorType;
import com.ldtteam.domumornamentum.block.types.FancyTrapdoorType;
import com.ldtteam.domumornamentum.block.types.TrapdoorType;
import com.ldtteam.domumornamentum.block.vanilla.TrapdoorBlock;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoDoorBlockPlacementHandler
implements IPlacementHandler {
    public boolean canHandle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        return blockState.m_60734_() instanceof IMateriallyTexturedBlock && blockState.m_60734_() instanceof AbstractBlockDoor;
    }

    public IPlacementHandler.ActionProcessingResult handle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, PlacementSettings settings) {
        if (((DoubleBlockHalf)blockState.m_61143_((Property)DoorBlock.f_52730_)).equals((Object)DoubleBlockHalf.LOWER)) {
            if (world.m_8055_(pos).equals(blockState)) {
                world.m_7471_(pos, false);
                world.m_7471_(pos.m_7494_(), false);
                world.m_7731_(pos, blockState, 3);
                world.m_7731_(pos.m_7494_(), (BlockState)blockState.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER), 3);
                if (tileEntityData != null) {
                    try {
                        PlacementHandlers.handleTileEntityPlacement((CompoundTag)tileEntityData, (Level)world, (BlockPos)pos, (PlacementSettings)settings);
                        PlacementHandlers.handleTileEntityPlacement((CompoundTag)tileEntityData, (Level)world, (BlockPos)pos.m_7494_(), (PlacementSettings)settings);
                    }
                    catch (Exception ex) {
                        Log.getLogger().warn("Unable to place TileEntity");
                    }
                }
                return IPlacementHandler.ActionProcessingResult.PASS;
            }
            world.m_7731_(pos, (BlockState)blockState.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER), 3);
            world.m_7731_(pos.m_7494_(), (BlockState)blockState.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER), 3);
            if (tileEntityData != null) {
                try {
                    PlacementHandlers.handleTileEntityPlacement((CompoundTag)tileEntityData, (Level)world, (BlockPos)pos, (PlacementSettings)settings);
                    PlacementHandlers.handleTileEntityPlacement((CompoundTag)tileEntityData, (Level)world, (BlockPos)pos.m_7494_(), (PlacementSettings)settings);
                }
                catch (Exception ex) {
                    Log.getLogger().warn("Unable to place TileEntity");
                }
            }
        }
        return IPlacementHandler.ActionProcessingResult.SUCCESS;
    }

    public List<ItemStack> getRequiredItems(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        if (tileEntityData != null && ((DoubleBlockHalf)blockState.m_61143_((Property)DoorBlock.f_52730_)).equals((Object)DoubleBlockHalf.LOWER)) {
            BlockPos blockpos = new BlockPos(tileEntityData.m_128451_("x"), tileEntityData.m_128451_("y"), tileEntityData.m_128451_("z"));
            BlockEntity tileEntity = BlockEntity.m_155241_((BlockPos)blockpos, (BlockState)blockState, (CompoundTag)tileEntityData);
            if (tileEntity == null) {
                return Collections.emptyList();
            }
            ItemStack item = BlockUtils.getMaterializedItemStack(null, (BlockEntity)tileEntity);
            if (blockState.m_60734_() instanceof com.ldtteam.domumornamentum.block.vanilla.DoorBlock) {
                item.m_41784_().m_128359_("type", ((DoorType)blockState.m_61143_((Property)com.ldtteam.domumornamentum.block.vanilla.DoorBlock.TYPE)).toString().toUpperCase());
            } else if (blockState.m_60734_() instanceof FancyDoorBlock) {
                item.m_41784_().m_128359_("type", ((FancyDoorType)blockState.m_61143_((Property)FancyDoorBlock.TYPE)).toString().toUpperCase());
            } else if (blockState.m_60734_() instanceof TrapdoorBlock) {
                item.m_41784_().m_128359_("type", ((TrapdoorType)blockState.m_61143_((Property)TrapdoorBlock.TYPE)).toString().toUpperCase());
            } else if (blockState.m_60734_() instanceof FancyTrapdoorBlock) {
                item.m_41784_().m_128359_("type", ((FancyTrapdoorType)blockState.m_61143_((Property)FancyTrapdoorBlock.TYPE)).toString().toUpperCase());
            }
            itemList.add(item);
            itemList.removeIf(ItemStackUtils::isEmpty);
        }
        return itemList;
    }
}

