/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintTagUtils;
import com.ldtteam.structurize.placement.handlers.placement.PlacementError;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.creativetab.ModCreativeTabs;
import com.minecolonies.api.entity.pathfinding.SurfaceType;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.WindowSupplies;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSupplyChestDeployer
extends AbstractItemMinecolonies {
    private static final String SUPPLY_SHIP_STRUCTURE_NAME = "supplyship";
    private static final String SUPPLY_SHIP_STRUCTURE_NAME_NETHER = "nethership";
    private static final int OFFSET_DISTANCE = 14;
    private static final int OFFSET_LEFT = 5;
    private static final int OFFSET_Y = 0;
    private static final int SCAN_HEIGHT = 7;
    private static final int DEFAULT_WATER_LEVELS = 3;

    public ItemSupplyChestDeployer(Item.Properties properties) {
        super("supplychestdeployer", properties.m_41487_(1).m_41491_(ModCreativeTabs.MINECOLONIES));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        if (ctx.m_43725_().f_46443_) {
            if (!((Boolean)MineColonies.getConfig().getServer().allowOtherDimColonies.get()).booleanValue() && !WorldUtil.isOverworldType(ctx.m_43725_())) {
                return InteractionResult.FAIL;
            }
            this.placeSupplyShip(ctx.m_43725_(), ctx.m_8083_().m_121945_(ctx.m_43719_()), ctx.m_43723_().m_6350_());
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (worldIn.f_46443_) {
            if (!((Boolean)MineColonies.getConfig().getServer().allowOtherDimColonies.get()).booleanValue() && !WorldUtil.isOverworldType(worldIn)) {
                MessageUtils.format("com.minecolonies.coremod.dimension.no", new Object[0]).sendTo(playerIn);
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
            }
            this.placeSupplyShip(worldIn, null, playerIn.m_6350_());
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    private void placeSupplyShip(Level world, @Nullable BlockPos pos, @NotNull Direction direction) {
        String name;
        String string = name = WorldUtil.isNetherType(world) ? SUPPLY_SHIP_STRUCTURE_NAME_NETHER : SUPPLY_SHIP_STRUCTURE_NAME;
        if (pos == null) {
            new WindowSupplies(pos, name).open();
            return;
        }
        new WindowSupplies(pos, name).open();
    }

    public static boolean canShipBePlaced(@NotNull Level world, @NotNull BlockPos pos, Blueprint ship, @NotNull List<PlacementError> placementErrorList, Player placer) {
        if (((Boolean)MineColonies.getConfig().getServer().noSupplyPlacementRestrictions.get()).booleanValue()) {
            return true;
        }
        short sizeX = ship.getSizeX();
        short sizeZ = ship.getSizeZ();
        int waterLevel = BlueprintTagUtils.getNumberOfGroundLevels((Blueprint)ship, (int)3);
        BlockPos zeroPos = pos.m_121996_((Vec3i)ship.getPrimaryBlockOffset());
        for (int z = zeroPos.m_123343_(); z < zeroPos.m_123343_() + sizeZ; ++z) {
            for (int x = zeroPos.m_123341_(); x < zeroPos.m_123341_() + sizeX; ++x) {
                for (int y = zeroPos.m_123342_(); y <= zeroPos.m_123342_() + waterLevel + 7; ++y) {
                    if (y < zeroPos.m_123342_() + waterLevel) {
                        ItemSupplyChestDeployer.checkFluidAndNotInColony(world, new BlockPos(x, y, z), placementErrorList, placer);
                        continue;
                    }
                    if (!world.m_8055_(new BlockPos(x, y, z)).m_60767_().m_76333_()) continue;
                    PlacementError placementError = new PlacementError(PlacementError.PlacementErrorType.NEEDS_AIR_ABOVE, new BlockPos(x, y, z));
                    placementErrorList.add(placementError);
                }
            }
        }
        return placementErrorList.isEmpty();
    }

    private static void checkFluidAndNotInColony(Level world, BlockPos pos, @NotNull List<PlacementError> placementErrorList, Player placer) {
        PlacementError placementError;
        boolean isOverworld = WorldUtil.isOverworldType(world);
        boolean isWater = SurfaceType.isWater((BlockGetter)world, pos);
        boolean notInAnyColony = ItemSupplyChestDeployer.hasPlacePermission(world, pos, placer);
        if (!isWater && isOverworld) {
            placementError = new PlacementError(PlacementError.PlacementErrorType.NOT_WATER, pos);
            placementErrorList.add(placementError);
        } else if (!world.m_8055_(pos).m_60819_().m_76152_().m_6212_((Fluid)Fluids.f_76195_) && !isOverworld) {
            placementError = new PlacementError(PlacementError.PlacementErrorType.NOT_WATER, pos);
            placementErrorList.add(placementError);
        }
        if (!notInAnyColony) {
            placementError = new PlacementError(PlacementError.PlacementErrorType.INSIDE_COLONY, pos);
            placementErrorList.add(placementError);
        }
    }

    private static boolean hasPlacePermission(Level world, BlockPos pos, Player placer) {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, pos);
        return colony == null || colony.getPermissions().hasPermission(placer, Action.PLACE_BLOCKS);
    }
}

