/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.herders;

import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingChickenHerder;
import com.minecolonies.coremod.colony.jobs.JobChickenHerder;
import com.minecolonies.coremod.entity.ai.citizen.herders.AbstractEntityAIHerder;
import com.minecolonies.coremod.util.NamedDamageSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkChickenHerder
extends AbstractEntityAIHerder<JobChickenHerder, BuildingChickenHerder, Chicken> {
    private static final int MAX_ANIMALS_PER_LEVEL = 2;
    private static final VisibleCitizenStatus FIND_CHICKEN = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/chickenherder.png"), "com.minecolonies.gui.visiblestatus.chickenherder");

    public EntityAIWorkChickenHerder(@NotNull JobChickenHerder job) {
        super(job);
    }

    @Override
    public Class<BuildingChickenHerder> getExpectedBuildingClass() {
        return BuildingChickenHerder.class;
    }

    @Override
    public ItemStack getBreedingItem() {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42404_);
        stack.m_41764_(2);
        return stack;
    }

    @Override
    public int getMaxAnimalMultiplier() {
        return 2;
    }

    @Override
    public Class<Chicken> getAnimalClass() {
        return Chicken.class;
    }

    @Override
    protected IAIState breedAnimals() {
        this.worker.getCitizenData().setVisibleStatus(FIND_CHICKEN);
        return super.breedAnimals();
    }

    @Override
    protected IAIState butcherAnimals() {
        this.worker.getCitizenData().setVisibleStatus(FIND_CHICKEN);
        return super.butcherAnimals();
    }

    @Override
    protected void butcherAnimal(@Nullable Animal animal) {
        this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.herder.butchering")});
        if (animal != null && !this.walkingToAnimal(animal) && !ItemStackUtils.isEmpty(this.worker.m_21205_()).booleanValue()) {
            this.worker.m_6674_(InteractionHand.MAIN_HAND);
            if (this.worker.m_217043_().m_188503_(1 + (100 - this.getSecondarySkillLevel()) / 5) <= 1) {
                animal.m_6469_((DamageSource)new NamedDamageSource(this.worker.m_7755_().getString(), (Entity)this.worker), (float)this.getButcheringAttackDamage());
                this.worker.getCitizenItemHandler().damageItemInHand(InteractionHand.MAIN_HAND, 1);
            }
        }
    }
}

