/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.herders;

import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIHerder<J extends AbstractJob<?, J>, B extends AbstractBuilding, T extends Animal>
extends AbstractEntityAIInteract<J, B> {
    private static final int ANIMAL_MULTIPLIER = 2;
    private static final int NUM_OF_ANIMALS_TO_BREED = 2;
    protected static final int BUTCHERING_ATTACK_DAMAGE = 5;
    private static final int DISTANCE_TO_BREED = 10;
    private static final int BUTCHER_DELAY = 20;
    private static final int DECIDING_DELAY = 40;
    private static final int BREEDING_DELAY = 40;
    public static final int LIMIT_TO_FEED_CHILDREN = 10;
    private static final int ACTIONS_FOR_DUMP = 10;
    private static final double MAX_ENTITY_AGE = -24000.0;
    protected static final double XP_PER_ACTION = 0.5;

    public AbstractEntityAIHerder(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget((IAIState)AIWorkerState.PREPARING, this::prepareForHerding, 20), new AITarget((IAIState)AIWorkerState.DECIDE, this::decideWhatToDo, 40), new AITarget((IAIState)AIWorkerState.HERDER_BREED, this::breedAnimals, 40), new AITarget((IAIState)AIWorkerState.HERDER_BUTCHER, this::butcherAnimals, 20), new AITarget((IAIState)AIWorkerState.HERDER_PICKUP, this::pickupItems, 20), new AITarget((IAIState)AIWorkerState.HERDER_FEED, this::feedAnimals, 20));
        this.worker.m_21553_(true);
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 10;
    }

    @Override
    @NotNull
    protected List<ItemStack> itemsNiceToHave() {
        List<ItemStack> list = super.itemsNiceToHave();
        if (this.building.getSetting(AbstractBuilding.BREEDING).getValue() || this.building.getSetting(AbstractBuilding.FEEDING).getValue()) {
            list.add(this.getRequestBreedingItems());
        }
        return list;
    }

    @NotNull
    public List<ToolType> getExtraToolsNeeded() {
        ArrayList<ToolType> toolsNeeded = new ArrayList<ToolType>();
        toolsNeeded.add(ToolType.AXE);
        return toolsNeeded;
    }

    @NotNull
    public List<ItemStack> getExtraItemsNeeded() {
        return new ArrayList<ItemStack>();
    }

    public IAIState decideWhatToDo() {
        boolean hasBreedingItem;
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        ArrayList<T> animals = new ArrayList<T>(this.searchForAnimals());
        if (animals.isEmpty()) {
            return AIWorkerState.DECIDE;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.deciding")});
        int numOfBreedableAnimals = 0;
        int numOfFeedableAnimals = 0;
        for (Animal entity : animals) {
            if (this.isBreedAble(entity)) {
                ++numOfBreedableAnimals;
                continue;
            }
            if (!(-24000.0 / (double)entity.m_146764_() <= 1.0 + (double)this.getSecondarySkillLevel() / 100.0)) continue;
            ++numOfFeedableAnimals;
        }
        boolean bl = hasBreedingItem = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.getBreedingItem())) > 1;
        if (!this.searchForItemsInArea().isEmpty()) {
            return AIWorkerState.HERDER_PICKUP;
        }
        if (this.maxAnimals(animals)) {
            return AIWorkerState.HERDER_BUTCHER;
        }
        if (this.canBreedChildren() && numOfBreedableAnimals >= 2 && hasBreedingItem) {
            return AIWorkerState.HERDER_BREED;
        }
        if (this.canFeedChildren() && numOfFeedableAnimals > 0 && hasBreedingItem) {
            return AIWorkerState.HERDER_FEED;
        }
        return AIWorkerState.START_WORKING;
    }

    protected boolean isBreedAble(Animal entity) {
        return entity.m_146764_() == 0 && entity.m_5957_();
    }

    protected boolean canBreedChildren() {
        return this.building.getSetting(AbstractBuilding.BREEDING).getValue();
    }

    protected boolean canFeedChildren() {
        return this.building.getSetting(AbstractBuilding.FEEDING).getValue() && this.getSecondarySkillLevel() >= 10;
    }

    private IAIState startWorkingAtOwnBuilding() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.worker.goingtohut")});
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.PREPARING;
    }

    private IAIState prepareForHerding() {
        for (ToolType tool : this.getExtraToolsNeeded()) {
            if (!this.checkForToolOrWeapon(tool)) continue;
            return this.getState();
        }
        if (this.building.getSetting(AbstractBuilding.BREEDING).getValue() || this.building.getSetting(AbstractBuilding.FEEDING).getValue()) {
            ItemStack breedingItem = this.getBreedingItem();
            this.checkIfRequestForItemExistOrCreateAsync(breedingItem, breedingItem.m_41741_(), breedingItem.m_41613_());
        }
        for (ItemStack item : this.getExtraItemsNeeded()) {
            this.checkIfRequestForItemExistOrCreateAsync(item);
        }
        return AIWorkerState.DECIDE;
    }

    protected IAIState butcherAnimals() {
        ArrayList<T> animals = new ArrayList<T>(this.searchForAnimals());
        if (!this.maxAnimals(animals)) {
            return AIWorkerState.DECIDE;
        }
        if (!this.equipTool(InteractionHand.MAIN_HAND, ToolType.AXE)) {
            return AIWorkerState.START_WORKING;
        }
        Animal animal = animals.stream().filter(animalToButcher -> !animalToButcher.m_6162_() && !animalToButcher.m_27593_()).findFirst().orElse(null);
        if (animal == null) {
            return AIWorkerState.DECIDE;
        }
        this.butcherAnimal(animal);
        if (!animal.m_6084_()) {
            this.worker.getCitizenExperienceHandler().addExperience(0.5);
            this.incrementActionsDoneAndDecSaturation();
        }
        return AIWorkerState.HERDER_BUTCHER;
    }

    protected IAIState breedAnimals() {
        List<T> animals = this.searchForAnimals();
        Animal animalOne = animals.stream().filter(this::isBreedAble).findAny().orElse(null);
        if (animalOne == null) {
            return AIWorkerState.DECIDE;
        }
        Animal animalTwo = animals.stream().filter(animal -> {
            float range = animal.m_20270_((Entity)animalOne);
            boolean isAnimalOne = animalOne.equals(animal);
            return this.isBreedAble((Animal)animal) && range <= 10.0f && !isAnimalOne;
        }).findAny().orElse(null);
        if (animalTwo == null) {
            return AIWorkerState.DECIDE;
        }
        if (!this.equipItem(InteractionHand.MAIN_HAND, this.getBreedingItem())) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.herder.breeding")});
        this.breedTwoAnimals(animalOne, animalTwo);
        this.worker.decreaseSaturationForContinuousAction();
        this.worker.getCitizenItemHandler().removeHeldItem();
        return AIWorkerState.DECIDE;
    }

    protected IAIState feedAnimals() {
        List<T> animals = this.searchForAnimals();
        Animal animalOne = animals.stream().filter(entity -> entity.m_6162_() && -24000.0 / (double)entity.m_146764_() <= 1.0 + (double)this.getSecondarySkillLevel() / 100.0).findAny().orElse(null);
        if (animalOne == null) {
            return AIWorkerState.DECIDE;
        }
        if (!this.equipItem(InteractionHand.MAIN_HAND, this.getBreedingItem())) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.herder.feeding")});
        if (!this.walkingToAnimal(animalOne)) {
            animalOne.m_146740_((int)((float)(-animalOne.m_146764_() / 20) * 0.1f), true);
            this.worker.m_6674_(InteractionHand.MAIN_HAND);
            InventoryUtils.reduceStackInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this.getBreedingItem());
            this.worker.getCitizenExperienceHandler().addExperience(0.5);
            animalOne.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            this.worker.getCitizenItemHandler().removeHeldItem();
            return AIWorkerState.DECIDE;
        }
        this.worker.decreaseSaturationForContinuousAction();
        return this.getState();
    }

    private IAIState pickupItems() {
        List<ItemEntity> items = this.searchForItemsInArea();
        if (!items.isEmpty() && this.walkToBlock(items.get(0).m_20183_())) {
            return this.getState();
        }
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.DECIDE;
    }

    public List<? extends T> searchForAnimals() {
        return WorldUtil.getEntitiesWithinBuilding(this.world, this.getAnimalClass(), this.building, null);
    }

    public int getMaxAnimalMultiplier() {
        return 2;
    }

    public List<? extends ItemEntity> searchForItemsInArea() {
        return WorldUtil.getEntitiesWithinBuilding(this.world, ItemEntity.class, this.building, null);
    }

    public abstract Class<T> getAnimalClass();

    public boolean walkingToAnimal(Animal animal) {
        if (animal != null) {
            this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.herder.goingtoanimal")});
            return this.walkToBlock(new BlockPos(animal.m_20182_()));
        }
        return false;
    }

    private void breedTwoAnimals(Animal animalOne, Animal animalTwo) {
        ArrayList<Animal> animalsToBreed = new ArrayList<Animal>();
        animalsToBreed.add(animalOne);
        animalsToBreed.add(animalTwo);
        for (Animal animal : animalsToBreed) {
            if (animal.m_27593_() || this.walkingToAnimal(animal)) continue;
            animal.m_27595_(null);
            this.worker.m_6674_(InteractionHand.MAIN_HAND);
            InventoryUtils.reduceStackInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this.getBreedingItem());
            this.worker.getCitizenExperienceHandler().addExperience(0.5);
        }
    }

    public boolean maxAnimals(List<T> allAnimals) {
        int maxAnimals;
        List animals = allAnimals.stream().filter(animalToButcher -> !animalToButcher.m_6162_()).collect(Collectors.toList());
        if (animals.isEmpty()) {
            return false;
        }
        int numOfAnimals = animals.size();
        return numOfAnimals > (maxAnimals = this.building.getBuildingLevel() * this.getMaxAnimalMultiplier());
    }

    public boolean equipTool(InteractionHand hand, ToolType toolType) {
        if (this.getToolSlot(toolType) != -1) {
            this.worker.getCitizenItemHandler().setHeldItem(hand, this.getToolSlot(toolType));
            return true;
        }
        return false;
    }

    private int getToolSlot(ToolType toolType) {
        int slot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)this.getInventory(), toolType, 0, this.building.getMaxToolLevel());
        if (slot == -1) {
            this.checkForToolOrWeapon(toolType);
        }
        return slot;
    }

    public boolean equipItem(InteractionHand hand, ItemStack itemStack) {
        if (this.checkIfRequestForItemExistOrCreateAsync(itemStack)) {
            this.worker.getCitizenItemHandler().setHeldItem(hand, this.getItemSlot(itemStack.m_41720_()));
            return true;
        }
        return false;
    }

    public int getItemSlot(Item item) {
        return InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getInventory(), item);
    }

    protected void butcherAnimal(@Nullable Animal animal) {
        this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.herder.butchering")});
        if (animal != null && !this.walkingToAnimal(animal) && !ItemStackUtils.isEmpty(this.worker.m_21205_()).booleanValue()) {
            this.worker.m_6674_(InteractionHand.MAIN_HAND);
            FakePlayer fp = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.worker.m_20193_()));
            DamageSource ds = DamageSource.m_19344_((Player)fp);
            animal.m_6469_(ds, (float)this.getButcheringAttackDamage());
            this.worker.getCitizenItemHandler().damageItemInHand(InteractionHand.MAIN_HAND, 1);
        }
    }

    public double getButcheringAttackDamage() {
        return 5.0;
    }

    public ItemStack getRequestBreedingItems() {
        ItemStack breedingItem = this.getBreedingItem().m_41777_();
        ItemStackUtils.setSize(breedingItem, breedingItem.m_41613_() * 8);
        return breedingItem;
    }

    public abstract ItemStack getBreedingItem();
}

