/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers.core;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.INonExhaustiveDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.AbstractDeliverymanRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Delivery;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.coremod.colony.requestsystem.requesters.BuildingBasedRequester;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractRequestResolver;
import com.minecolonies.coremod.tileentities.TileEntityWareHouse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWarehouseRequestResolver
extends AbstractRequestResolver<IDeliverable> {
    public AbstractWarehouseRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    protected boolean isRequestFromSelf(IRequest<?> requestToCheck) {
        return requestToCheck.getRequester().getClass().equals(this.getClass());
    }

    @Override
    public TypeToken<? extends IDeliverable> getRequestType() {
        return TypeConstants.DELIVERABLE;
    }

    protected abstract boolean internalCanResolve(List<TileEntityWareHouse> var1, IRequest<? extends IDeliverable> var2);

    @Override
    public boolean canResolveRequest(@NotNull IRequestManager manager, IRequest<? extends IDeliverable> requestToCheck) {
        BuildingBasedRequester requester;
        Optional<IRequester> building;
        if (requestToCheck.getRequester() instanceof BuildingBasedRequester && (building = (requester = (BuildingBasedRequester)requestToCheck.getRequester()).getBuilding(manager, requestToCheck.getRequester().getId())).isPresent() && building.get() instanceof BuildingWareHouse) {
            return false;
        }
        if (!manager.getColony().getWorld().f_46443_) {
            if (!this.isRequestChainValid(manager, requestToCheck)) {
                return false;
            }
            Colony colony = (Colony)manager.getColony();
            try {
                return this.internalCanResolve(AbstractWarehouseRequestResolver.getWareHousesInColony(colony, requestToCheck.getRequester().getLocation().getInDimensionLocation()), requestToCheck);
            }
            catch (Exception e) {
                Log.getLogger().error((Object)e);
            }
        }
        return false;
    }

    public boolean isRequestChainValid(@NotNull IRequestManager manager, IRequest<?> requestToCheck) {
        if (this.isRequestFromSelf(requestToCheck)) {
            return false;
        }
        if (!requestToCheck.hasParent()) {
            return true;
        }
        IRequest<?> parentRequest = manager.getRequestForToken((IToken<?>)requestToCheck.getParent());
        if (parentRequest == null) {
            return true;
        }
        return this.isRequestChainValid(manager, parentRequest);
    }

    @Override
    @Nullable
    public List<IToken<?>> attemptResolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
        if (manager.getColony().getWorld().f_46443_) {
            return Lists.newArrayList();
        }
        if (!(manager.getColony() instanceof Colony)) {
            return Lists.newArrayList();
        }
        Colony colony = (Colony)manager.getColony();
        List<TileEntityWareHouse> wareHouses = AbstractWarehouseRequestResolver.getWareHousesInColony(colony, request.getRequester().getLocation().getInDimensionLocation());
        int totalRequested = request.getRequest().getCount();
        int totalAvailable = 0;
        if (request.getRequest() instanceof INonExhaustiveDeliverable) {
            totalAvailable -= ((INonExhaustiveDeliverable)request.getRequest()).getLeftOver();
        }
        for (TileEntityWareHouse tile : wareHouses) {
            List<Tuple<ItemStack, BlockPos>> inv = tile.getMatchingItemStacksInWarehouse(itemStack -> ((IDeliverable)request.getRequest()).matches((ItemStack)itemStack));
            for (Tuple<ItemStack, BlockPos> stack : inv) {
                if (stack.getA().m_41619_()) continue;
                totalAvailable += stack.getA().m_41613_();
            }
        }
        if (totalAvailable >= totalRequested || totalAvailable >= request.getRequest().getMinimumCount()) {
            return Lists.newArrayList();
        }
        if (totalAvailable < 0) {
            totalAvailable = 0;
        }
        int totalRemainingRequired = totalRequested - totalAvailable;
        IDeliverable remainingRequest = request.getRequest().copyWithCount(totalRemainingRequired);
        return Lists.newArrayList((Object[])new IToken[]{manager.createRequest(this, remainingRequest)});
    }

    @Override
    public void resolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
        manager.updateRequestState((IToken<?>)request.getId(), RequestState.RESOLVED);
    }

    @Override
    @Nullable
    public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> completedRequest) {
        if (manager.getColony().getWorld().f_46443_) {
            return null;
        }
        Colony colony = (Colony)manager.getColony();
        List<TileEntityWareHouse> wareHouses = AbstractWarehouseRequestResolver.getWareHousesInColony(colony, completedRequest.getRequester().getLocation().getInDimensionLocation());
        ArrayList deliveries = Lists.newArrayList();
        int remainingCount = completedRequest.getRequest().getCount();
        HashMap<ItemStorage, Integer> storages = new HashMap<ItemStorage, Integer>();
        int keep = completedRequest.getRequest() instanceof INonExhaustiveDeliverable ? ((INonExhaustiveDeliverable)completedRequest.getRequest()).getLeftOver() : 0;
        block0: for (TileEntityWareHouse wareHouse : wareHouses) {
            List<Tuple<ItemStack, BlockPos>> targetStacks = wareHouse.getMatchingItemStacksInWarehouse(itemStack -> ((IDeliverable)completedRequest.getRequest()).matches((ItemStack)itemStack));
            for (Tuple<ItemStack, BlockPos> tuple : targetStacks) {
                int kept;
                if (ItemStackUtils.isEmpty(tuple.getA()).booleanValue()) continue;
                int leftOver = tuple.getA().m_41613_();
                if (keep > 0 && (kept = storages.getOrDefault(new ItemStorage(tuple.getA()), 0).intValue()) < keep) {
                    if (leftOver + kept <= keep) {
                        storages.put(new ItemStorage(tuple.getA()), storages.getOrDefault(new ItemStorage(tuple.getA()), 0) + tuple.getA().m_41613_());
                        continue;
                    }
                    int toKeep = leftOver + kept - keep;
                    leftOver -= toKeep;
                    storages.put(new ItemStorage(tuple.getA()), storages.getOrDefault(new ItemStorage(tuple.getA()), 0) + toKeep);
                }
                int count = Math.min(remainingCount, leftOver);
                ItemStack matchingStack = tuple.getA().m_41777_();
                matchingStack.m_41764_(count);
                completedRequest.addDelivery(matchingStack);
                ILocation itemStackLocation = manager.getFactoryController().getNewInstance(TypeConstants.ILOCATION, tuple.getB(), wareHouse.m_58904_().m_46472_());
                Delivery delivery = new Delivery(itemStackLocation, completedRequest.getRequester().getLocation(), matchingStack, AbstractDeliverymanRequestable.getDefaultDeliveryPriority(true));
                IToken<?> requestToken = manager.createRequest((IRequester)manager.getFactoryController().getNewInstance(TypeToken.of(this.getClass()), completedRequest.getRequester().getLocation(), completedRequest.getId()), delivery);
                deliveries.add(manager.getRequestForToken(requestToken));
                if ((remainingCount -= count) > 0) continue;
                break block0;
            }
        }
        return deliveries.isEmpty() ? null : deliveries;
    }

    @Override
    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    @Override
    public void onAssignedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    protected static List<TileEntityWareHouse> getWareHousesInColony(Colony colony, BlockPos requesterPosition) {
        ArrayList<TileEntityWareHouse> wareHouses = new ArrayList<TileEntityWareHouse>();
        for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
            if (!(building instanceof BuildingWareHouse) || building.getTileEntity() == null) continue;
            wareHouses.add((TileEntityWareHouse)building.getTileEntity());
        }
        wareHouses.sort((w1, w2) -> {
            double dist1 = w1.getPosition().m_123331_((Vec3i)requesterPosition);
            double dist2 = w2.getPosition().m_123331_((Vec3i)requesterPosition);
            return Double.compare(dist1, dist2);
        });
        return wareHouses;
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    @NotNull
    public MutableComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        return Component.m_237115_((String)"com.minecolonies.coremod.buildings.warehouse.name");
    }

    @Override
    public int getPriority() {
        return 150;
    }
}

