/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.render.worldevent;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.client.StructureClientHandler;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.client.render.worldevent.WorldEventContext;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class ColonyPatrolPointRenderer {
    private static BlueprintPreviewData partolPointTemplate;
    private static Future<Blueprint> pendingTemplate;

    static void render(WorldEventContext ctx) {
        if (ctx.mainHandItem.m_41720_() != ModItems.scepterGuard || !ctx.mainHandItem.m_41782_()) {
            return;
        }
        CompoundTag itemStackNbt = ctx.mainHandItem.m_41783_();
        IColonyView colony = IColonyManager.getInstance().getColonyView(itemStackNbt.m_128451_("id"), (ResourceKey<Level>)ctx.clientLevel.m_46472_());
        if (colony == null) {
            return;
        }
        IBuildingView guardTowerView = colony.getBuilding(BlockPosUtil.read(itemStackNbt, "pos"));
        if (guardTowerView == null) {
            return;
        }
        if (pendingTemplate == null && partolPointTemplate == null) {
            pendingTemplate = StructurePacks.getBlueprintFuture((String)"Minecolonies Original", (String)"infrastructure/misc/patrolpoint.blueprint");
            return;
        }
        if (pendingTemplate != null && pendingTemplate.isDone()) {
            try {
                BlueprintPreviewData tempPreviewData = new BlueprintPreviewData();
                tempPreviewData.setBlueprint(pendingTemplate.get());
                tempPreviewData.setPos(BlockPos.f_121853_);
                partolPointTemplate = tempPreviewData;
                pendingTemplate = null;
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            return;
        }
        if (guardTowerView instanceof AbstractBuildingGuards.View) {
            AbstractBuildingGuards.View guardTower = (AbstractBuildingGuards.View)guardTowerView;
            StructureClientHandler.renderStructureAtPosList((BlueprintPreviewData)partolPointTemplate, (float)ctx.partialTicks, guardTower.getPatrolTargets(), (PoseStack)ctx.poseStack);
        }
    }
}

