/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.client.gui.WindowBuildBuilding;
import com.minecolonies.coremod.client.gui.WindowHutAllInventory;
import com.minecolonies.coremod.client.gui.WindowHutNameEntry;
import com.minecolonies.coremod.client.gui.WindowInfo;
import com.minecolonies.coremod.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.BuildRequestMessage;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWindowModuleBuilding<B extends IBuildingView>
extends AbstractModuleWindow {
    protected final B building;
    private final Text title;
    private final Button buttonBuild;

    public AbstractWindowModuleBuilding(B building, String resource) {
        super((IBuildingView)building, resource);
        this.building = building;
        this.registerButton("build", this::buildClicked);
        this.registerButton("info", this::infoClicked);
        this.registerButton("inventory", this::inventoryClicked);
        this.registerButton("editName", this::editName);
        this.registerButton("allinventory", this::allInventoryClicked);
        this.title = (Text)this.findPaneOfTypeByID("name", Text.class);
        this.buttonBuild = (Button)this.findPaneOfTypeByID("build", Button.class);
        Button buttonInfo = (Button)this.findPaneOfTypeByID("info", Button.class);
        if (buttonInfo != null) {
            buttonInfo.setVisible(I18n.m_118936_((String)("com.minecolonies.coremod.info." + building.getBuildingType().getTranslationKey().replace("com.minecolonies.building.", "") + ".0")));
        }
    }

    private void editName() {
        @NotNull WindowHutNameEntry window = new WindowHutNameEntry((IBuildingView)this.building);
        window.open();
    }

    private void infoClicked() {
        @NotNull WindowInfo window = new WindowInfo((IBuildingView)this.building);
        window.open();
    }

    private void allInventoryClicked() {
        @NotNull WindowHutAllInventory window = new WindowHutAllInventory((IBuildingView)this.building, (BOWindow)this);
        window.open();
    }

    private void buildClicked() {
        String buttonLabel;
        String string = buttonLabel = this.buttonBuild.getText().m_214077_() instanceof TranslatableContents ? ((TranslatableContents)this.buttonBuild.getText().m_214077_()).m_237508_() : this.buttonBuild.getTextAsString();
        if (buttonLabel.equalsIgnoreCase("com.minecolonies.coremod.gui.workerhuts.cancelbuild") || buttonLabel.equalsIgnoreCase("com.minecolonies.coremod.gui.workerhuts.cancelupgrade")) {
            Network.getNetwork().sendToServer(new BuildRequestMessage((IBuildingView)this.building, BuildRequestMessage.Mode.BUILD, BlockPos.f_121853_));
        } else if (buttonLabel.equalsIgnoreCase("com.minecolonies.coremod.gui.workerhuts.cancelrepair")) {
            Network.getNetwork().sendToServer(new BuildRequestMessage((IBuildingView)this.building, BuildRequestMessage.Mode.REPAIR, BlockPos.f_121853_));
        } else if (buttonLabel.equalsIgnoreCase("com.minecolonies.coremod.gui.workerhuts.canceldeconstruction")) {
            Network.getNetwork().sendToServer(new BuildRequestMessage((IBuildingView)this.building, BuildRequestMessage.Mode.REMOVE, BlockPos.f_121853_));
        } else {
            @NotNull WindowBuildBuilding window = new WindowBuildBuilding(this.building.getColony(), (IBuildingView)this.building);
            window.open();
        }
    }

    private void inventoryClicked() {
        Network.getNetwork().sendToServer(new OpenInventoryMessage((IBuildingView)this.building));
    }

    public void onUpdate() {
        super.onUpdate();
        this.updateButtonBuild((IBuildingView)this.building);
    }

    public String getBuildingName() {
        return "com." + this.buildingView.getBuildingType().getRegistryName().m_135827_() + ".building." + this.buildingView.getBuildingType().getRegistryName().m_135815_();
    }

    private void updateButtonBuild(IBuildingView buildingView) {
        if (this.buttonBuild == null) {
            return;
        }
        if (buildingView.isBuilding()) {
            if (buildingView.getBuildingLevel() == 0) {
                this.buttonBuild.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.cancelbuild"));
            } else {
                this.buttonBuild.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.cancelupgrade"));
            }
        } else if (buildingView.isRepairing()) {
            this.buttonBuild.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.cancelrepair"));
        } else if (buildingView.isDeconstructing()) {
            this.buttonBuild.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.canceldeconstruction"));
        } else {
            this.buttonBuild.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.buildrepair"));
        }
    }

    public void onOpened() {
        super.onOpened();
        this.setPage(false, 0);
        if (this.title != null) {
            MutableComponent component = this.building.getCustomName().isEmpty() ? Component.m_237115_((String)this.getBuildingName()) : Component.m_237113_((String)this.building.getCustomName());
            MutableComponent componentWithLevel = component.m_130946_(" ").m_130946_(String.valueOf(this.buildingView.getBuildingLevel()));
            this.title.setText(componentWithLevel);
        }
    }
}

